/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.antlr.runtime.ClassicToken;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.api.DebuggerDelegate;
import org.antlr.works.debugger.events.DBEvent;
import org.antlr.works.debugger.events.DBEventEnterRule;
import org.antlr.works.debugger.events.DBEventExitRule;
import org.antlr.works.debugger.events.DBEventLocation;
import org.antlr.works.debugger.input.DBInputTextTokenInfo;
import org.antlr.works.debugger.local.DBLocal;
import org.antlr.works.debugger.panels.DBControlPanel;
import org.antlr.works.debugger.panels.DBEventsPanel;
import org.antlr.works.debugger.panels.DBInputPanel;
import org.antlr.works.debugger.panels.DBOutputPanel;
import org.antlr.works.debugger.panels.DBStackPanel;
import org.antlr.works.debugger.remote.DBRemoteConnectDialog;
import org.antlr.works.debugger.tivo.DBPlayer;
import org.antlr.works.debugger.tivo.DBPlayerContextInfo;
import org.antlr.works.debugger.tivo.DBRecorder;
import org.antlr.works.debugger.tree.DBASTModel;
import org.antlr.works.debugger.tree.DBASTPanel;
import org.antlr.works.debugger.tree.DBParseTreeModel;
import org.antlr.works.debugger.tree.DBParseTreePanel;
import org.antlr.works.editor.GrammarWindowTab;
import org.antlr.works.grammar.element.ElementBlock;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.utils.Console;
import org.antlr.works.utils.CustomSplitPanel;
import org.antlr.works.utils.DetachablePanel;
import org.antlr.works.utils.DetachablePanelDelegate;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.swing.XJRotableToggleButton;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggerTab
extends GrammarWindowTab
implements DetachablePanelDelegate {
    public static final String DEFAULT_LOCAL_ADDRESS = "localhost";
    public static final String NOTIF_DEBUG_STARTED = "NOTIF_DEBUG_STARTED";
    public static final String NOTIF_DEBUG_STOPPED = "NOTIF_DEBUG_STOPPED";
    public static final int OPTION_NONE = 0;
    public static final int OPTION_AGAIN = 1;
    public static final int OPTION_BUILD = 2;
    public static final int OPTION_RUN = 4;
    public static final float PERCENT_WIDTH_LEFT = 0.2f;
    public static final float PERCENT_WIDTH_MIDDLE = 0.5f;
    protected JPanel panel;
    protected DBInputPanel inputPanel;
    protected DBOutputPanel outputPanel;
    protected DBParseTreePanel parseTreePanel;
    protected DBParseTreeModel parseTreeModel;
    protected DBASTPanel astPanel;
    protected DBASTModel astModel;
    protected DBStackPanel stackPanel;
    protected DBEventsPanel eventsPanel;
    protected DBControlPanel controlPanel;
    protected CustomSplitPanel splitPanel;
    protected Map<Component, XJRotableToggleButton> components2toggle;
    protected Map<Integer, Set<String>> breakpoints;
    protected DBLocal local;
    protected DBRecorder recorder;
    protected DBPlayer player;
    protected boolean running;
    protected long dateOfModificationOnDisk = 0L;
    private boolean closing = false;
    private String startRule;
    private DebuggerDelegate delegate;
    private String rootGrammarName;
    public static final int TOGGLE_INPUT = 0;
    public static final int TOGGLE_OUTPUT = 1;
    public static final int TOGGLE_PTREE = 2;
    public static final int TOGGLE_AST = 3;
    public static final int TOGGLE_STACK = 4;
    public static final int TOGGLE_EVENTS = 5;

    public DebuggerTab(DebuggerDelegate delegate) {
        super(null);
        this.delegate = delegate;
    }

    public void awake() {
        this.panel = new JPanel(new BorderLayout());
        this.splitPanel = new CustomSplitPanel();
        this.components2toggle = new HashMap<Component, XJRotableToggleButton>();
        this.controlPanel = new DBControlPanel(this);
        this.inputPanel = new DBInputPanel(this);
        this.inputPanel.setTag(0);
        this.outputPanel = new DBOutputPanel(this);
        this.outputPanel.setTag(0);
        this.parseTreePanel = new DBParseTreePanel(this);
        this.parseTreePanel.setTag(1);
        this.parseTreeModel = this.parseTreePanel.getModel();
        this.astPanel = new DBASTPanel(this);
        this.astPanel.setTag(1);
        this.astModel = this.astPanel.getModel();
        this.stackPanel = new DBStackPanel(this);
        this.stackPanel.setTag(2);
        this.eventsPanel = new DBEventsPanel(this);
        this.eventsPanel.setTag(2);
        this.panel.add((Component)this.controlPanel, "North");
        this.panel.add((Component)this.splitPanel, "Center");
        this.panel.add((Component)this.createToggleButtons(), "South");
        this.local = new DBLocal(this);
        this.recorder = new DBRecorder(this);
        this.player = new DBPlayer(this);
        this.updateStatusInfo();
    }

    public void close() {
        this.closing = true;
        this.debuggerStop(true);
        this.splitPanel.close();
        this.controlPanel.close();
        this.inputPanel.close();
        this.outputPanel.close();
        this.parseTreePanel.close();
        this.astPanel.close();
        this.stackPanel.close();
        this.eventsPanel.close();
        this.local.close();
        this.recorder.close();
        this.player.close();
        this.parseTreeModel.close();
        this.astModel.close();
        for (XJRotableToggleButton b : this.components2toggle.values()) {
            b.removeAllActionListeners();
        }
        this.delegate = null;
    }

    public void componentShouldLayout(Dimension size) {
        this.assemblePanelsIntoSplitPane(size.width);
    }

    public Box createToggleButtons() {
        Box b = Box.createHorizontalBox();
        b.add(this.createToggleButton("Input", 0, this.inputPanel));
        b.add(this.createToggleButton("Output", 1, this.outputPanel));
        b.add(Box.createHorizontalStrut(15));
        b.add(this.createToggleButton("Parse Tree", 2, this.parseTreePanel));
        b.add(this.createToggleButton("AST", 3, this.astPanel));
        b.add(Box.createHorizontalStrut(15));
        b.add(this.createToggleButton("Stack", 4, this.stackPanel));
        b.add(this.createToggleButton("Events", 5, this.eventsPanel));
        b.add(Box.createHorizontalGlue());
        return b;
    }

    public XJRotableToggleButton createToggleButton(String title, final int tag, Component c) {
        XJRotableToggleButton b = new XJRotableToggleButton(title);
        b.setFocusable(false);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebuggerTab.this.performToggleButtonAction(tag);
            }
        });
        this.components2toggle.put(c, b);
        return b;
    }

    public void assemblePanelsIntoSplitPane(int width) {
        this.setComponentVisible(this.inputPanel, true);
        this.setComponentVisible(this.outputPanel, false);
        this.setComponentVisible(this.parseTreePanel, true);
        this.setComponentVisible(this.astPanel, false);
        this.setComponentVisible(this.stackPanel, true);
        this.setComponentVisible(this.eventsPanel, false);
        this.splitPanel.setComponentWidth(this.inputPanel, (float)width * 0.2f);
        this.splitPanel.setComponentWidth(this.outputPanel, (float)width * 0.2f);
        this.splitPanel.setComponentWidth(this.parseTreePanel, (float)width * 0.5f);
        this.splitPanel.setComponentWidth(this.astPanel, (float)width * 0.5f);
        this.splitPanel.setComponents(this.inputPanel, this.parseTreePanel, this.stackPanel);
    }

    public void setComponentVisible(Component c, boolean flag) {
        c.setVisible(flag);
        XJRotableToggleButton b = this.components2toggle.get(c);
        b.setSelected(flag);
    }

    public void performToggleButtonAction(int tag) {
        switch (tag) {
            case 0: {
                this.toggleComponents(this.inputPanel, this.outputPanel, 0);
                break;
            }
            case 1: {
                this.toggleComponents(this.outputPanel, this.inputPanel, 0);
                break;
            }
            case 2: {
                this.toggleComponents(this.parseTreePanel, this.astPanel, 1);
                break;
            }
            case 3: {
                this.toggleComponents(this.astPanel, this.parseTreePanel, 1);
                break;
            }
            case 4: {
                this.toggleComponents(this.stackPanel, this.eventsPanel, 2);
                break;
            }
            case 5: {
                this.toggleComponents(this.eventsPanel, this.stackPanel, 2);
            }
        }
    }

    public void toggleComponents(DetachablePanel c, DetachablePanel other, int index) {
        c.setVisible(!c.isVisible());
        if (c.isVisible()) {
            if (!other.isDetached()) {
                this.setComponentVisible(other, false);
            }
            if (!c.isDetached()) {
                this.splitPanel.setComponent(c, index);
            }
        } else if (other.isVisible() && !other.isDetached()) {
            this.splitPanel.setComponent(other, index);
        } else {
            this.splitPanel.setComponent(null, index);
        }
    }

    public void toggleInputTokensBox() {
        this.inputPanel.toggleInputTokensBox();
    }

    public boolean isInputTokenVisible() {
        return this.inputPanel.isInputTokensBoxVisible();
    }

    public DBOutputPanel getOutputPanel() {
        return this.outputPanel;
    }

    public DBRecorder getRecorder() {
        return this.recorder;
    }

    public DBPlayer getPlayer() {
        return this.player;
    }

    public DebuggerDelegate getDelegate() {
        return this.delegate;
    }

    public List<ElementBlock> getBlocks() {
        return this.delegate.getBlocks();
    }

    public Container getWindowContainer() {
        return XJApplication.getActiveContainer();
    }

    public Container getContainer() {
        return this.panel;
    }

    public Console getConsole() {
        return this.delegate.getConsole();
    }

    public void updateStatusInfo() {
        this.controlPanel.updateStatusInfo();
    }

    public void breaksOnEvent() {
        this.inputPanel.updateOnBreakEvent();
        this.parseTreePanel.updateOnBreakEvent();
        this.astPanel.updateOnBreakEvent();
        this.stackPanel.updateOnBreakEvent();
        this.eventsPanel.updateOnBreakEvent();
    }

    public boolean needsToGenerateGrammar() {
        return this.dateOfModificationOnDisk != this.delegate.getDocument().getDateOfModificationOnDisk() || this.delegate.getDocument().isDirty();
    }

    public void grammarGenerated() {
        this.delegate.getDocument().autoSave();
        this.dateOfModificationOnDisk = this.delegate.getDocument().getDateOfModificationOnDisk();
    }

    public void queryGrammarBreakpoints() {
        this.breakpoints = this.delegate.getBreakpoints();
    }

    public boolean isBreakpointAtLine(int line, String name) {
        if (this.breakpoints == null) {
            return false;
        }
        Set<String> names = this.breakpoints.get(line);
        if (names == null) {
            return false;
        }
        return names.contains(name);
    }

    public boolean isBreakpointAtToken(Token token) {
        return this.inputPanel.isBreakpointAtToken(token);
    }

    public void selectToken(Token token, DBEventLocation location) {
        if (token != null) {
            DBInputTextTokenInfo info = this.inputPanel.getTokenInfoForToken(token);
            if (info == null) {
                this.selectGrammarText(location);
            } else {
                this.selectGrammarText(info.getLocation());
            }
        } else {
            this.selectGrammarText(location);
        }
        this.inputPanel.selectToken(token);
        this.parseTreePanel.selectToken(token);
        this.astPanel.selectToken(token);
    }

    public void selectGrammarText(DBEventLocation location) {
        if (location != null) {
            this.delegate.debuggerSelectText(location.getGrammarName(), location.line, location.pos);
        }
    }

    public void setGrammarLocation(DBEventLocation location) {
        if (location != null) {
            this.delegate.debuggerSetLocation(location.getGrammarName(), location.line, location.pos);
        }
    }

    public void resetGrammarLocation() {
        this.delegate.debuggerSetLocation(this.rootGrammarName, -1, -1);
    }

    public List<ElementRule> getRules() {
        return this.delegate.getRules();
    }

    public List<ElementRule> getSortedRules() {
        return this.delegate.getSortedRules();
    }

    public void setStartRule(String rule) {
        this.startRule = rule;
    }

    public String getStartRule() {
        if (this.startRule == null && !this.getRules().isEmpty()) {
            this.startRule = this.getRules().get((int)0).name;
        }
        return this.startRule;
    }

    public String getEventsAsString() {
        return this.eventsPanel.getEventsAsString();
    }

    public int getNumberOfEvents() {
        return this.eventsPanel.getNumberOfEvents();
    }

    public void launchLocalDebugger(int options) {
        if (this.needsToGenerateGrammar()) {
            if (AWPrefs.getDebuggerAskGen()) {
                int result = XJAlert.createInstance().displayCustomAlert(this.getWindowContainer(), "Generate and compile", "The grammar has been modified and needs to be generated and compiled again. You can choose to cancel the operation, to continue without generating and compiling the grammar or to generate and compile the grammar.", new String[]{"Cancel", "Continue", "Generate and compile"}, 2, 0);
                switch (result) {
                    case 0: {
                        return;
                    }
                    case 2: {
                        options |= 2;
                    }
                }
            } else {
                options |= 2;
            }
        }
        if ((options & 2) > 0 && !this.delegate.ensureDocumentSaved()) {
            return;
        }
        if ((options & 2) > 0 || !this.local.isRequiredFilesExisting()) {
            this.local.prepareAndLaunch(options);
            this.grammarGenerated();
        } else {
            this.local.prepareAndLaunch(options);
        }
    }

    public boolean debuggerLocalDidRun(boolean build) {
        if (build) {
            StatisticsAW.shared().recordEvent(93);
        } else {
            StatisticsAW.shared().recordEvent(92);
        }
        return this.debuggerLaunch(DEFAULT_LOCAL_ADDRESS, AWPrefs.getDebugDefaultLocalPort(), false);
    }

    public void launchRemoteDebugger() {
        StatisticsAW.shared().recordEvent(94);
        DBRemoteConnectDialog dialog = new DBRemoteConnectDialog(this.getWindowContainer());
        if (dialog.runModal() == 1) {
            this.debuggerLaunch(dialog.getAddress(), dialog.getPort(), true);
        }
    }

    public boolean debuggerLaunch(String address, int port, boolean remote) {
        if (remote && !this.debuggerLaunchGrammar()) {
            XJAlert.display(this.getWindowContainer(), "Error", "Cannot launch the debuggerTab.\nException while parsing grammar.");
            return false;
        }
        this.queryGrammarBreakpoints();
        this.rootGrammarName = this.delegate.getGrammarName();
        this.inputPanel.prepareForGrammar(this.delegate.getGrammarEngine());
        this.player.setInputBuffer(this.inputPanel.getInputBuffer());
        this.recorder.connect(address, port);
        return true;
    }

    public void showEditTestRig() {
        this.local.showEditTestRig();
    }

    public void connectionSuccess() {
        this.running = true;
        XJNotificationCenter.defaultCenter().postNotification(this, NOTIF_DEBUG_STARTED);
        this.delegate.debuggerStarted();
        this.player.resetPlayEvents(true);
    }

    public void connectionFailed() {
        XJAlert.display(this.getWindowContainer(), "Connection Error", "Cannot launch the debuggerTab.\nTime-out waiting to connect to the remote parser.");
    }

    public void connectionCancelled() {
    }

    public boolean debuggerLaunchGrammar() {
        try {
            this.delegate.getGrammarEngine().analyze();
        }
        catch (Exception e) {
            this.getConsole().print(e);
            return false;
        }
        return true;
    }

    public void debuggerStop(boolean force) {
        if (this.recorder.getStatus() == 1) {
            if (force || XJAlert.displayAlertYESNO(this.getWindowContainer(), "Stopping", "The debuggerTab is currently stopping. Do you want to force stop it ?") == 0) {
                this.local.forceStop();
                this.recorder.stop();
            }
        } else {
            this.recorder.requestStop();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void resetGUI() {
        this.stackPanel.clear();
        this.eventsPanel.clear();
        this.parseTreePanel.clear();
        this.astPanel.clear();
    }

    public void addEvent(DBEvent event, DBPlayerContextInfo info) {
        this.eventsPanel.addEvent(event, info);
    }

    public void playEvents(List events, int lastEventPosition, boolean reset) {
        this.player.playEvents(events, lastEventPosition, reset);
        this.breaksOnEvent();
    }

    public void playerSetLocation(DBEventLocation location) {
        this.parseTreeModel.setLocation(location);
    }

    public void playerPushRule(DBEventEnterRule rule) {
        this.stackPanel.pushRule(rule);
        this.parseTreeModel.pushRule(rule.name);
        this.astModel.pushRule(rule.name);
    }

    public void playerPopRule(DBEventExitRule ruleName) {
        this.stackPanel.popRule();
        this.parseTreeModel.popRule();
        this.astModel.popRule();
    }

    public void playerConsumeToken(Token token) {
        this.parseTreeModel.addToken(token);
    }

    public void playerRecognitionException(Exception e) {
        this.parseTreeModel.addException(e);
    }

    public void playerBeginBacktrack(int level) {
        this.parseTreeModel.beginBacktrack(level);
    }

    public void playerEndBacktrack(int level, boolean success) {
        this.parseTreeModel.endBacktrack(level, success);
    }

    public void playerNilNode(int id) {
        this.astModel.nilNode(id);
    }

    public void playerErrorNode(int id, String text) {
        this.astModel.errorNode(id, text);
    }

    public void playerCreateNode(int id, Token token) {
        this.astModel.createNode(id, token);
    }

    public void playerCreateNode(int id, String text, int type) {
        this.astModel.createNode(id, new ClassicToken(type, text));
    }

    public void playerBecomeRoot(int newRootID, int oldRootID) {
        this.astModel.becomeRoot(newRootID, oldRootID);
    }

    public void playerAddChild(int rootID, int childID) {
        this.astModel.addChild(rootID, childID);
    }

    public void playerSetTokenBoundaries(int id, int startIndex, int stopIndex) {
    }

    public void recorderStatusDidChange() {
        if (this.closing) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DebuggerTab.this.updateStatusInfo();
            }
        });
    }

    public void recorderDidStop() {
        if (this.closing) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DebuggerTab.this.resetGrammarLocation();
                DebuggerTab.this.inputPanel.stop();
                DebuggerTab.this.running = false;
                DebuggerTab.this.delegate.debuggerStopped();
                XJNotificationCenter.defaultCenter().postNotification(this, DebuggerTab.NOTIF_DEBUG_STOPPED);
            }
        });
    }

    @Override
    public boolean canExportToBitmap() {
        return this.getExportableGView() != null;
    }

    @Override
    public boolean canExportToEPS() {
        return this.getExportableGView() != null;
    }

    @Override
    public GView getExportableGView() {
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (Utils.isComponentChildOf(c, this.parseTreePanel)) {
            return this.parseTreePanel.getGraphView();
        }
        if (Utils.isComponentChildOf(c, this.astPanel)) {
            return this.astPanel.getGraphView();
        }
        return null;
    }

    @Override
    public String getTabName() {
        return "DebuggerTab";
    }

    @Override
    public Component getTabComponent() {
        return this.getContainer();
    }

    public JPopupMenu treeGetContextualMenu() {
        ContextualMenuFactory factory = this.delegate.createContextualMenuFactory();
        factory.addItem(111);
        factory.addItem(110);
        return factory.menu;
    }

    @Override
    public void panelDoDetach(DetachablePanel panel) {
        this.splitPanel.setComponent(null, panel.getTag());
    }

    @Override
    public void panelDoAttach(DetachablePanel panel) {
        Component c = this.splitPanel.getComponentAtIndex(panel.getTag());
        if (c != null) {
            c.setVisible(false);
            this.splitPanel.setComponent(null, panel.getTag());
            XJRotableToggleButton button = this.components2toggle.get(c);
            button.setSelected(false);
        }
        this.splitPanel.setComponent(panel, panel.getTag());
    }

    @Override
    public void panelDoClose(DetachablePanel panel) {
        XJRotableToggleButton button = this.components2toggle.get(panel);
        button.setSelected(false);
    }

    @Override
    public Container panelParentContainer() {
        return this.delegate.getContainer();
    }

    public boolean canDebugAgain() {
        return this.local.canDebugAgain();
    }

    public void warning(Object o, String message) {
        this.getConsole().println("[" + o.getClass().getName() + " - event " + this.getNumberOfEvents() + "] Warning: " + message, 1);
    }

    public void selectConsoleTab() {
        this.delegate.selectConsoleTab();
    }
}

