/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.object;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.antlr.xjlib.appkit.gview.base.Anchor2D;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.shape.SLabel;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public class GElementRect
extends GElement
implements XJXMLSerializable {
    public static final int DEFAULT_WIDTH = 40;
    public static final int DEFAULT_HEIGHT = 40;
    protected double width = 40.0;
    protected double height = 40.0;

    public void setPositionOfUpperLeftCorner(double x, double y) {
        this.setPosition(x + this.width * 0.5, y + this.height * 0.5);
    }

    public void setSize(double width, double height) {
        this.width = width;
        this.height = height;
        this.elementDimensionDidChange();
    }

    public void setWidth(double width) {
        this.width = width;
        this.elementDimensionDidChange();
    }

    public double getWidth() {
        return this.width;
    }

    public void setHeight(double height) {
        this.height = height;
        this.elementDimensionDidChange();
    }

    public double getHeight() {
        return this.height;
    }

    public void updateAnchors() {
        this.setAnchor("CENTER", this.position.copy(), Anchor2D.DIRECTION_FREE);
        this.setAnchor("TOP", new Vector2D(0.0, -this.height * 0.5).append(this.position), Anchor2D.DIRECTION_TOP);
        this.setAnchor("BOTTOM", new Vector2D(0.0, this.height * 0.5).append(this.position), Anchor2D.DIRECTION_BOTTOM);
        this.setAnchor("LEFT", new Vector2D(-this.width * 0.5, 0.0).append(this.position), Anchor2D.DIRECTION_LEFT);
        this.setAnchor("RIGHT", new Vector2D(this.width * 0.5, 0.0).append(this.position), Anchor2D.DIRECTION_RIGHT);
    }

    public Rect getFrame() {
        double x = this.getPositionX() - this.getWidth() * 0.5;
        double y = this.getPositionY() - this.getHeight() * 0.5;
        double dx = this.getWidth();
        double dy = this.getHeight();
        return new Rect(x, y, dx, dy);
    }

    public boolean isInside(Point p) {
        return this.getFrame().contains(p);
    }

    public void draw(Graphics2D g) {
        if (this.isVisibleInClip(g)) {
            if (this.labelVisible) {
                g.setColor(this.labelColor);
                if (this.label != null && this.label.length() > 0) {
                    this.drawLabel(g);
                }
            }
            g.setColor(this.color);
            g.setStroke(this.strokeSize);
            this.drawShape(g);
            g.setStroke(this.strokeNormal);
        }
    }

    public void drawShape(Graphics2D g) {
        super.drawShape(g);
        Rectangle r = this.getFrame().rectangle();
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    public void drawLabel(Graphics2D g) {
        SLabel.drawCenteredString(this.label, (int)this.getPositionX(), (int)this.getPositionY(), g);
    }
}

