/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.app;

import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.antlr.xjlib.appkit.app.XJApplicationDelegate;
import org.antlr.xjlib.appkit.app.XJApplicationInterface;
import org.antlr.xjlib.appkit.app.XJPreferences;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.document.XJDocumentFactory;
import org.antlr.xjlib.appkit.frame.XJFrame;
import org.antlr.xjlib.appkit.frame.XJFrameDelegate;
import org.antlr.xjlib.appkit.frame.XJPanel;
import org.antlr.xjlib.appkit.frame.XJWindow;
import org.antlr.xjlib.appkit.frame.XJWindowInterface;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJAlertInput;
import org.antlr.xjlib.appkit.utils.XJFileChooser;
import org.antlr.xjlib.appkit.utils.XJLocalizable;
import org.antlr.xjlib.foundation.XJObject;
import org.antlr.xjlib.foundation.XJSystem;
import org.antlr.xjlib.foundation.timer.XJScheduledTimer;
import org.antlr.xjlib.foundation.timer.XJScheduledTimerDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJApplication
extends XJObject
implements XJApplicationInterface,
XJFrameDelegate {
    public static final boolean YES = true;
    public static final boolean NO = false;
    public static final String XJ_PREFS_RECENT_FILES = "XJ_PREFS_RECENT_FILES";
    protected static XJApplicationInterface shared = null;
    protected static XJApplicationDelegate delegate = null;
    protected static List<XJScheduledTimer> scheduledTimers = new ArrayList<XJScheduledTimer>();
    protected static final long SCHEDULED_TIMER_MINUTES = 1L;
    protected static List<XJWindow> windows = new ArrayList<XJWindow>();
    public static final int MAX_RECENT_FILES = 10;
    protected static List<String> recentFiles = null;
    protected static int documentAbsoluteCount = 0;
    protected static int documentAbsPositionCount = 0;
    protected static final int DOCUMENT_OFFSET_PIXELS = 20;
    protected static List<XJDocumentFactory> documentFactories = new ArrayList<XJDocumentFactory>();
    protected static String propertiesPath = "";
    protected static boolean startingUp = true;
    protected static String[] launchArguments = null;
    protected static List<String> documentsToOpenAtStartup = new ArrayList<String>();
    protected static String appName = "";
    protected XJPreferences userPrefs = new XJPreferences(this.getPreferencesClass());
    protected XJFrame about = null;
    protected XJPanel prefs = null;
    protected static XJScheduledTimerDelegate autoSaveTimer = null;
    private static boolean useDesktopMode;

    public static synchronized void setShared(XJApplicationInterface shared) {
        XJApplication.shared = shared;
    }

    public static synchronized XJApplicationInterface shared() {
        if (shared == null) {
            if (XJSystem.isMacOS()) {
                try {
                    shared = (XJApplication)Class.forName("org.antlr.xjlib.appkit.app.MacOS.XJApplicationMacOS").newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("XJApplication: cannot instanciate the MacOS application (" + e + ")");
                }
            }
            if (shared == null) {
                shared = new XJApplication();
            }
            ((XJApplication)shared).startup();
        }
        return shared;
    }

    public static String getAppVersionShort() {
        return delegate.appVersionShort();
    }

    public static String getAppVersionLong() {
        return delegate.appVersionLong();
    }

    public static XJApplicationDelegate getAppDelegate() {
        return delegate;
    }

    public static Container getActiveContainer() {
        Frame[] frame;
        for (Frame f : frame = Frame.getFrames()) {
            if (!f.isActive() || !f.isVisible() || f.getSize().width == 0 || f.getSize().height == 0) continue;
            return f;
        }
        return null;
    }

    public XJApplication() {
        recentFiles = this.userPrefs.getList(XJ_PREFS_RECENT_FILES);
        if (recentFiles == null) {
            recentFiles = new ArrayList<String>();
        }
        XJMainMenuBar.refreshAllRecentFilesMenu();
    }

    public static void run(XJApplicationDelegate delegate, String[] args, String applicationName) {
        appName = applicationName;
        if (XJSystem.isMacOS()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", applicationName);
        }
        XJApplication.run(delegate, args);
    }

    public static void run(XJApplicationDelegate delegate, String[] args) {
        XJApplication.setDelegate(delegate);
        launchArguments = args;
        useDesktopMode = XJApplication.delegate.useDesktopMode();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                startingUp = false;
                delegate.appDidLaunch(launchArguments, documentsToOpenAtStartup);
                documentsToOpenAtStartup.clear();
                new Timer().schedule((TimerTask)new ScheduledTimer(), 1000L, 60000L);
            }
        });
    }

    protected void startup() {
        if (this.hasPreferencesMenuItem()) {
            this.addPreferencesMenuItem();
        } else {
            this.removePreferencesMenuItem();
        }
    }

    protected void updateRecentFilesPrefs() {
        this.userPrefs.setList(XJ_PREFS_RECENT_FILES, recentFiles);
        this.userPrefs.flush();
    }

    protected void shutdown() {
        this.updateRecentFilesPrefs();
        System.exit(0);
    }

    public static void setDelegate(XJApplicationDelegate delegate) {
        XJApplication.delegate = delegate;
    }

    public static void addScheduledTimer(XJScheduledTimerDelegate delegate, long minutes, boolean scheduleAtStartup) {
        scheduledTimers.add(new XJScheduledTimer(delegate, minutes, scheduleAtStartup));
    }

    public static void removeScheduledTimer(XJScheduledTimerDelegate delegate) {
        for (int index = scheduledTimers.size() - 1; index >= 0; --index) {
            XJScheduledTimer timer = scheduledTimers.get(index);
            if (timer.getDelegate() != delegate) continue;
            scheduledTimers.remove(timer);
        }
    }

    public static void setPropertiesPath(String path) {
        propertiesPath = path;
    }

    public static String getPropertiesPath() {
        return propertiesPath;
    }

    @Override
    public String getApplicationName() {
        if (delegate != null) {
            return delegate.appName();
        }
        return "";
    }

    @Override
    public XJPreferences getPreferences() {
        return this.userPrefs;
    }

    @Override
    public void displayAbout() {
        boolean awake;
        boolean bl = awake = this.about == null;
        if (this.about == null) {
            this.about = delegate.appInstanciateAboutPanel();
        }
        if (this.about == null) {
            return;
        }
        if (awake) {
            this.about.setDelegate(this);
            this.about.awake();
        }
        this.about.setVisible(true);
    }

    @Override
    public void displayPrefs() {
        if (this.prefs == null) {
            try {
                this.prefs = (XJPanel)delegate.appPreferencesPanelClass().newInstance();
                this.prefs.setDelegate(this);
                this.prefs.awake();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Cannot instanciate the Preferences panel: " + e);
                return;
            }
            this.prefs.center();
        }
        this.prefs.setVisible(true);
    }

    @Override
    public void displayHelp() {
        delegate.appShowHelp();
    }

    @Override
    public void frameDidClose(XJFrame frame) {
        if (frame == this.prefs) {
            this.prefs = null;
        }
        if (frame == this.about) {
            this.about = null;
        }
    }

    @Override
    public void addRecentFile(String file) {
        if (file == null) {
            return;
        }
        if (recentFiles.contains(file)) {
            recentFiles.remove(file);
        }
        if (recentFiles.size() > 10) {
            recentFiles.remove(recentFiles.size() - 1);
        }
        recentFiles.add(0, file);
        this.updateRecentFilesPrefs();
        XJMainMenuBar.refreshAllRecentFilesMenu();
    }

    @Override
    public void removeRecentFile(String file) {
        recentFiles.remove(file);
        this.updateRecentFilesPrefs();
        XJMainMenuBar.refreshAllRecentFilesMenu();
    }

    @Override
    public void clearRecentFiles() {
        recentFiles.clear();
        this.updateRecentFilesPrefs();
        XJMainMenuBar.refreshAllRecentFilesMenu();
    }

    @Override
    public List recentFiles() {
        return recentFiles;
    }

    protected void addPreferencesMenuItem() {
    }

    protected void removePreferencesMenuItem() {
    }

    public static void addDocumentFactory(Class documentClass, Class windowClass, Class dataClass, String ext, String description) {
        XJApplication.addDocumentFactory(new XJDocumentFactory(documentClass, windowClass, dataClass, ext, description));
    }

    public static void addDocumentFactory(XJDocumentFactory factory) {
        documentFactories.add(factory);
    }

    public static boolean handlesDocument(XJDocument doc) {
        if (doc == null) {
            return false;
        }
        for (XJDocumentFactory factory : documentFactories) {
            if (!factory.handlesPath(doc.getDocumentPath())) continue;
            return true;
        }
        return false;
    }

    public XJDocumentFactory getDocumentTypeForPath(String path) {
        for (XJDocumentFactory factory : documentFactories) {
            if (!factory.handlesPath(path)) continue;
            return factory;
        }
        return null;
    }

    @Override
    public List getDocumentExtensions() {
        ArrayList<List<String>> ext = new ArrayList<List<String>>();
        for (XJDocumentFactory factory : documentFactories) {
            ext.add(factory.getExtensions());
        }
        return ext;
    }

    public List<String> getDocumentDescriptions() {
        ArrayList<String> descr = new ArrayList<String>();
        for (XJDocumentFactory factory : documentFactories) {
            descr.add(factory.getDescriptionString());
        }
        return descr;
    }

    public XJDocumentFactory askForDocumentType() {
        if (documentFactories.size() == 1) {
            return documentFactories.get(0);
        }
        int index = XJAlertInput.showInputDialog(null, XJLocalizable.getXJString("AppNewDocTitle"), XJLocalizable.getXJString("AppNewDocMessage"), this.getDocumentDescriptions(), this.getDocumentDescriptions().get(0));
        if (index == -1) {
            return null;
        }
        return documentFactories.get(index);
    }

    public XJDocument newDocument(boolean visible, XJDocumentFactory docFactory) {
        XJDocument document;
        if (documentFactories.size() == 0) {
            XJAlert.display(null, XJLocalizable.getXJString("AppNewDocErrTitle"), XJLocalizable.getXJString("AppNewDocErrMessage"));
            return null;
        }
        if (docFactory == null && (docFactory = this.askForDocumentType()) == null) {
            return null;
        }
        try {
            document = docFactory.createDocument();
            document.awake();
            if (this.supportsPersistence()) {
                document.setTitle(XJLocalizable.getXJString("AppUntitled") + " " + documentAbsoluteCount);
            } else {
                document.setTitle(documentAbsoluteCount > 0 ? appName + " " + documentAbsoluteCount : appName);
            }
            XJWindowInterface window = document.getWindow();
            if (!window.isMaximized() && this.useDesktopMode()) {
                ++documentAbsoluteCount;
                window.offsetPosition(documentAbsPositionCount * 20, documentAbsPositionCount * 20);
                documentAbsPositionCount = window.isCompletelyOnScreen() ? ++documentAbsPositionCount : 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            XJAlert.display(null, XJLocalizable.getXJString("AppNewDocError"), e.toString());
            return null;
        }
        if (visible) {
            document.showWindow();
        }
        return document;
    }

    @Override
    public XJDocument newDocument() {
        XJDocument document = this.newDocument(true, null);
        if (document != null) {
            delegate.displayNewDocumentWizard(document);
        }
        return document;
    }

    @Override
    public boolean openDocuments(List<String> files) {
        boolean success = true;
        for (String file : files) {
            if (this.openDocument(file)) continue;
            success = false;
        }
        return success;
    }

    @Override
    public boolean openDocument(String file) {
        if (file == null) {
            return false;
        }
        if (startingUp) {
            documentsToOpenAtStartup.add(file);
            return true;
        }
        XJWindow window = this.getWindowContainingDocumentForPath(file);
        if (window != null) {
            window.selectDocument(window.getDocumentForPath(file));
            window.bringToFront();
            return true;
        }
        XJDocument document = this.newDocument(false, this.getDocumentTypeForPath(file));
        if (document == null) {
            return false;
        }
        if (this.loadDocument(file, document)) {
            this.addRecentFile(file);
            document.showWindow();
            this.closeFirstCreatedWindowIfNonDirty(document.getWindow());
            return true;
        }
        document.getWindow().performClose(true);
        return false;
    }

    public boolean loadDocument(String file, XJDocument doc) {
        try {
            return doc.load(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            XJAlert.display(null, XJLocalizable.getXJString("DocError"), XJLocalizable.getXJString("DocLoadError") + " " + e.toString());
            return false;
        }
    }

    @Override
    public boolean openDocument() {
        return XJFileChooser.shared().displayOpenDialog(null, this.getDocumentExtensions(), this.getDocumentDescriptions(), false) && this.openDocument(XJFileChooser.shared().getSelectedFilePath());
    }

    @Override
    public boolean openLastUsedDocument() {
        if (recentFiles.isEmpty()) {
            return false;
        }
        String file = recentFiles.get(0);
        while (!new File(file).exists()) {
            recentFiles.remove(0);
            if (recentFiles.isEmpty()) {
                this.updateRecentFilesPrefs();
                return false;
            }
            file = recentFiles.get(0);
        }
        this.updateRecentFilesPrefs();
        if (this.openDocument(file)) {
            return true;
        }
        this.removeRecentFile(file);
        return false;
    }

    public void closeFirstCreatedWindowIfNonDirty(XJWindowInterface excludeWindow) {
        for (XJWindow window : windows) {
            if (window.hasDirtyDocument() || window.hasDocumentsWithFileAssociated() || window == excludeWindow) continue;
            window.performClose(false);
            break;
        }
    }

    @Override
    public XJWindow getWindowContainingDocumentForPath(String path) {
        for (XJWindow window : windows) {
            XJDocument doc = window.getDocumentForPath(path);
            if (doc == null) continue;
            return window;
        }
        return null;
    }

    @Override
    public XJWindow getActiveWindow() {
        for (XJWindow window : windows) {
            if (!window.isActive()) continue;
            return window;
        }
        return null;
    }

    @Override
    public void addWindow(XJWindow window) {
        windows.add(window);
    }

    public int getNumberOfNonAuxiliaryWindows() {
        int count = 0;
        for (XJWindow window : windows) {
            if (window.isAuxiliaryWindow()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void removeWindow(XJWindow window) {
        windows.remove(window);
        if (this.getNumberOfNonAuxiliaryWindows() == 0 && !startingUp && (!XJSystem.isMacOS() && !this.useDesktopMode() || this.shouldQuitAfterLastWindowClosed())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    XJApplication.this.performQuit();
                }
            });
        }
    }

    @Override
    public List<XJWindow> getWindows() {
        return windows;
    }

    @Override
    public List<XJWindow> getWindowsInWindowMenu() {
        ArrayList<XJWindow> wim = new ArrayList<XJWindow>();
        for (XJWindow w : windows) {
            if (!w.shouldAppearsInWindowMenu()) continue;
            wim.add(w);
        }
        return wim;
    }

    public static void setAutoSave(boolean enabled, int delayInMinutes) {
        if (autoSaveTimer == null) {
            autoSaveTimer = new AutoSaveTimer();
        }
        XJApplication.removeScheduledTimer(autoSaveTimer);
        if (enabled) {
            XJApplication.addScheduledTimer(autoSaveTimer, delayInMinutes, false);
        }
    }

    public void performPreferences() {
        this.displayPrefs();
    }

    @Override
    public void performQuit() {
        delegate.appWillTerminate();
        for (XJWindow window : new ArrayList<XJWindow>(windows)) {
            if (window.performClose(false)) continue;
            return;
        }
        XJFrame.closeDesktop();
        this.shutdown();
    }

    @Override
    public boolean supportsPersistence() {
        return delegate == null || delegate.supportsPersistence();
    }

    @Override
    public boolean hasPreferencesMenuItem() {
        return delegate == null || delegate.appHasPreferencesMenuItem();
    }

    public boolean shouldQuitAfterLastWindowClosed() {
        return delegate != null && delegate.appShouldQuitAfterLastWindowClosed();
    }

    @Override
    public boolean useDesktopMode() {
        return useDesktopMode;
    }

    public Class getPreferencesClass() {
        if (delegate == null) {
            return XJApplication.class;
        }
        return delegate.appPreferencesClass();
    }

    public static class AutoSaveTimer
    implements XJScheduledTimerDelegate {
        public void scheduledTimerFired(boolean startup) {
            for (XJWindow window : windows) {
                window.saveAll();
            }
        }
    }

    protected static class ScheduledTimer
    extends TimerTask {
        protected boolean startup = true;

        protected ScheduledTimer() {
        }

        public void run() {
            for (XJScheduledTimer timer : scheduledTimers) {
                timer.fire(this.startup, 1L);
            }
            this.startup = false;
        }
    }
}

