/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.stringtemplate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.antlr.works.components.ComponentWindow;
import org.antlr.works.components.container.ComponentContainer;
import org.antlr.works.components.container.ComponentContainerInternal;
import org.antlr.works.components.document.ComponentDocument;
import org.antlr.works.components.editor.ComponentEditor;
import org.antlr.works.debugger.Debugger;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.menu.ActionDebugger;
import org.antlr.works.menu.ActionGoTo;
import org.antlr.works.menu.ActionRefactor;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.stringtemplate.ComponentContainerStringTemplateMenu;
import org.antlr.works.stringtemplate.ComponentEditorStringTemplate;
import org.antlr.works.stringtemplate.ComponentToolbarStringTemplate;
import org.antlr.works.stringtemplate.STDocumentFactory;
import org.antlr.works.stringtemplate.STDocumentInternal;
import org.antlr.works.stringtemplate.STWindow;
import org.antlr.works.stringtemplate.menu.ContextualStringTemplateMenuFactory;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.swing.XJTabbedPane;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.foundation.XJUtils;

public class ComponentContainerStringTemplate
implements ComponentContainer {
    private final Set<ComponentContainer> containers = new LinkedHashSet<ComponentContainer>();
    private final Map<Component, ComponentContainer> componentToContainer = new HashMap<Component, ComponentContainer>();
    private ComponentEditor editor;
    private ComponentContainer selectedContainer;
    private ComponentContainerStringTemplateMenu componentContainerStringTemplateMenu;
    private ComponentToolbarStringTemplate toolbar;
    private XJTabbedPane editorsTab;
    private JPanel toolbarPanel;
    private JPanel rulesPanel;
    private JPanel mainPanel;
    private EditorsTabChangeListener etc;
    private final List<EditorTab> tabs = new ArrayList<EditorTab>();
    private final Set<String> loadedStringTemplateFileNames = new HashSet<String>();
    private final ComponentWindow window;

    public ComponentContainerStringTemplate(ComponentWindow window) {
        this.window = window;
        this.selectedContainer = this;
        this.containers.add(this);
        this.componentContainerStringTemplateMenu = new ComponentContainerStringTemplateMenu(this);
        this.toolbar = new ComponentToolbarStringTemplate(this);
    }

    public void awake() {
        this.editorsTab = new XJTabbedPane();
        this.toolbarPanel = new JPanel(new BorderLayout());
        this.toolbarPanel.setBorder(null);
        this.rulesPanel = new JPanel(new BorderLayout());
        this.rulesPanel.setBorder(null);
        this.etc = new EditorsTabChangeListener();
        this.editorsTab.addChangeListener(this.etc);
    }

    public void assemble(boolean separateRules) {
        JSplitPane verticalSplit = new JSplitPane();
        verticalSplit.setBorder(null);
        verticalSplit.setOrientation(1);
        verticalSplit.setRightComponent(this.editorsTab);
        verticalSplit.setLeftComponent(this.rulesPanel);
        verticalSplit.setContinuousLayout(false);
        verticalSplit.setOneTouchExpandable(true);
        verticalSplit.setResizeWeight(0.25);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(null);
        this.mainPanel.add((Component)this.toolbarPanel, "North");
        this.mainPanel.add((Component)verticalSplit, "Center");
        this.window.setContentPanel(this.mainPanel);
    }

    public void refreshMainMenuBar() {
        if (this.getXJFrame().getMainMenuBar() != null) {
            this.getXJFrame().getMainMenuBar().refreshState();
        }
    }

    public void addStringTemplate(ComponentContainer container) {
        JPanel c = container.getEditor().getPanel();
        this.componentToContainer.put(c, container);
        this.containers.add(container);
    }

    public boolean loadStringTemplate(String name) {
        String fileName = name + ".st";
        String folder = this.getDocument().getDocumentFolder();
        if (folder == null) {
            return false;
        }
        String file = XJUtils.concatPath(folder, fileName);
        if (!new File(file).exists()) {
            return false;
        }
        if (this.loadedStringTemplateFileNames.contains(fileName)) {
            return true;
        }
        this.loadedStringTemplateFileNames.add(fileName);
        STDocumentFactory factory = new STDocumentFactory(STWindow.class);
        STDocumentInternal doc = factory.createInternalDocument(this);
        ComponentContainerInternal container = (ComponentContainerInternal)doc.getContainer();
        doc.awake();
        try {
            doc.load(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.window.addDocument(doc);
        this.addStringTemplate(container);
        return true;
    }

    public ComponentContainer getContainerForName(String name) {
        for (ComponentContainer c : this.containers) {
            if (!XJUtils.getPathByDeletingPathExtension(c.getDocument().getDocumentName()).equals(name)) continue;
            return c;
        }
        return null;
    }

    public ComponentEditor selectEditor(String name) {
        ComponentContainer c = this.getContainerForName(name);
        if (c != null) {
            return this.selectEditor(c);
        }
        return null;
    }

    public void selectEditor(XJDocument doc) {
        for (ComponentContainer c : this.containers) {
            if (c.getDocument() != doc) continue;
            this.selectEditor(c);
            break;
        }
    }

    private ComponentEditor selectEditor(ComponentContainer c) {
        JPanel panel = c.getEditor().getPanel();
        if (!this.editorsTab.hasComponent(panel)) {
            this.editorsTab.addComponent(c.getDocument().getDocumentName(), panel);
        }
        this.editorsTab.selectComponent(panel);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentContainerStringTemplate.this.getSelectedEditor().getTextEditor().getTextPane().requestFocus();
            }
        });
        return this.getSelectedEditor();
    }

    public void dirtyChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentContainerStringTemplate.this.updateEditorDirtyFlag();
            }
        });
    }

    public void editorContentChanged() {
        this.updateEditorDirtyFlag();
    }

    public Debugger getDebugger() {
        return null;
    }

    public ActionDebugger getActionDebugger() {
        return null;
    }

    private void updateEditorDirtyFlag() {
        for (ComponentContainer c : this.containers) {
            JPanel panel = c.getEditor().getPanel();
            int index = this.editorsTab.indexOfComponent(panel);
            if (index == -1) continue;
            String title = c.getDocument().getDocumentName();
            if (title == null) {
                title = "";
            }
            if (c.getDocument().isDirty()) {
                this.editorsTab.setTitleAt(index, "* " + title);
                continue;
            }
            this.editorsTab.setTitleAt(index, title);
        }
    }

    public ComponentToolbarStringTemplate getToolbar() {
        return this.toolbar;
    }

    public ComponentEditor getSelectedEditor() {
        return this.getSelectedContainer().getEditor();
    }

    public ComponentContainer getSelectedContainer() {
        return this.selectedContainer;
    }

    public ActionRefactor getActionRefactor() {
        return this.componentContainerStringTemplateMenu.getActionRefactor();
    }

    public ActionGoTo getActionGoTo() {
        return this.componentContainerStringTemplateMenu.getActionGoTo();
    }

    public void saveAll() {
        for (ComponentContainer container : this.containers) {
            container.getDocument().save(false);
        }
    }

    public ContextualMenuFactory createContextualMenuFactory() {
        return null;
    }

    public ContextualStringTemplateMenuFactory createContextualStringTemplateMenuFactory() {
        return new ContextualStringTemplateMenuFactory(this.componentContainerStringTemplateMenu);
    }

    public JPopupMenu getContextualMenu(int textIndex) {
        return this.componentContainerStringTemplateMenu.getContextualMenu(textIndex);
    }

    public EditorTab getSelectedTab() {
        return null;
    }

    public void selectTab(Component c) {
    }

    public ComponentContainerStringTemplateMenu getComponentContainerStringTemplateMenu() {
        return this.componentContainerStringTemplateMenu;
    }

    public boolean close() {
        for (ComponentContainer container : this.containers) {
            if (container == this) continue;
            container.close();
        }
        this.componentContainerStringTemplateMenu.close();
        this.editor.close();
        this.toolbar.close();
        return true;
    }

    public void setDocument(ComponentDocument document) {
        this.window.setDocument(document);
    }

    public ComponentDocument getDocument() {
        return (ComponentDocument)this.window.getDocument();
    }

    public Dimension getSize() {
        return this.window.getSize();
    }

    public void becomingVisibleForTheFirstTime() {
        this.addStringTemplate(this);
        this.selectEditor(this);
        this.getSelectedEditor().becomingVisibleForTheFirstTime();
        for (ComponentContainer container : this.containers) {
            if (container == this) continue;
            container.becomingVisibleForTheFirstTime();
        }
    }

    public void setDirty() {
        this.window.setDirty();
    }

    public void createFile(String name) {
        String path = this.getEditor().getDocument().getDocumentFolder();
        String file = XJUtils.concatPath(path, name + ".stg");
        String content = "group " + name + ";\n";
        try {
            XJUtils.writeStringToFile(content, file);
        }
        catch (IOException e) {
            XJAlert.display(this.window.getJavaContainer(), "Create File Error", "Cannot create file '" + name + "' because:\n" + e.toString());
            return;
        }
        this.selectEditor(name);
    }

    public void setEditor(ComponentEditor editor) {
        this.editor = editor;
    }

    public ComponentEditor getEditor() {
        return this.editor;
    }

    public XJFrameInterface getXJFrame() {
        return this.window;
    }

    public XJMainMenuBar getMainMenuBar() {
        return this.window.getMainMenuBar();
    }

    public void customizeFileMenu(XJMenu menu) {
        this.componentContainerStringTemplateMenu.customizeFileMenu(menu);
    }

    public void customizeMenuBar(XJMainMenuBar menubar) {
        this.componentContainerStringTemplateMenu.customizeMenuBar(menubar);
    }

    public void menuItemState(XJMenuItem item) {
        this.componentContainerStringTemplateMenu.menuItemState(item);
    }

    public void handleMenuSelected(XJMenu menu) {
    }

    public JComponent getRulesComponent() {
        return this.rulesPanel;
    }

    public JComponent getEditorComponent() {
        return this.mainPanel;
    }

    public void windowActivated() {
        for (ComponentContainer container : this.containers) {
            container.getEditor().componentActivated();
        }
        for (EditorTab et : this.tabs) {
            et.editorActivated();
        }
    }

    public void documentLoaded(ComponentDocument document) {
    }

    public void editorParsed(ComponentEditor editor) {
    }

    public void selectConsoleTab(ComponentEditor editor) {
    }

    public void selectInterpreterTab(ComponentEditor editor) {
    }

    public void selectSyntaxDiagramTab(ComponentEditor editor) {
    }

    public int getSimilarTab(EditorTab tab) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            EditorTab t = this.tabs.get(i);
            if (!t.getTabName().equals(tab.getTabName())) continue;
            return i;
        }
        return -1;
    }

    public void addTab(EditorTab tab) {
    }

    public void setComponent(JPanel panel, EditorTab tab) {
        this.setComponent(panel, tab.getTabComponent());
    }

    private void switchToEditor(final ComponentEditorStringTemplate editor) {
        this.setComponent(this.toolbarPanel, this.toolbar.getToolbar());
        this.setComponent(this.rulesPanel, editor.getComponentRules());
        this.toolbar.updateStates();
        editor.refreshMainMenuBar();
        this.window.setTitle(this.selectedContainer.getDocument().getDocumentPath());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                editor.getTextEditor().getTextPane().requestFocus();
            }
        });
    }

    public void setComponent(JPanel panel, Component c) {
        panel.removeAll();
        panel.add(c);
        panel.revalidate();
        panel.repaint();
    }

    private class EditorsTabChangeListener
    implements ChangeListener {
        private EditorsTabChangeListener() {
        }

        public void stateChanged(ChangeEvent event) {
            Component c = ComponentContainerStringTemplate.this.editorsTab.getSelectedComponent();
            ComponentContainerStringTemplate.this.selectedContainer = (ComponentContainer)ComponentContainerStringTemplate.this.componentToContainer.get(c);
            ComponentEditorStringTemplate editor = (ComponentEditorStringTemplate)ComponentContainerStringTemplate.this.selectedContainer.getEditor();
            ComponentContainerStringTemplate.this.switchToEditor(editor);
        }
    }
}

