/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import java.awt.Point;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.undo.AbstractUndoableEdit;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.container.ComponentContainer;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.grammar.RefactorEngine;
import org.antlr.works.grammar.RefactorMutator;
import org.antlr.works.grammar.element.ElementReference;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.menu.ActionAbstract;
import org.antlr.works.menu.ActionRefactor;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.utils.XJAlert;

public class ActionRefactorImpl
extends ActionAbstract
implements ActionRefactor {
    private RefactorEngine engine = new RefactorEngine();
    private EditorTextMutator mutator;

    public ActionRefactorImpl(ComponentContainer container) {
        super(container);
    }

    public ComponentEditorGrammar getSelectedEditor() {
        return (ComponentEditorGrammar)super.getSelectedEditor();
    }

    public void rename() {
        StatisticsAW.shared().recordEvent(60);
        ATEToken token = this.getSelectedEditor().getCurrentToken();
        if (token == null) {
            return;
        }
        String s = (String)JOptionPane.showInputDialog(this.getSelectedEditor().getJavaContainer(), "Rename '" + token.getAttribute() + "' and its usages to:", "Rename", 3, null, null, token.getAttribute());
        if (s != null && !s.equals(token.getAttribute())) {
            this.beginRefactor("Rename");
            this.engine.renameToken(token, s);
            this.endRefactor();
        }
    }

    public boolean canReplaceLiteralWithTokenLabel() {
        ATEToken token = this.getSelectedEditor().getCurrentToken();
        return token != null && (token.type == 1 || token.type == 2);
    }

    public void replaceLiteralWithTokenLabel() {
        StatisticsAW.shared().recordEvent(61);
        ATEToken token = this.getSelectedEditor().getCurrentToken();
        if (token == null) {
            return;
        }
        if (token.type != 1 && token.type != 2) {
            XJAlert.display(this.getSelectedEditor().getJavaContainer(), "Cannot Replace Literal With Token Label", "The current token is not a literal.");
            return;
        }
        this.getSelectedEditor().selectTextRange(token.getStartIndex(), token.getEndIndex());
        String s = (String)JOptionPane.showInputDialog(this.getSelectedEditor().getJavaContainer(), "Replace Literal '" + token.getAttribute() + "' with token label:", "Replace Literal With Token Label", 3, null, null, "");
        if (s != null && !s.equals(token.getAttribute())) {
            this.beginRefactor("Replace Literal With Token Label");
            this.replaceLiteralTokenWithTokenLabel(token, s);
            this.endRefactor();
        }
    }

    public void replaceLiteralTokenWithTokenLabel(ATEToken t, String name) {
        this.mutator.insert(this.getSelectedEditor().getText().length(), "\n\n" + name + "\n\t:\t" + t.getAttribute() + "\n\t;");
        List<ATEToken> tokens = this.getSelectedEditor().getTokens();
        String attr = t.getAttribute();
        for (int index = tokens.size() - 1; index > 0; --index) {
            ATEToken token = tokens.get(index);
            if (token.type != 1 && token.type != 2 || !token.getAttribute().equals(attr)) continue;
            this.mutator.replace(token.getStartIndex(), token.getEndIndex(), name);
        }
    }

    public void convertLiteralsToSingleQuote() {
        StatisticsAW.shared().recordEvent(66);
        this.beginRefactor("Convert Literals To Single Quote Literals");
        this.convertLiteralsToSpecifiedQuote(2, '\'', '\"');
        this.endRefactor();
    }

    public void convertLiteralsToDoubleQuote() {
        StatisticsAW.shared().recordEvent(67);
        this.beginRefactor("Convert Literals To Double Quote Literals");
        this.convertLiteralsToSpecifiedQuote(1, '\"', '\'');
        this.endRefactor();
    }

    public void convertLiteralsToCStyleQuote() {
        StatisticsAW.shared().recordEvent(68);
        this.beginRefactor("Convert Literals To C-style Quote Literals");
        List<ATEToken> tokens = this.getSelectedEditor().getTokens();
        for (int index = tokens.size() - 1; index > 0; --index) {
            ATEToken token = tokens.get(index);
            String replaced = null;
            if (token.type != 1 && token.type != 2) continue;
            String attribute = token.getAttribute();
            String stripped = attribute.substring(1, attribute.length() - 1);
            if (token.type == 1) {
                if (stripped.length() == 1 || stripped.length() == 2 && stripped.charAt(0) == '\\') continue;
                if (stripped.indexOf(34) != -1 || stripped.indexOf(39) != -1) {
                    stripped = this.escapeStringQuote(stripped, '\"', '\'');
                }
                replaced = '\"' + stripped + '\"';
            } else if (token.type == 2) {
                if (stripped.length() > 1 && stripped.charAt(0) != '\\') continue;
                if (stripped.indexOf(39) != -1 || stripped.indexOf(34) != -1) {
                    stripped = this.escapeStringQuote(stripped, '\'', '\"');
                }
                replaced = '\'' + stripped + '\'';
            }
            this.mutator.replace(token.getStartIndex(), token.getEndIndex(), replaced);
        }
        this.endRefactor();
    }

    protected void convertLiteralsToSpecifiedQuote(int tokenType, char quote, char unescapeQuote) {
        List<ATEToken> tokens = this.getSelectedEditor().getTokens();
        for (int index = tokens.size() - 1; index > 0; --index) {
            ATEToken token = tokens.get(index);
            if (token.type != tokenType || RefactorEngine.ignoreScopeForDoubleQuoteLiteral(token.scope)) continue;
            String attribute = token.getAttribute();
            String stripped = attribute.substring(1, attribute.length() - 1);
            if (stripped.indexOf(quote) != -1 || stripped.indexOf(unescapeQuote) != -1) {
                stripped = this.escapeStringQuote(stripped, quote, unescapeQuote);
            }
            this.mutator.replace(token.getStartIndex(), token.getEndIndex(), quote + stripped + quote);
        }
    }

    protected String escapeStringQuote(String s, char escapeQuote, char unescapeQuote) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                char c1;
                if ((c1 = s.charAt(++i)) == unescapeQuote) {
                    sb.append(c1);
                    continue;
                }
                sb.append('\\');
                sb.append(c1);
                continue;
            }
            if (c == escapeQuote) {
                sb.append('\\');
                sb.append(escapeQuote);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void removeLeftRecursion() {
        StatisticsAW.shared().recordEvent(62);
        ElementRule rule = this.getSelectedEditor().rules.getEnclosingRuleAtPosition(this.getSelectedEditor().getCaretPosition());
        if (rule == null) {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Remove Left Recursion", "There is no rule at cursor position.");
            return;
        }
        if (!rule.hasLeftRecursion()) {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Remove Left Recursion", "The rule doesn't have a left recursion.");
            return;
        }
        this.beginRefactor("Remove Left Recursion");
        String ruleText = rule.getTextRuleAfterRemovingLeftRecursion();
        this.mutator.replace(rule.getInternalTokensStartIndex(), rule.getInternalTokensEndIndex(), ruleText);
        this.endRefactor();
    }

    public void removeAllLeftRecursion() {
        StatisticsAW.shared().recordEvent(63);
        this.beginRefactor("Remove All Left Recursion");
        List<ElementRule> rules = this.getSelectedEditor().rules.getRules();
        for (int index = rules.size() - 1; index >= 0; --index) {
            ElementRule rule = rules.get(index);
            if (!rule.hasLeftRecursion()) continue;
            String ruleText = rule.getTextRuleAfterRemovingLeftRecursion();
            this.mutator.replace(rule.getInternalTokensStartIndex(), rule.getInternalTokensEndIndex(), ruleText);
        }
        this.endRefactor();
    }

    public boolean canExtractRule() {
        int leftIndex = this.getSelectedEditor().getSelectionLeftIndexOnTokenBoundary();
        int rightIndex = this.getSelectedEditor().getSelectionRightIndexOnTokenBoundary();
        return leftIndex != -1 && rightIndex != -1;
    }

    public void extractRule() {
        StatisticsAW.shared().recordEvent(64);
        if (!this.canExtractRule()) {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Extract Rule", "At least one token must be selected.");
            return;
        }
        int leftIndex = this.getSelectedEditor().getSelectionLeftIndexOnTokenBoundary();
        int rightIndex = this.getSelectedEditor().getSelectionRightIndexOnTokenBoundary();
        this.getSelectedEditor().selectTextRange(leftIndex, rightIndex);
        String ruleName = (String)JOptionPane.showInputDialog(this.getSelectedEditor().getJavaContainer(), "Rule name:", "Extract Rule", 3, null, null, "");
        if (ruleName != null && ruleName.length() > 0) {
            this.beginRefactor("Extract Rule");
            boolean lexer = ATEToken.isLexerName(ruleName);
            int index = this.insertionIndexForRule(lexer);
            String ruleContent = this.getSelectedEditor().getText().substring(leftIndex, rightIndex);
            if (index > this.getSelectedEditor().getCaretPosition()) {
                this.insertRuleAtIndex(this.createRule(ruleName, ruleContent), index);
                this.mutator.replace(leftIndex, rightIndex, ruleName);
            } else {
                this.mutator.replace(leftIndex, rightIndex, ruleName);
                this.insertRuleAtIndex(this.createRule(ruleName, ruleContent), index);
            }
            this.endRefactor();
        }
    }

    public boolean canInlineRule() {
        return this.getSelectedEditor().rules.getEnclosingRuleAtPosition(this.getSelectedEditor().getCaretPosition()) != null;
    }

    public void inlineRule() {
        StatisticsAW.shared().recordEvent(65);
        ElementRule rule = this.getSelectedEditor().rules.getEnclosingRuleAtPosition(this.getSelectedEditor().getCaretPosition());
        if (rule == null) {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Inline Rule", "There is no rule at cursor position.");
            return;
        }
        this.inlineRule(rule);
    }

    protected void inlineRule(ElementRule rule) {
        String oldContent = this.getSelectedEditor().getText();
        this.beginRefactor("Inline");
        String ruleName = rule.name;
        String ruleContent = Utils.trimString(oldContent.substring(rule.colon.getEndIndex(), rule.end.getStartIndex()));
        List<ElementRule> rules = this.getSelectedEditor().rules.getRules();
        if (rule.end.index - rule.colon.index > 2) {
            ruleContent = "(" + ruleContent + ")";
        }
        for (int r = rules.size() - 1; r >= 0; --r) {
            ElementRule candidate = rules.get(r);
            if (candidate == rule) {
                this.mutator.delete(rule.getStartIndex(), rule.getEndIndex() + 1);
                continue;
            }
            List<ElementReference> references = candidate.getReferences();
            if (references == null) continue;
            for (int index = references.size() - 1; index >= 0; --index) {
                ElementReference ref = references.get(index);
                if (!ref.token.getAttribute().equals(ruleName)) continue;
                this.mutator.replace(ref.token.getStartIndex(), ref.token.getEndIndex(), ruleContent);
            }
        }
        this.endRefactor();
    }

    public void createRuleAtIndex(boolean lexer, String name, String content) {
        this.beginRefactor("Create Rule");
        int index = this.insertionIndexForRule(lexer);
        this.insertRuleAtIndex(this.createRule(name, content), index);
        this.getSelectedEditor().setCaretPosition(index);
        this.endRefactor();
    }

    public void deleteRuleAtIndex(int index) {
        ElementRule r = this.getSelectedEditor().rules.getEnclosingRuleAtPosition(index);
        if (r != null) {
            this.getSelectedEditor().replaceText(r.getStartIndex(), r.getEndIndex(), "");
        }
    }

    public int insertionIndexForRule(boolean lexer) {
        Point p = this.getSelectedEditor().getTextEditor().getLineTextPositionsAtTextPosition(this.getSelectedEditor().getCaretPosition());
        int insertionIndex = p.y;
        ElementRule rule = this.getSelectedEditor().rules.getEnclosingRuleAtPosition(this.getSelectedEditor().getCaretPosition());
        if (rule != null) {
            if (rule.lexer) {
                if (lexer) {
                    insertionIndex = rule.getEndIndex();
                } else {
                    ElementRule last = this.getSelectedEditor().rules.getLastParserRule();
                    if (last != null) {
                        insertionIndex = last.getEndIndex();
                    }
                }
            } else if (lexer) {
                ElementRule last = this.getSelectedEditor().rules.getLastLexerRule();
                if (last != null) {
                    insertionIndex = last.getEndIndex();
                } else {
                    last = this.getSelectedEditor().rules.getLastRule();
                    if (last != null) {
                        insertionIndex = last.getEndIndex();
                    }
                }
            } else {
                insertionIndex = rule.getEndIndex();
            }
        }
        return insertionIndex;
    }

    public String createRule(String name, String content) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(name);
        if (name.length() >= AWPrefs.getEditorTabSize()) {
            sb.append("\n");
        }
        sb.append("\t:");
        if (content != null && content.length() > 0) {
            sb.append("\t");
            sb.append(content);
        }
        sb.append("\n\t;");
        return sb.toString();
    }

    protected void insertRuleAtIndex(String rule, int index) {
        this.mutator.insertAtLinesBoundary(index, rule);
    }

    protected void beginRefactor(String name) {
        this.getSelectedEditor().beginGroupChange(name);
        this.mutator = new EditorTextMutator();
        this.engine.setMutator(this.mutator);
        this.engine.setTokens(this.getSelectedEditor().getTokens());
    }

    protected void endRefactor() {
        this.mutator.apply();
        this.mutator = null;
        this.getSelectedEditor().endGroupChange();
    }

    protected void refactorReplaceEditorText(String text) {
        int oldCaretPosition = this.getSelectedEditor().getCaretPosition();
        this.getSelectedEditor().disableTextPaneUndo();
        this.getSelectedEditor().setText(text);
        this.getSelectedEditor().enableTextPaneUndo();
        this.getSelectedEditor().getTextEditor().setCaretPosition(Math.min(oldCaretPosition, text.length()), false, false);
    }

    protected class UndoableRefactoringEdit
    extends AbstractUndoableEdit {
        public String oldContent;
        public String newContent;

        public UndoableRefactoringEdit(String oldContent, String newContent) {
            this.oldContent = oldContent;
            this.newContent = newContent;
        }

        public void redo() {
            super.redo();
            ActionRefactorImpl.this.refactorReplaceEditorText(this.newContent);
        }

        public void undo() {
            super.undo();
            ActionRefactorImpl.this.refactorReplaceEditorText(this.oldContent);
        }
    }

    public class EditorTextMutator
    implements RefactorMutator {
        public StringBuilder mutableText;

        public EditorTextMutator() {
            this.mutableText = new StringBuilder(ActionRefactorImpl.this.getSelectedEditor().getText());
        }

        public void replace(int start, int end, String s) {
            this.mutableText.replace(start, end, s);
        }

        public void insert(int index, String s) {
            this.mutableText.insert(index, s);
        }

        public void insertAtLinesBoundary(int index, String s) {
            if (this.mutableText.charAt(index) != '\n' || this.mutableText.charAt(index - 1) != '\n') {
                this.mutableText.insert(index++, '\n');
            }
            this.mutableText.insert(index, s);
            int end = index + s.length();
            if (this.mutableText.charAt(end) != '\n' || end + 1 >= this.mutableText.length() || this.mutableText.charAt(end + 1) != '\n') {
                this.mutableText.insert(end, '\n');
            }
        }

        public void delete(int start, int end) {
            this.mutableText.delete(start, end);
        }

        public void apply() {
            String text = this.mutableText.toString();
            String oldContent = ActionRefactorImpl.this.getSelectedEditor().getText();
            ActionRefactorImpl.this.refactorReplaceEditorText(text);
            XJUndo undo = ActionRefactorImpl.this.getSelectedEditor().getXJFrame().getUndo(ActionRefactorImpl.this.getSelectedEditor().getTextPane());
            undo.addEditEvent(new UndoableRefactoringEdit(oldContent, text));
        }
    }
}

