/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import java.io.File;
import org.antlr.works.components.container.ComponentContainer;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.generate.CodeDisplay;
import org.antlr.works.generate.CodeGenerate;
import org.antlr.works.generate.CodeGenerateDelegate;
import org.antlr.works.grammar.CheckGrammar;
import org.antlr.works.grammar.CheckGrammarDelegate;
import org.antlr.works.grammar.antlr.GrammarResult;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.menu.ActionAbstract;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.foundation.XJUtils;

public class ActionGenerate
extends ActionAbstract
implements CodeGenerateDelegate,
CheckGrammarDelegate {
    private String actionShowCodeRule;
    private int actionShowCodeType;
    private boolean actionShowCodeAfterGeneration = false;
    private CodeGenerate codeGenerate;
    private ComponentEditorGrammar rootGrammar;
    private boolean generating = false;

    public ActionGenerate(ComponentContainer editor) {
        super(editor);
    }

    public void awake() {
        this.rootGrammar = this.getSelectedEditor();
        this.codeGenerate = new CodeGenerate(this.rootGrammar, this);
    }

    public void close() {
        super.close();
        this.codeGenerate.close();
    }

    public void generateCode() {
        this.actionShowCodeRule = null;
        this.generateCodeProcess();
    }

    public ComponentEditorGrammar getSelectedEditor() {
        return (ComponentEditorGrammar)super.getSelectedEditor();
    }

    public void showGeneratedCode(int type) {
        StatisticsAW.shared().recordEvent(type == 2 ? 82 : 81);
        this.checkAndShowGeneratedCode(null, type);
    }

    public void showRuleGeneratedCode() {
        StatisticsAW.shared().recordEvent(83);
        if (this.getSelectedEditor().getCurrentRule() == null) {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Error", "A rule must be selected first.");
        } else {
            ElementRule r = this.getSelectedEditor().getCurrentRule();
            this.checkAndShowGeneratedCode(r.name, r.lexer ? 2 : 1);
        }
    }

    private synchronized void generateCodeProcess() {
        if (this.generating) {
            return;
        }
        this.generating = true;
        StatisticsAW.shared().recordEvent(80);
        if (!this.getSelectedEditor().ensureDocumentSaved()) {
            return;
        }
        CheckGrammar checkGrammar = new CheckGrammar(this.getSelectedEditor(), this);
        checkGrammar.check();
    }

    private void generateCodeProcessContinued() {
        if (!this.getSelectedEditor().getDocument().autoSave()) {
            this.generating = false;
            return;
        }
        this.codeGenerate.setDebug(false);
        this.codeGenerate.generateInThread(this.getSelectedEditor().getJavaContainer());
    }

    private void checkAndShowGeneratedCode(String rule, int type) {
        if (!this.isKnownLanguage()) {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Error", "Can only show generated grammar for Java language");
            return;
        }
        if (!this.codeGenerate.isGeneratedTextFileExisting(type) || this.codeGenerate.isFileModifiedSinceLastGeneration() || this.getSelectedEditor().getDocument().isDirty()) {
            this.actionShowCodeRule = rule;
            this.actionShowCodeType = type;
            this.actionShowCodeAfterGeneration = true;
            this.generateCodeProcess();
            return;
        }
        this.showGeneratedCode(rule, type);
    }

    private boolean isKnownLanguage() {
        String language = this.codeGenerate.getGrammarLanguage();
        return language != null && language.equals("Java");
    }

    private void showGeneratedCode(String rule, int type) {
        String grammarName;
        ComponentEditorGrammar editor = this.getSelectedEditor();
        try {
            grammarName = editor.getGrammarEngine().getGeneratedClassName(type);
        }
        catch (Exception e) {
            XJAlert.display(editor.getWindowContainer(), "Error", "Unable to get the generated class name:\n" + e.toString());
            return;
        }
        if (editor != this.rootGrammar) {
            grammarName = this.rootGrammar.getGrammarEngine().getGrammarName() + "_" + grammarName;
        }
        String grammarFileName = grammarName + ".java";
        String grammarFile = XJUtils.concatPath(this.codeGenerate.getOutputPath(), grammarFileName);
        if (!new File(grammarFile).exists()) {
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Error", "The generated code does not exist. It is probably not supported by the grammar.");
            return;
        }
        CodeDisplay cd = new CodeDisplay(editor.getXJFrame());
        cd.setFile(grammarFile);
        cd.setRule(rule);
        cd.load();
        editor.addTab(cd);
    }

    public boolean codeGenerateDisplaySuccess() {
        return !this.actionShowCodeAfterGeneration;
    }

    public void codeGenerateDidComplete() {
        if (this.actionShowCodeAfterGeneration) {
            this.actionShowCodeAfterGeneration = false;
            this.showGeneratedCode(this.actionShowCodeRule, this.actionShowCodeType);
        }
        this.generating = false;
    }

    public void codeGenerateDidCompleteWithError(String error) {
        this.generating = false;
    }

    public void checkGrammarDidBegin(CheckGrammar source) {
    }

    public void checkGrammarDidEnd(CheckGrammar source, GrammarResult result) {
        if (result.getErrorCount() == 0) {
            this.generateCodeProcessContinued();
        } else {
            this.generating = false;
            XJAlert.display(this.getSelectedEditor().getWindowContainer(), "Error", "Check Grammar reported some errors:\n" + result.getFirstErrorMessage() + "\nConsult the console for more information.");
        }
        source.close();
    }
}

