/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.grammar.RulesDependency;
import org.antlr.works.grammar.TokensDFA;
import org.antlr.works.grammar.decisiondfa.DecisionDFA;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.gview.GViewDelegate;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.utils.GDOTImporterDOT;
import org.antlr.xjlib.appkit.utils.XJAlert;

public abstract class GrammarDOTTab
extends EditorTab
implements Runnable,
GViewDelegate {
    protected ComponentEditorGrammar editor;
    protected JPanel panel;
    protected GView view;
    protected ElementRule rule;
    protected String tempInputFile;
    protected String tempOutputFile;
    protected String error;
    public static final String dotInfo = "The 'dot' tool is used to render directed graph. It can be downloaded from www.graphviz.org.";

    public GrammarDOTTab(ComponentEditorGrammar editor) {
        this.editor = editor;
    }

    public Container getContainer() {
        return this.panel;
    }

    public boolean launch() {
        if (AWPrefs.getDOTToolPath() == null) {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Cannot generate the graph because the 'dot' tool path is not defined. The path can be set in the Preferences.\nThe 'dot' tool is used to render directed graph. It can be downloaded from www.graphviz.org.");
            return false;
        }
        if (!new File(AWPrefs.getDOTToolPath()).exists()) {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "Cannot generate the graph because the 'dot' tool does not exist at the specified path. Check the tool path in the Preferences.\nThe 'dot' tool is used to render directed graph. It can be downloaded from www.graphviz.org.");
            return false;
        }
        if (this.willLaunch()) {
            new Thread(this).start();
            this.editor.showProgress("Generating...", null);
            return true;
        }
        return false;
    }

    protected boolean willLaunch() {
        return true;
    }

    protected boolean checkForCurrentRule() {
        ElementRule rule = this.editor.getCurrentRule();
        if (rule == null) {
            XJAlert.display(this.editor.getWindowContainer(), "Error", "The cursor must be inside a rule");
            return false;
        }
        return true;
    }

    protected void createInterface(GElement graph) {
        this.panel = new JPanel(new BorderLayout());
        this.view = new CustomGView();
        this.view.setAutoAdjustSize(true);
        this.view.setRootElement(graph);
        this.view.setBackground(Color.white);
        this.view.setDrawBorder(false);
        this.view.setDelegate(this);
        Box b = Box.createHorizontalBox();
        b.add(new JLabel("Zoom"));
        b.add(this.createZoomSlider());
        JScrollPane sp = new JScrollPane(this.view);
        sp.setWheelScrollingEnabled(true);
        this.panel.add((Component)b, "North");
        this.panel.add((Component)sp, "Center");
    }

    protected JSlider createZoomSlider() {
        JSlider slider = new JSlider();
        slider.setFocusable(false);
        slider.setMinimum(1);
        slider.setMaximum(800);
        slider.setValue(100);
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                JSlider slider = (JSlider)event.getSource();
                GrammarDOTTab.this.view.setZoom((float)slider.getValue() / 100.0f);
                GrammarDOTTab.this.view.repaint();
            }
        });
        return slider;
    }

    public GElement generate() throws Exception {
        this.generateDOTFile();
        this.generatePlainTextFile();
        return new GDOTImporterDOT().generateGraph(this.tempOutputFile);
    }

    protected void generateDOTFile() throws Exception {
        String dot = this.getDOTString();
        if (dot != null) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.tempInputFile));
            bw.write(dot);
            bw.close();
        }
    }

    protected void generatePlainTextFile() throws Exception {
        String[] args = new String[]{Utils.quotePath(AWPrefs.getDOTToolPath()), "-Tdot", "-o", Utils.quotePath(this.tempOutputFile), Utils.quotePath(this.tempInputFile)};
        Process p = Runtime.getRuntime().exec(args);
        new StreamWatcher(p.getErrorStream(), "DecisionDFA").start();
        new StreamWatcher(p.getInputStream(), "DecisionDFA").start();
        p.waitFor();
    }

    public void willRun() {
    }

    public void run() {
        this.error = null;
        this.willRun();
        this.rule = this.editor.getCurrentRule();
        try {
            this.tempInputFile = File.createTempFile("GrammarDOTTab", ".in").getAbsolutePath();
            this.tempOutputFile = File.createTempFile("GrammarDOTTab", ".out").getAbsolutePath();
            this.createInterface(this.generate());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error = e.toString();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GrammarDOTTab.this.editor.hideProgress();
                if (GrammarDOTTab.this.error == null) {
                    GrammarDOTTab.this.editor.addTab(GrammarDOTTab.this);
                } else {
                    if (GrammarDOTTab.this instanceof TokensDFA) {
                        XJAlert.display(GrammarDOTTab.this.editor.getWindowContainer(), "Error", "Cannot generate the tokens DFA:\n" + GrammarDOTTab.this.error);
                    }
                    if (GrammarDOTTab.this instanceof DecisionDFA) {
                        XJAlert.display(GrammarDOTTab.this.editor.getWindowContainer(), "Error", "Cannot generate the DFA:\n" + GrammarDOTTab.this.error);
                    }
                    if (GrammarDOTTab.this instanceof RulesDependency) {
                        XJAlert.display(GrammarDOTTab.this.editor.getWindowContainer(), "Error", "Cannot generate the rule dependency graph:\n" + GrammarDOTTab.this.error);
                    }
                }
            }
        });
        new File(this.tempInputFile).delete();
        new File(this.tempOutputFile).delete();
    }

    public boolean canExportToEPS() {
        return true;
    }

    public boolean canExportToBitmap() {
        return true;
    }

    public boolean canExportToDOT() {
        return true;
    }

    public GView getExportableGView() {
        return this.view;
    }

    public Component getTabComponent() {
        return this.getContainer();
    }

    public int getHorizontalMagnetics() {
        return 0;
    }

    public int getVerticalMagnetics() {
        return 0;
    }

    public void contextualHelp(GElement element) {
    }

    public void changeOccured() {
    }

    public void viewSizeDidChange() {
        this.view.revalidate();
    }

    protected class StreamWatcher
    extends Thread {
        InputStream is;
        String type;

        public StreamWatcher(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        public void run() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
                while ((line = br.readLine()) != null) {
                    GrammarDOTTab.this.editor.console.println(this.type + ":" + line);
                }
            }
            catch (IOException e) {
                GrammarDOTTab.this.editor.console.println(e);
            }
        }
    }

    protected class CustomGView
    extends GView {
        protected CustomGView() {
        }

        public JPopupMenu getContextualMenu(GElement element) {
            ContextualMenuFactory factory = GrammarDOTTab.this.editor.createContextualMenuFactory();
            factory.addItem(111);
            factory.addItem(110);
            factory.addItem(114);
            return factory.menu;
        }
    }
}

