/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.prefs.AWPrefs;

public class GrammarAutoIndent {
    public static void autoIndentOnSpecificKeys(ComponentEditorGrammar editor, Document doc, int offset, int length) throws BadLocationException {
        String s = doc.getText(offset - 1, length + 1);
        if (s.length() < 2) {
            return;
        }
        char c1 = s.charAt(0);
        char c2 = s.charAt(1);
        if (c1 == '\n' || c1 == '\r') {
            if (c2 == '|') {
                doc.remove(offset, 1);
                doc.insertString(offset, "\t" + c2 + "\t", null);
            } else if (c2 == ';') {
                doc.remove(offset, 1);
                doc.insertString(offset, "\t" + c2, null);
            }
        } else if (c2 == ':') {
            String t;
            char c;
            ATEToken token = editor.getCurrentToken();
            if (token != null && token.scope != null) {
                return;
            }
            boolean beginningOfRule = true;
            int originalOffset = offset;
            while (--offset >= 0 && (c = (t = doc.getText(offset, 1)).charAt(0)) != '\n' && c != '\r') {
                if (c == ' ' || c == '_' || Character.isLetterOrDigit(c)) continue;
                beginningOfRule = false;
                break;
            }
            if (beginningOfRule && AWPrefs.autoIndentColonInRule()) {
                int lengthOfRule = originalOffset - offset;
                int tabSize = AWPrefs.getEditorTabSize();
                if (lengthOfRule > tabSize + 1) {
                    doc.remove(originalOffset, 1);
                    doc.insertString(originalOffset, "\n\t:\t", null);
                } else if (lengthOfRule < tabSize + 1) {
                    doc.remove(originalOffset, 1);
                    doc.insertString(originalOffset, "\t:\t", null);
                } else {
                    doc.insertString(originalOffset + 1, "\t", null);
                }
            }
        }
    }
}

