/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.generate;

import java.awt.Component;
import java.awt.Font;
import java.io.File;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.syntax.java.ATEJavaSyntaxEngine;
import org.antlr.works.editor.EditorTab;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.xjlib.appkit.document.XJFileMonitor;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.foundation.XJUtils;

public class CodeDisplay
extends EditorTab {
    private ATEPanel textEditor;
    private String rule;
    private String file;
    private final XJFileMonitor monitor = new XJFileMonitor();

    public CodeDisplay(XJFrameInterface parentFrame) {
        this.textEditor = new ATEPanel(parentFrame);
        this.textEditor.setParserEngine(new ATEJavaSyntaxEngine());
        this.textEditor.setSyntaxColoring(true);
        this.textEditor.setAnalysisColumnVisible(false);
        this.textEditor.setFoldingEnabled(AWPrefs.getFoldingEnabled());
        this.textEditor.setLineNumberEnabled(AWPrefs.getLineNumberEnabled());
        this.textEditor.setHighlightCursorLine(AWPrefs.getHighlightCursorEnabled());
        this.textEditor.setEditable(false);
        this.applyFont();
    }

    public void applyFont() {
        this.textEditor.getTextPane().setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.textEditor.getTextPane().setTabSize(AWPrefs.getEditorTabSize());
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void editorActivated() {
        if (this.file != null && this.monitor.isModifiedOnDisk(this.file) && new File(this.file).exists()) {
            this.load();
        }
    }

    public void load() {
        String text;
        try {
            text = XJUtils.getStringFromFile(this.file);
        }
        catch (Exception e) {
            XJAlert.display(null, "Error", "Exception while reading the generated file:\n" + e.toString());
            return;
        }
        if (this.rule != null) {
            int stopIndex;
            int startIndex = text.indexOf("$ANTLR start \"" + this.rule + "\"");
            startIndex = text.indexOf("\n", startIndex) + 1;
            for (stopIndex = text.indexOf(new StringBuilder().append("$ANTLR end \"").append(this.rule).append("\"").toString()); stopIndex > 0 && text.charAt(stopIndex) != '\n'; --stopIndex) {
            }
            if (startIndex >= 0 && stopIndex >= 0) {
                text = text.substring(startIndex, stopIndex);
            } else {
                XJAlert.display(null, "Error", "Cannot find markers for rule \"" + this.rule + "\"");
                return;
            }
        }
        this.monitor.synchronizeLastModifiedDate(this.file);
        this.textEditor.loadText(text);
    }

    public String getTabName() {
        String name = XJUtils.getLastPathComponent(this.file);
        if (this.rule != null) {
            return this.rule + " [" + name + "]";
        }
        return name;
    }

    public Component getTabComponent() {
        return this.textEditor;
    }
}

