/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor.tips;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.antlr.works.utils.OverlayObject;
import org.antlr.works.utils.ToolTipList;
import org.antlr.works.utils.ToolTipListDelegate;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TipsOverlay
extends OverlayObject
implements ToolTipListDelegate {
    protected ToolTipList toolTip;
    protected Point location;

    public TipsOverlay(XJFrameInterface parentFrame, JComponent parentComponent) {
        super(parentFrame, parentComponent);
    }

    public void setTips(List<String> tips) {
        this.toolTip.clear();
        for (String tip : tips) {
            this.toolTip.addLine(tip);
        }
        this.toolTip.selectFirstLine();
    }

    public void setLocation(Point location) {
        this.location = location;
        this.resize();
    }

    @Override
    public JComponent overlayCreateInterface() {
        JPanel panel = new JPanel(new BorderLayout());
        this.toolTip = new ToolTipList(this);
        panel.add((Component)this.toolTip, "Center");
        return panel;
    }

    @Override
    public void resize() {
        this.toolTip.resize();
        if (this.location != null) {
            this.content.setBounds(this.location.x, this.location.y, this.toolTip.getWidth(), this.toolTip.getHeight());
        }
    }

    @Override
    public boolean overlayWillDisplay() {
        return true;
    }

    @Override
    public void toolTipListHide() {
        this.hide();
    }
}

