/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor.idea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.TextLayout;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.editor.idea.IdeaAction;
import org.antlr.works.utils.IconManager;
import org.antlr.works.utils.OverlayObject;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdeaOverlay
extends OverlayObject {
    protected static final int VISIBLE_IDEAS = 10;
    protected ComponentEditorGrammar editor;
    protected DefaultListModel ideasModel;
    protected JList ideasList;
    protected JScrollPane ideasScrollPane;
    protected JToggleButton ideaButton;
    protected List<IdeaAction> ideas;

    public IdeaOverlay(ComponentEditorGrammar editor, XJFrameInterface parentFrame, JComponent parentComponent) {
        super(parentFrame, parentComponent);
        this.editor = editor;
    }

    @Override
    public void close() {
        super.close();
        this.editor = null;
    }

    public void setIdeas(List<IdeaAction> ideas) {
        this.ideas = ideas;
    }

    @Override
    public JComponent overlayCreateInterface() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        this.ideaButton = new JToggleButton();
        this.ideaButton.setIcon(IconManager.shared().getIconIdea());
        this.ideaButton.setContentAreaFilled(false);
        this.ideaButton.setBorder(null);
        this.ideaButton.setFocusable(false);
        this.ideaButton.addActionListener(new IdeaActionListener());
        this.ideaButton.setToolTipText("Click to display ideas");
        this.ideaButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                IdeaOverlay.this.ideaButton.setBorder(BorderFactory.createLineBorder(Color.darkGray));
            }

            public void mouseExited(MouseEvent e) {
                if (IdeaOverlay.this.ideaButton.isSelected()) {
                    return;
                }
                IdeaOverlay.this.ideaButton.setBorder(null);
            }
        });
        panel.add((Component)this.ideaButton, "Center");
        this.ideasModel = new DefaultListModel();
        this.ideasList = new JList(this.ideasModel);
        this.ideasList.setSelectionMode(0);
        this.ideasList.setBackground(new Color(235, 244, 254));
        this.ideasList.setPrototypeCellValue("This is a rule name g");
        this.ideasList.addKeyListener(new ListKeyAdapter());
        this.ideasList.addMouseListener(new ListMouseAdapter());
        this.ideasList.addMouseMotionListener(new ListMouseMotionAdapter());
        this.ideasScrollPane = new JScrollPane(this.ideasList, 20, 31);
        this.ideasScrollPane.setBorder(BorderFactory.createBevelBorder(0));
        this.ideasScrollPane.setVisible(false);
        this.parentFrame.getLayeredPane().add((Component)this.ideasScrollPane, JLayeredPane.MODAL_LAYER);
        return panel;
    }

    @Override
    public int overlayDefaultWidth() {
        return 20;
    }

    @Override
    public int overlayDefaultHeight() {
        return 20;
    }

    @Override
    public int overlayDefaultAlignment() {
        return 2;
    }

    @Override
    public Point overlayCustomPosition() {
        Point lp = this.editor.getTextEditor().getLineTextPositionsAtTextPosition(this.editor.getCaretPosition());
        int cx = 0;
        int y = 0;
        try {
            y = this.editor.getTextPane().modelToView((int)lp.y).y;
            cx = this.editor.getTextPane().modelToView((int)this.editor.getCaretPosition()).x;
        }
        catch (Exception e) {
            // empty catch block
        }
        Point anchor = new Point(0, 0);
        if (cx < 50) {
            anchor.x += 50;
        }
        Point p = SwingUtilities.convertPoint(this.parentComponent, anchor, this.parentFrame.getRootPane());
        return new Point(p.x + 5, p.y + y);
    }

    @Override
    public void hide() {
        super.hide();
        this.ideasScrollPane.setVisible(false);
    }

    @Override
    public void resize() {
        super.resize();
        this.resizeIdeas();
    }

    public void resizeIdeas() {
        Rectangle r = this.content.getBounds();
        int height = this.ideasList.getFixedCellHeight();
        int size = this.ideasModel.size();
        if (size > 0) {
            int width = 0;
            for (int i = 0; i < this.ideasModel.size(); ++i) {
                IdeaAction action = (IdeaAction)this.ideasModel.getElementAt(i);
                TextLayout layout = new TextLayout(action.name, this.ideasList.getFont(), ((Graphics2D)this.ideasList.getGraphics()).getFontRenderContext());
                width = Math.max(width, (int)layout.getBounds().getWidth());
            }
            height = height * Math.min(10, size) + 5;
            this.ideasScrollPane.setBounds(r.x, r.y + r.height, width + 10, height);
        }
    }

    public void updateIdeasList() {
        this.ideasModel.clear();
        Iterator<IdeaAction> iter = this.ideas.iterator();
        while (iter.hasNext()) {
            this.ideasModel.addElement(iter.next());
        }
        this.ideasList.setSelectedIndex(0);
    }

    @Override
    public boolean overlayWillDisplay() {
        this.updateIdeasList();
        this.ideaButton.setSelected(false);
        this.ideaButton.setBorder(null);
        return true;
    }

    public void applyIdea(int index) {
        IdeaAction action = this.ideas.get(index);
        action.run();
    }

    public class ListKeyAdapter
    extends KeyAdapter {
        public void selectNextListElement(int direction) {
            int index = IdeaOverlay.this.ideasList.getSelectedIndex();
            index += direction;
            index = Math.min(Math.max(0, index), IdeaOverlay.this.ideasModel.size() - 1);
            IdeaOverlay.this.ideasList.setSelectedIndex(index);
            IdeaOverlay.this.ideasList.scrollRectToVisible(IdeaOverlay.this.ideasList.getCellBounds(index, index));
        }

        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!IdeaOverlay.this.content.isVisible()) {
                return;
            }
            switch (e.getKeyCode()) {
                case 27: {
                    IdeaOverlay.this.hide();
                    e.consume();
                    break;
                }
                case 10: {
                    IdeaOverlay.this.applyIdea(IdeaOverlay.this.ideasList.getSelectedIndex());
                    IdeaOverlay.this.hide();
                    e.consume();
                    break;
                }
                case 38: {
                    this.selectNextListElement(-1);
                    e.consume();
                    break;
                }
                case 40: {
                    this.selectNextListElement(1);
                    e.consume();
                }
            }
        }
    }

    public class ListMouseAdapter
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            IdeaOverlay.this.applyIdea(IdeaOverlay.this.ideasList.getSelectedIndex());
            IdeaOverlay.this.hide();
        }
    }

    public class ListMouseMotionAdapter
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent e) {
            IdeaOverlay.this.ideasList.setSelectedIndex(IdeaOverlay.this.ideasList.locationToIndex(e.getPoint()));
        }
    }

    public class IdeaActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            IdeaOverlay.this.ideasScrollPane.setVisible(IdeaOverlay.this.ideaButton.isSelected());
        }
    }
}

