/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.editor.EditorInspectorItem;
import org.antlr.works.editor.tips.TipsManager;
import org.antlr.works.editor.tips.TipsOverlay;
import org.antlr.works.editor.tips.TipsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorTips
implements TipsProvider {
    public TipsManager tipsManager;
    public ComponentEditorGrammar editor;

    public EditorTips(ComponentEditorGrammar editor) {
        this.editor = editor;
    }

    public void awake() {
        this.tipsManager = new TipsManager();
        this.tipsManager.setOverlay(new TipsOverlay(this.editor.getXJFrame(), this.editor.getTextPane()));
        this.tipsManager.addProvider(this);
    }

    public void toggleEnabled() {
        this.tipsManager.setEnabled(!this.tipsManager.enabled());
    }

    public void hide() {
        this.tipsManager.hide();
    }

    public void close() {
        this.editor = null;
        this.tipsManager.close();
    }

    public void display(Point relativePoint, Point absolutePoint) {
        if (this.editor.getTokens() == null) {
            return;
        }
        int position = this.editor.getTextPane().viewToModel(relativePoint);
        Point p = null;
        try {
            Rectangle r2;
            Rectangle r1;
            ATEToken token = this.editor.getTokenAtPosition(position, false);
            if (token != null && (r1 = this.editor.getTextPane().modelToView(token.getStartIndex())).union(r2 = this.editor.getTextPane().modelToView(token.getEndIndex())).contains(relativePoint)) {
                p = SwingUtilities.convertPoint(this.editor.getTextPane(), new Point(relativePoint.x + 2, r2.y - 5), this.editor.getXJFrame().getJavaContainer());
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        this.tipsManager.displayAnyTipsAvailable(position, p);
    }

    @Override
    public List<String> tipsProviderGetTips(int position) {
        ArrayList<String> tips = new ArrayList<String>();
        List<EditorInspectorItem> items = this.editor.editorInspector.getAllItemsAtIndex(position);
        for (EditorInspectorItem item : items) {
            tips.add(item.description);
        }
        return tips;
    }
}

