/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.antlr.works.ate.swing.ATEKeyBindings;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.editor.ComponentEditor;
import org.antlr.works.components.editor.ComponentEditorGrammar;
import org.antlr.works.grammar.element.ElementAction;
import org.antlr.works.grammar.element.ElementGroup;
import org.antlr.works.grammar.element.ElementReference;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.grammar.engine.GrammarEngine;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.utils.IconManager;
import org.antlr.xjlib.appkit.swing.XJTree;
import org.antlr.xjlib.appkit.swing.XJTreeDelegate;
import org.antlr.xjlib.foundation.XJSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorRules
implements XJTreeDelegate {
    protected ComponentEditorGrammar editor;
    protected boolean programmaticallySelectingRule = false;
    protected boolean selectNextRule = false;
    protected XJTree rulesTree;
    protected DefaultMutableTreeNode rulesTreeRootNode;
    protected DefaultTreeModel rulesTreeModel;
    protected List<String> rulesTreeExpandedNodes;
    protected RuleTreeUserObject selectedObject;
    protected boolean sort;
    private TreeSelectionListener tsl;
    private MouseListener ml;
    public static final Color HIGHLIGHTED_COLOR = new Color(0.0f, 0.5f, 1.0f, 0.4f);

    public EditorRules(ComponentEditorGrammar editor, XJTree rulesTree) {
        this.editor = editor;
        this.rulesTree = rulesTree;
        rulesTree.setDelegate(this);
        rulesTree.setEnableDragAndDrop();
        this.rulesTreeRootNode = new DefaultMutableTreeNode(new RuleTreeUserObject(editor));
        this.rulesTreeModel = new DefaultTreeModel(this.rulesTreeRootNode);
        this.rulesTreeExpandedNodes = new ArrayList<String>();
        rulesTree.setModel(this.rulesTreeModel);
        this.ml = new RuleTreeMouseListener();
        rulesTree.addMouseListener(this.ml);
        this.tsl = new RuleTreeSelectionListener();
        rulesTree.addTreeSelectionListener(this.tsl);
        rulesTree.setRootVisible(true);
        rulesTree.setCellRenderer(new RulesTableRenderer());
        rulesTree.setRowHeight(17);
        rulesTree.getSelectionModel().setSelectionMode(4);
        this.setSorted(AWPrefs.getPreferences().getBoolean("PREF_TOOLBAR_SORT", false));
    }

    public void close() {
        this.editor = null;
        this.rulesTree.removeMouseListener(this.ml);
        this.rulesTree.removeTreeSelectionListener(this.tsl);
        this.rulesTree.setCellRenderer(null);
        this.rulesTree.setDelegate(null);
        this.rulesTree = null;
    }

    public void setKeyBindings(ATEKeyBindings keyBindings) {
        keyBindings.addKeyBinding("RULE_MOVE_UP", KeyStroke.getKeyStroke(38, 2), new RuleMoveUpAction());
        keyBindings.addKeyBinding("RULE_MOVE_DOWN", KeyStroke.getKeyStroke(40, 2), new RuleMoveDownAction());
    }

    public GrammarEngine getGrammarEngine() {
        return this.editor.getGrammarEngine();
    }

    public boolean isSorted() {
        return this.sort;
    }

    public void setSorted(boolean flag) {
        this.sort = flag;
    }

    public void toggleSorting() {
        this.sort = !this.sort;
        this.rebuildTree();
    }

    public void ignoreSelectedRules(boolean flag) {
        for (ElementRule r : this.getSelectedRules()) {
            r.ignored = flag;
        }
        this.rulesTree.repaint();
        this.editor.rulesDidChange();
    }

    public void findTokensToIgnore(boolean reset) {
        List<ElementRule> rules = this.getRules();
        if (rules == null || rules.isEmpty()) {
            return;
        }
        EditorRules.findTokensToIgnore(rules, reset);
        this.rulesTree.repaint();
    }

    public static void findTokensToIgnore(List<ElementRule> rules, boolean reset) {
        for (ElementRule rule : rules) {
            List<ElementAction> actions;
            if (reset) {
                rule.ignored = false;
            }
            if ((actions = rule.getActions()) == null || actions.isEmpty()) continue;
            block1: for (ElementAction action : actions) {
                List<ATEToken> tokens = action.getTokens();
                for (int t = 0; t < tokens.size(); ++t) {
                    ATEToken token = tokens.get(t);
                    if ((token.type == 5 || token.type == 100) && token.getAttribute().equals("channel") && t + 3 < tokens.size()) {
                        ATEToken t1 = tokens.get(t + 1);
                        ATEToken t2 = tokens.get(t + 2);
                        if (t1.type != 6 || !t1.getAttribute().equals("=") || t2.type != 5 || !t2.getAttribute().equals("HIDDEN")) continue;
                        rule.ignored = true;
                        continue block1;
                    }
                    if (token.type != 5 || !token.getAttribute().equals("skip") || tokens.size() != 5 || t != 1) continue;
                    rule.ignored = true;
                    continue block1;
                }
            }
        }
    }

    public boolean getFirstSelectedRuleIgnoredFlag() {
        List<ElementRule> selectedRules = this.getSelectedRules();
        return selectedRules != null && !selectedRules.isEmpty() && selectedRules.get((int)0).ignored;
    }

    public void refreshRules() {
        this.saveExpandedNodes();
        this.rulesTreeModel.reload();
        this.restoreExpandedNodes();
        this.selectRuleInTreeAtPosition(this.editor.getCaretPosition());
    }

    public ElementGroup getSelectedGroup() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.rulesTree.getSelectionPath().getLastPathComponent();
        RuleTreeUserObject n = (RuleTreeUserObject)node.getUserObject();
        if (n.group != null) {
            return n.group;
        }
        return null;
    }

    public ElementGroup findOpenGroupClosestToLocation(int location) {
        List<ElementGroup> groups = this.getGrammarEngine().getGroups();
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        ElementGroup previous = null;
        for (ElementGroup group : groups) {
            if (!group.openGroup) continue;
            ATEToken t = group.token;
            if (t.getStartIndex() > location) break;
            previous = group;
        }
        return previous;
    }

    public ElementGroup findClosingGroupForGroup(ElementGroup group) {
        List<ElementGroup> groups = this.getGrammarEngine().getGroups();
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        int index = groups.indexOf(group) + 1;
        if (index == -1) {
            return null;
        }
        int open = 0;
        while (index < groups.size()) {
            ElementGroup g = groups.get(index);
            if (g.openGroup) {
                ++open;
            } else {
                if (open == 0) {
                    return g;
                }
                --open;
            }
            ++index;
        }
        return null;
    }

    public List<ElementRule> getRules() {
        return this.getGrammarEngine().getRules();
    }

    public List<ElementRule> getSortedRules() {
        return this.getSortedRules(this.getRules());
    }

    public List<ElementRule> getSortedRules(List<ElementRule> rules) {
        if (rules == null) {
            return null;
        }
        ArrayList<ElementRule> sortedRules = new ArrayList<ElementRule>(rules);
        Collections.sort(sortedRules);
        if (!sortedRules.isEmpty()) {
            ElementRule firstRule = (ElementRule)sortedRules.get(0);
            if (firstRule.lexer) {
                for (int index = 0; index < sortedRules.size(); ++index) {
                    ElementRule rule = (ElementRule)sortedRules.get(0);
                    if (!rule.lexer) break;
                    sortedRules.add(rule);
                    sortedRules.remove(0);
                }
            }
        }
        return sortedRules;
    }

    public List<ElementRule> getSelectedRules() {
        ArrayList<ElementRule> rules = new ArrayList<ElementRule>();
        for (Object o1 : this.rulesTree.getSelectedNodes()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o1;
            RuleTreeUserObject o = (RuleTreeUserObject)node.getUserObject();
            if (o.rule == null) continue;
            rules.add(o.rule);
        }
        return rules;
    }

    public ElementRule getLastRule() {
        List<ElementRule> rules = this.getGrammarEngine().getRules();
        if (rules != null && !rules.isEmpty()) {
            return rules.get(rules.size() - 1);
        }
        return null;
    }

    public ElementRule getLastParserRule() {
        List<ElementRule> rules = this.getGrammarEngine().getRules();
        for (int index = rules.size() - 1; index > 0; --index) {
            ElementRule rule = rules.get(index);
            if (rule.lexer) continue;
            return rule;
        }
        return null;
    }

    public ElementRule getLastLexerRule() {
        List<ElementRule> rules = this.getGrammarEngine().getRules();
        for (int index = rules.size() - 1; index > 0; --index) {
            ElementRule rule = rules.get(index);
            if (!rule.lexer) continue;
            return rule;
        }
        return null;
    }

    public List<String> getRulesStartingWith(String match) {
        ArrayList<String> matches = new ArrayList<String>();
        if (this.getGrammarEngine().getRules() == null) {
            return matches;
        }
        List<ElementRule> rules = this.getGrammarEngine().getRules();
        for (ElementRule r : rules) {
            String rname = r.name.toLowerCase();
            if (!rname.startsWith(match) || matches.contains(r.name)) continue;
            matches.add(r.name);
        }
        return matches;
    }

    public List<ElementReference> getReferencesInRule(ElementRule rule) {
        if (this.getGrammarEngine().getRules() == null) {
            return null;
        }
        ArrayList<ElementReference> refs = new ArrayList<ElementReference>();
        for (ElementReference r : this.getGrammarEngine().getReferences()) {
            if (r.rule != rule) continue;
            refs.add(r);
        }
        return refs;
    }

    public ElementRule getEnclosingRuleAtPosition(int pos) {
        if (this.getGrammarEngine().getRules() == null) {
            return null;
        }
        for (ElementRule r : this.getGrammarEngine().getRules()) {
            if (!r.containsIndex(pos)) continue;
            return r;
        }
        return null;
    }

    public ElementRule selectRuleInTreeAtPosition(int pos) {
        if (this.programmaticallySelectingRule || this.getGrammarEngine().getRules() == null) {
            return null;
        }
        this.programmaticallySelectingRule = true;
        ElementRule rule = this.getEnclosingRuleAtPosition(pos);
        this.selectRuleInTree(rule);
        this.programmaticallySelectingRule = false;
        return rule;
    }

    public ElementRule selectRuleNameInTree(String name) {
        if (this.programmaticallySelectingRule || this.getGrammarEngine().getRules() == null) {
            return null;
        }
        ElementRule rule = null;
        this.programmaticallySelectingRule = true;
        for (ElementRule r : this.getGrammarEngine().getRules()) {
            if (!r.name.equals(name)) continue;
            this.selectRuleInTree(r);
            rule = r;
            break;
        }
        this.programmaticallySelectingRule = false;
        return rule;
    }

    public ElementRule getRuleAtIndex(int index) {
        if (this.getGrammarEngine().getRules() == null) {
            return null;
        }
        for (ElementRule r : this.getGrammarEngine().getRules()) {
            if (index < r.getStartIndex() || index > r.getEndIndex()) continue;
            return r;
        }
        return null;
    }

    public boolean isRuleAtIndex(int index) {
        return this.getRuleAtIndex(index) != null;
    }

    public void selectNextRule() {
        ElementRule rule = this.getEnclosingRuleAtPosition(this.editor.getCaretPosition());
        int index = this.getGrammarEngine().getRules().indexOf(rule) + 1;
        rule = this.getGrammarEngine().getRuleAtIndex(index);
        if (rule != null) {
            this.editor.setCaretPosition(rule.getStartIndex());
            this.editor.rulesCaretPositionDidChange();
        }
    }

    public void selectRuleInTree(ElementRule rule) {
        if (rule == null) {
            return;
        }
        Enumeration<TreeNode> enumeration = this.rulesTreeRootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            RuleTreeUserObject n = (RuleTreeUserObject)node.getUserObject();
            if (n == null || n.rule != rule) continue;
            TreePath path = new TreePath(node.getPath());
            this.rulesTree.setSelectionPath(path);
            this.rulesTree.scrollPathToVisible(path);
            break;
        }
    }

    public void goToRule(ElementRule rule) {
        this.editor.goToHistoryRememberCurrentPosition();
        this.editor.setCaretPosition(rule.start.getStartIndex());
    }

    public void rebuildTree() {
        this.saveExpandedNodes();
        this.rememberSelectedTreeItem();
        this.rulesTreeRootNode.removeAllChildren();
        List<ElementRule> rules = this.getGrammarEngine().getRules();
        List<ElementGroup> groups = this.getGrammarEngine().getGroups();
        if (rules == null || groups == null) {
            return;
        }
        if (groups.isEmpty()) {
            this.buildTree(this.rulesTreeRootNode, rules, 0, rules.size() - 1);
        } else {
            Stack<DefaultMutableTreeNode> parentStack = new Stack<DefaultMutableTreeNode>();
            parentStack.add(this.rulesTreeRootNode);
            int ruleIndex = 0;
            for (ElementGroup group : groups) {
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parentStack.peek();
                if (group.ruleIndex >= 0) {
                    this.buildTree(parentNode, rules, ruleIndex, group.ruleIndex);
                    ruleIndex = group.ruleIndex + 1;
                }
                if (group.openGroup) {
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(new RuleTreeUserObject(group));
                    parentNode.add(node);
                    parentStack.push(node);
                    continue;
                }
                if (parentStack.size() <= 1) continue;
                parentStack.pop();
            }
            if (ruleIndex < rules.size()) {
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parentStack.peek();
                this.buildTree(parentNode, rules, ruleIndex, rules.size() - 1);
            }
        }
        this.rulesTreeModel.reload();
        this.restoreSelectedTreeItem();
        this.restoreExpandedNodes();
    }

    public void rememberSelectedTreeItem() {
        DefaultMutableTreeNode node = this.rulesTree.getSelectedNode();
        this.selectedObject = null;
        if (node != null) {
            this.selectedObject = (RuleTreeUserObject)node.getUserObject();
        }
    }

    public void restoreSelectedTreeItem() {
        if (this.selectedObject == null) {
            return;
        }
        DefaultMutableTreeNode node = this.findNodeWithRuleName(this.selectedObject.rule.name);
        if (node == null) {
            return;
        }
        this.programmaticallySelectingRule = true;
        TreePath path = new TreePath(node.getPath());
        this.rulesTree.setSelectionPath(path);
        this.rulesTree.scrollPathToVisible(path);
        this.programmaticallySelectingRule = false;
    }

    public void saveExpandedNodes() {
        this.rulesTreeExpandedNodes.clear();
        Enumeration<TreeNode> e = this.rulesTreeRootNode.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (node.isLeaf() || node.isRoot() || !this.rulesTree.isExpanded(new TreePath(node.getPath()))) continue;
            RuleTreeUserObject n = (RuleTreeUserObject)node.getUserObject();
            this.rulesTreeExpandedNodes.add(n.group.name);
        }
    }

    public void restoreExpandedNodes() {
        for (String groupName : this.rulesTreeExpandedNodes) {
            DefaultMutableTreeNode node = this.findNodeWithGroupName(groupName);
            if (node == null) continue;
            this.rulesTree.expandPath(new TreePath(node.getPath()));
        }
    }

    public DefaultMutableTreeNode findNodeWithGroupName(String groupName) {
        Enumeration<TreeNode> e = this.rulesTreeRootNode.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            RuleTreeUserObject n = (RuleTreeUserObject)node.getUserObject();
            if (n.group == null || !n.group.name.equalsIgnoreCase(groupName)) continue;
            return node;
        }
        return null;
    }

    public DefaultMutableTreeNode findNodeWithRuleName(String ruleName) {
        Enumeration<TreeNode> e = this.rulesTreeRootNode.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            RuleTreeUserObject n = (RuleTreeUserObject)node.getUserObject();
            if (n.rule == null || !n.rule.name.equalsIgnoreCase(ruleName)) continue;
            return node;
        }
        return null;
    }

    protected void buildTree(DefaultMutableTreeNode parentNode, List<ElementRule> rules, int from, int to) {
        List<ElementRule> subrules = rules.subList(from, to + 1);
        if (this.sort && !subrules.isEmpty()) {
            subrules = this.getSortedRules(subrules);
            Collections.sort(subrules);
            ElementRule firstRule = subrules.get(0);
            if (firstRule.lexer) {
                for (int index = 0; index < subrules.size(); ++index) {
                    ElementRule rule = subrules.get(0);
                    if (!rule.lexer) break;
                    subrules.add(rule);
                    subrules.remove(0);
                }
            }
        }
        for (ElementRule rule : subrules) {
            parentNode.add(new DefaultMutableTreeNode(new RuleTreeUserObject(rule)));
        }
    }

    public void parserDidParse() {
        this.rebuildTree();
        if (this.selectNextRule) {
            this.selectNextRule = false;
            this.selectNextRule();
        } else {
            this.selectRuleInTreeAtPosition(this.editor.getCaretPosition());
        }
    }

    public boolean moveRule(ElementRule sourceRule, ElementRule targetRule, boolean dropAbove) {
        if (sourceRule == null || targetRule == null) {
            return false;
        }
        String sourceRuleText = this.editor.getText().substring(sourceRule.getStartIndex(), sourceRule.getEndIndex() + 1);
        try {
            Document doc = this.editor.getTextPane().getDocument();
            int removeStartIndex = sourceRule.getStartIndex();
            int targetInsertionIndex = dropAbove ? targetRule.getStartIndex() : targetRule.getEndIndex();
            int removeLength = sourceRule.getLength() + 1;
            if (removeStartIndex + removeLength > doc.getLength()) {
                --removeLength;
            }
            if (sourceRule.getStartIndex() > targetRule.getStartIndex()) {
                doc.remove(removeStartIndex, removeLength);
                doc.insertString(targetInsertionIndex, "\n" + sourceRuleText, null);
                this.editor.setCaretPosition(targetInsertionIndex);
            } else {
                doc.insertString(targetInsertionIndex, "\n" + sourceRuleText, null);
                doc.remove(removeStartIndex, removeLength);
                this.editor.setCaretPosition(targetInsertionIndex - removeLength);
            }
            return true;
        }
        catch (BadLocationException e) {
            this.editor.console.println(e);
            return false;
        }
    }

    public void selectRuleFromUserAction() {
        if (this.programmaticallySelectingRule) {
            return;
        }
        if (this.rulesTree.getSelectionCount() != 1) {
            return;
        }
        TreePath[] selPath = this.rulesTree.getSelectionPaths();
        if (selPath == null) {
            return;
        }
        ArrayList<ElementRule> selRules = new ArrayList<ElementRule>();
        for (TreePath aSelPath : selPath) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)aSelPath.getLastPathComponent();
            RuleTreeUserObject n = (RuleTreeUserObject)node.getUserObject();
            if (n.rule == null) continue;
            selRules.add(n.rule);
        }
        if (!selRules.isEmpty()) {
            this.goToRule((ElementRule)selRules.get(0));
            this.rulesTree.requestFocusInWindow();
        }
    }

    @Override
    public Cursor xjTreeDragSourceDefaultCursor(XJTree tree) {
        return DragSource.DefaultMoveDrop;
    }

    @Override
    public int xjTreeDragAndDropConstants(XJTree tree) {
        return 2;
    }

    @Override
    public boolean xjTreeDrop(XJTree tree, Object sourceObject, Object targetObject, int dropLocation) {
        StatisticsAW.shared().recordEvent(134);
        ElementRule sourceRule = ((RuleTreeUserObject)sourceObject).rule;
        ElementRule targetRule = ((RuleTreeUserObject)targetObject).rule;
        return this.moveRule(sourceRule, targetRule, dropLocation == 0);
    }

    public static class RuleTreeUserObject
    implements Transferable {
        public ComponentEditor editor;
        public ElementRule rule;
        public ElementGroup group;

        public RuleTreeUserObject(ElementRule rule) {
            this.rule = rule;
        }

        public RuleTreeUserObject(ElementGroup group) {
            this.group = group;
        }

        public RuleTreeUserObject(ComponentEditor editor) {
            this.editor = editor;
        }

        public String toString() {
            if (this.group != null) {
                return this.group.name;
            }
            if (this.rule != null) {
                return this.rule.name;
            }
            if (this.editor != null && this.editor.getDocument() != null) {
                return this.editor.getDocument().getDocumentName();
            }
            return "";
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[0];
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return false;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return null;
        }
    }

    public class RuleTreeMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            EditorRules.this.selectRuleFromUserAction();
            this.checkForPopupTrigger(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.checkForPopupTrigger(e);
        }

        public void checkForPopupTrigger(MouseEvent e) {
            if (e.isPopupTrigger()) {
                EditorRules.this.rulesTree.modifySelectionIfNecessary(e);
                ArrayList<Object> selectedObjects = new ArrayList<Object>();
                for (Object o : EditorRules.this.rulesTree.getSelectedNodes()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
                    selectedObjects.add(node.getUserObject());
                }
                JPopupMenu menu = EditorRules.this.editor.rulesGetContextualMenu(selectedObjects);
                if (menu != null) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }

    public class RuleTreeSelectionListener
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent e) {
            EditorRules.this.selectRuleFromUserAction();
        }
    }

    public static class RulesTableRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component r = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (XJSystem.isWindows()) {
                this.setBackgroundSelectionColor(HIGHLIGHTED_COLOR);
            }
            this.setIcon(null);
            this.setToolTipText("");
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            RuleTreeUserObject n = (RuleTreeUserObject)node.getUserObject();
            if (n.rule != null) {
                if (n.rule.lexer) {
                    this.setIcon(IconManager.shared().getIconLexer());
                } else {
                    this.setIcon(IconManager.shared().getIconParser());
                }
            }
            this.setFont(this.getFont().deriveFont(0));
            this.setForeground(Color.black);
            if (n.rule != null) {
                if (n.rule.hasErrors()) {
                    this.setForeground(Color.red);
                    this.setToolTipText(n.rule.getErrorMessageHTML());
                }
                if (n.rule.ignored) {
                    this.setFont(this.getFont().deriveFont(2));
                }
            }
            return r;
        }
    }

    public class RuleMoveDownAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent event) {
            ElementRule targetRule = EditorRules.this.getEnclosingRuleAtPosition(EditorRules.this.editor.getCaretPosition());
            int nextRuleIndex = EditorRules.this.getGrammarEngine().getRules().indexOf(targetRule) + 1;
            ElementRule sourceRule = EditorRules.this.getGrammarEngine().getRuleAtIndex(nextRuleIndex);
            if (sourceRule != null) {
                EditorRules.this.moveRule(sourceRule, targetRule, true);
                EditorRules.this.selectNextRule = true;
            }
        }
    }

    public class RuleMoveUpAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent event) {
            ElementRule sourceRule = EditorRules.this.getEnclosingRuleAtPosition(EditorRules.this.editor.getCaretPosition());
            int previousRuleIndex = EditorRules.this.getGrammarEngine().getRules().indexOf(sourceRule) - 1;
            if (previousRuleIndex >= 0) {
                ElementRule targetRule = EditorRules.this.getGrammarEngine().getRuleAtIndex(previousRuleIndex);
                EditorRules.this.moveRule(sourceRule, targetRule, true);
            }
        }
    }
}

