/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.dialog;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.antlr.works.IDE;
import org.antlr.works.find.FindAndReplace;
import org.antlr.xjlib.appkit.frame.XJPanel;
import org.antlr.xjlib.appkit.utils.XJAlert;

public class FindAndReplaceDialog
extends XJPanel {
    private FindAndReplace delegate;
    private JLabel label1;
    private JTextField findField;
    private JLabel label2;
    private JTextField replaceField;
    private JCheckBox ignoreCaseButton;
    private JCheckBox regexButton;
    private JComboBox optionsCombo;
    private JButton replaceAllButton;
    private JButton replaceButton;
    private JButton replaceAndFindButton;
    private JButton previousButton;
    private JButton nextButton;

    public FindAndReplaceDialog(FindAndReplace delegate) {
        this.delegate = delegate;
        this.initComponents();
        Dimension ps = this.getContentPane().getPreferredSize();
        ps.width += 40;
        ps.height += 40;
        this.setPreferredSize(ps);
        this.pack();
        this.setTitle("Find");
        this.awake();
        this.center();
        this.getRootPane().setDefaultButton(this.nextButton);
        this.addEscapeHandling();
        this.createActions();
        this.ignoreCaseButton.setSelected(true);
        delegate.setIgnoreCase(true);
    }

    public void setFindText(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        this.findField.setText(text);
    }

    public void addEscapeHandling() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0, true);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                FindAndReplaceDialog.this.setVisible(false);
            }
        };
        this.getRootPane().registerKeyboardAction(cancelAction, "CancelAction", ks, 2);
    }

    public void createActions() {
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FindAndReplaceDialog.this.delegate.setFindString(FindAndReplaceDialog.this.findField.getText());
                FindAndReplaceDialog.this.alertEndOfDocument(this, FindAndReplaceDialog.this.delegate.next());
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FindAndReplaceDialog.this.delegate.setFindString(FindAndReplaceDialog.this.findField.getText());
                FindAndReplaceDialog.this.alertBeginningOfDocument(this, FindAndReplaceDialog.this.delegate.prev());
            }
        });
        this.replaceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FindAndReplaceDialog.this.delegate.setReplaceString(FindAndReplaceDialog.this.replaceField.getText());
                FindAndReplaceDialog.this.delegate.replace();
            }
        });
        this.replaceAndFindButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FindAndReplaceDialog.this.delegate.setFindString(FindAndReplaceDialog.this.findField.getText());
                FindAndReplaceDialog.this.delegate.setReplaceString(FindAndReplaceDialog.this.replaceField.getText());
                FindAndReplaceDialog.this.delegate.replace();
                FindAndReplaceDialog.this.alertEndOfDocument(this, FindAndReplaceDialog.this.delegate.next());
            }
        });
        this.replaceAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FindAndReplaceDialog.this.delegate.setFindString(FindAndReplaceDialog.this.findField.getText());
                FindAndReplaceDialog.this.delegate.setReplaceString(FindAndReplaceDialog.this.replaceField.getText());
                FindAndReplaceDialog.this.delegate.replaceAll();
            }
        });
        this.ignoreCaseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FindAndReplaceDialog.this.delegate.setIgnoreCase(FindAndReplaceDialog.this.ignoreCaseButton.isSelected());
            }
        });
        this.regexButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FindAndReplaceDialog.this.delegate.setRegex(FindAndReplaceDialog.this.regexButton.isSelected());
            }
        });
        this.optionsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FindAndReplaceDialog.this.delegate.setOptions(FindAndReplaceDialog.this.optionsCombo.getSelectedIndex());
            }
        });
    }

    private void alertEndOfDocument(ActionListener actionListener, boolean result) {
        if (result) {
            return;
        }
        if (XJAlert.displayAlert(this.getJavaContainer(), "End of Document", "The end of the document has been reached.", "Continue", "OK", 0, 1) == 0) {
            this.delegate.setPositionToTop();
            actionListener.actionPerformed(null);
        }
    }

    private void alertBeginningOfDocument(ActionListener actionListener, boolean result) {
        if (result) {
            return;
        }
        if (XJAlert.displayAlert(this.getJavaContainer(), "Beginning of Document", "The beginning of the document has been reached.", "Continue", "OK", 0, 1) == 0) {
            this.delegate.setPositionToBottom();
            actionListener.actionPerformed(null);
        }
    }

    public boolean shouldDisplayMainMenuBar() {
        return super.shouldDisplayMainMenuBar() && !IDE.isPlugin();
    }

    private void initComponents() {
        this.label1 = new JLabel();
        this.findField = new JTextField();
        this.label2 = new JLabel();
        this.replaceField = new JTextField();
        this.ignoreCaseButton = new JCheckBox();
        this.regexButton = new JCheckBox();
        this.optionsCombo = new JComboBox();
        this.replaceAllButton = new JButton();
        this.replaceButton = new JButton();
        this.replaceAndFindButton = new JButton();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.DLUX5), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.DLUX5)}, new RowSpec[]{new RowSpec(Sizes.DLUY5), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.DLUY5)}));
        this.label1.setText("Find:");
        contentPane.add((Component)this.label1, cc.xy(3, 3));
        contentPane.add((Component)this.findField, cc.xywh(5, 3, 9, 1));
        this.label2.setText("Replace by:");
        contentPane.add((Component)this.label2, cc.xy(3, 5));
        contentPane.add((Component)this.replaceField, cc.xywh(5, 5, 9, 1));
        this.ignoreCaseButton.setText("Ignore case");
        contentPane.add((Component)this.ignoreCaseButton, cc.xy(5, 7));
        this.regexButton.setText("Regular expression");
        contentPane.add((Component)this.regexButton, cc.xy(7, 7));
        this.optionsCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Contains", "Starts with", "Whole words", "Ends with"}));
        contentPane.add((Component)this.optionsCombo, cc.xywh(11, 7, 3, 1));
        this.replaceAllButton.setText("Replace All");
        contentPane.add((Component)this.replaceAllButton, cc.xy(3, 11));
        this.replaceButton.setText("Replace");
        contentPane.add((Component)this.replaceButton, cc.xy(5, 11));
        this.replaceAndFindButton.setText("Replace & Find");
        contentPane.add((Component)this.replaceAndFindButton, cc.xy(7, 11));
        this.previousButton.setText("Previous");
        contentPane.add((Component)this.previousButton, cc.xy(11, 11));
        this.nextButton.setText("Next");
        contentPane.add((Component)this.nextButton, cc.xy(13, 11));
        this.pack();
    }
}

