/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.antlr.works.IDE;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.utils.Console;
import org.antlr.works.utils.StreamWatcher;
import org.antlr.works.utils.StreamWatcherDelegate;
import org.antlr.works.utils.Utils;
import org.antlr.xjlib.foundation.XJSystem;
import org.antlr.xjlib.foundation.XJUtils;

public class DebuggerEngine {
    public static Map<Thread, Process> processPerThread = new HashMap<Thread, Process>();

    public static void setProcess(Process p) {
        processPerThread.put(Thread.currentThread(), p);
    }

    public static void removeProcess() {
        processPerThread.remove(Thread.currentThread());
    }

    public static Process getProcess(Thread t) {
        return processPerThread.get(t);
    }

    public static Process getProcess() {
        return processPerThread.get(Thread.currentThread());
    }

    public static String getClassPath(String outputPath) {
        String sandbox;
        File dir;
        String appPath = IDE.getApplicationPath();
        String isDebuggingPlugin = System.getProperty("org.antlr.works.debug.plugin");
        if (isDebuggingPlugin != null && Boolean.parseBoolean(isDebuggingPlugin) && (dir = new File(sandbox = XJUtils.getPathByDeletingLastComponent(appPath) + File.separatorChar + "lib")).isDirectory()) {
            for (File f : dir.listFiles()) {
                String candidate = f.getAbsolutePath();
                if (!candidate.endsWith(".jar")) continue;
                appPath = appPath + File.pathSeparatorChar + candidate;
            }
        }
        String classPath = outputPath;
        if (appPath != null) {
            classPath = classPath + File.pathSeparatorChar + Utils.unquotePath(appPath);
        }
        if (AWPrefs.getUseSystemClassPath()) {
            classPath = classPath + File.pathSeparatorChar + Utils.unquotePath(System.getProperty("java.class.path"));
        }
        if (AWPrefs.getUseCustomClassPath()) {
            classPath = classPath + File.pathSeparatorChar + Utils.unquotePath(AWPrefs.getCustomClassPath());
        }
        classPath = classPath + File.pathSeparatorChar + ".";
        if (XJSystem.isWindows()) {
            return Utils.quotePath(classPath);
        }
        return classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runANTLR(Console console, String file, String libPath, String outputPath, StreamWatcherDelegate delegate) {
        String error = null;
        StreamWatcher esw = null;
        int result = 0;
        try {
            String[] args = new String[]{"java", "-cp", DebuggerEngine.getClassPath(outputPath), "org.antlr.Tool", "-o", Utils.quotePath(outputPath), "-lib", Utils.quotePath(libPath), file};
            IDE.debugVerbose(console, DebuggerEngine.class, "Run ANTLR: " + Utils.toString(args));
            Process p = Runtime.getRuntime().exec(args);
            DebuggerEngine.setProcess(p);
            esw = new StreamWatcher(p.getErrorStream(), "ANTLR[error]", delegate);
            esw.start();
            new StreamWatcher(p.getInputStream(), "ANTLR[stdout]", delegate).start();
            result = p.waitFor();
        }
        catch (Exception e) {
            error = "Failed to run ANTLR with exception:\n" + e.toString();
        }
        finally {
            DebuggerEngine.removeProcess();
        }
        if (result != 0) {
            error = "Failed to run ANTLR with result:\n" + result;
        }
        if (error == null) {
            for (String line : esw.getLines()) {
                if (line.startsWith("ANTLR Parser Generator") || line.startsWith("no such locale file")) continue;
                error = line;
                break;
            }
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runJava(Console console, String currentPath, String[] params, StreamWatcherDelegate delegate) {
        String error = null;
        int result = 0;
        try {
            String[] args = new String[3 + params.length];
            args[0] = "java";
            args[1] = "-cp";
            args[2] = DebuggerEngine.getClassPath(currentPath);
            System.arraycopy(params, 0, args, 3, params.length);
            IDE.debugVerbose(console, DebuggerEngine.class, "Run Java: " + Utils.toString(args));
            Process p = Runtime.getRuntime().exec(args, null, new File(currentPath));
            DebuggerEngine.setProcess(p);
            new StreamWatcher(p.getErrorStream(), "Java[error]", delegate).start();
            new StreamWatcher(p.getInputStream(), "Java[stdout]", delegate).start();
            result = p.waitFor();
        }
        catch (Exception e) {
            error = "Failed to run Java with exception:\n" + e.toString();
        }
        finally {
            DebuggerEngine.removeProcess();
        }
        if (result != 0) {
            error = "Failed to run Java with result:\n" + result;
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compileFiles(Console console, String[] files, String outputFileDir, StreamWatcherDelegate delegate) {
        String error = null;
        int result = 0;
        try {
            String compiler = AWPrefs.getCompiler();
            String classPath = DebuggerEngine.getClassPath(outputFileDir);
            if (compiler.equalsIgnoreCase("javac")) {
                String[] args = new String[5 + files.length];
                args[0] = AWPrefs.getJavaCCustomPath() ? XJUtils.concatPath(AWPrefs.getJavaCPath(), "javac") : "javac";
                args[1] = "-classpath";
                args[2] = classPath;
                args[3] = "-d";
                args[4] = Utils.quotePath(outputFileDir);
                System.arraycopy(files, 0, args, 5, files.length);
                IDE.debugVerbose(console, DebuggerEngine.class, "Compile: " + Utils.toString(args));
                Process p = Runtime.getRuntime().exec(args);
                DebuggerEngine.setProcess(p);
                new StreamWatcher(p.getErrorStream(), "Compiler[error]", delegate).start();
                new StreamWatcher(p.getInputStream(), "Compiler[stdout]", delegate).start();
                result = p.waitFor();
            } else if (compiler.equalsIgnoreCase("jikes")) {
                String jikesPath = XJUtils.concatPath(AWPrefs.getJikesPath(), "jikes");
                String[] args = new String[5 + files.length];
                args[0] = jikesPath;
                args[1] = "-classpath";
                args[2] = classPath;
                args[3] = "-d";
                args[4] = Utils.quotePath(outputFileDir);
                System.arraycopy(files, 0, args, 5, files.length);
                IDE.debugVerbose(console, DebuggerEngine.class, "Compile: " + Utils.toString(args));
                Process p = Runtime.getRuntime().exec(args);
                DebuggerEngine.setProcess(p);
                new StreamWatcher(p.getErrorStream(), "Compiler[error]", delegate).start();
                new StreamWatcher(p.getInputStream(), "Compiler[stdout]", delegate).start();
                result = p.waitFor();
            } else if (compiler.equalsIgnoreCase("integrated")) {
                String[] args = new String[2 + files.length];
                args[0] = "-d";
                args[1] = outputFileDir;
                System.arraycopy(files, 0, args, 2, files.length);
                Class<?> javac = Class.forName("com.sun.tools.javac.Main");
                Class[] p = new Class[]{String[].class};
                Method m = javac.getMethod("compile", p);
                Object[] a = new Object[]{args};
                Object r = m.invoke(javac.newInstance(), a);
                result = (Integer)r;
            }
        }
        catch (Error e) {
            error = "Compiler error:\n" + e.toString();
            e.printStackTrace();
        }
        catch (Exception e) {
            error = "Compiler exception:\n" + e.toString();
            e.printStackTrace();
        }
        finally {
            DebuggerEngine.removeProcess();
        }
        if (result != 0) {
            error = "Compiler failed with result code " + result;
        }
        return error;
    }
}

