// Wild Magic Source Code
// David Eberly
// http://www.geometrictools.com
// Copyright (c) 1998-2009
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or (at
// your option) any later version.  The license is available for reading at
// either of the locations:
//     http://www.gnu.org/copyleft/lgpl.html
//     http://www.geometrictools.com/License/WildMagicLicense.pdf
//
// Version: 4.0.2 (2008/02/18)

#ifndef SKINNINGEFFECT_H
#define SKINNINGEFFECT_H

#include "Wm4ShaderEffect.h"

namespace Wm4
{

class SkinningEffect : public ShaderEffect
{
    WM4_DECLARE_RTTI;
    WM4_DECLARE_NAME_ID;
    WM4_DECLARE_STREAM_WITH_POSTLINK;

public:
    SkinningEffect ();
    virtual ~SkinningEffect ();

    void SetMatrix (int i, const Matrix4f& rkMatrix);
    const Matrix4f& GetMatrix (int i) const;

protected:
    Matrix4f m_akMatrix[4];
};

WM4_REGISTER_STREAM(SkinningEffect);
typedef Pointer<SkinningEffect> SkinningEffectPtr;

#include "SkinningEffect.inl"

}

#endif
