package com.aelitis.azureus.ui.swt.shells.main;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationChecker;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.ConfigView;
import org.gudy.azureus2.ui.swt.views.stats.StatsView;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.mdi.*;
import com.aelitis.azureus.ui.swt.feature.FeatureManagerUI;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.views.ViewTitleInfoBetaP;
import com.aelitis.azureus.ui.swt.views.skin.SBC_ActivityTableView;
import com.aelitis.azureus.ui.swt.views.skin.SBC_PlusFTUX;
import com.aelitis.azureus.ui.swt.views.skin.SB_Transfers;
import com.aelitis.azureus.ui.swt.views.skin.SB_Vuze;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import com.aelitis.azureus.util.FeatureUtils;

public class MainMDISetup
{
	public static void setupSideBar(final MultipleDocumentInterfaceSWT mdi, final MdiListener l) {
		if (Utils.isAZ2UI()) {
			setupSidebarClassic(mdi);
		} else {
			setupSidebarVuze(mdi);
		}

		mdi.registerEntry(SideBar.SIDEBAR_TORRENT_DETAILS_PREFIX + ".*", new MdiEntryCreationListener() {
			public MdiEntry createMDiEntry(String id) {
				return createTorrentDetailEntry(mdi, id);
			}
		});

		Utils.execSWTThreadLater(0, new AERunnable() {
			public void runSupport() {
				final String CFG_STARTTAB = "v3.StartTab";
				String startTab;
				boolean showWelcome = COConfigurationManager.getBooleanParameter("v3.Show Welcome");
				if (ConfigurationChecker.isNewVersion()) {
					showWelcome = true;
				}

				ContentNetwork startupCN = ContentNetworkManagerFactory.getSingleton().getStartupContentNetwork();
				if (!startupCN.isServiceSupported(ContentNetwork.SERVICE_WELCOME)) {
					showWelcome = false;
				}

				if (showWelcome) {
					startTab = SideBar.SIDEBAR_SECTION_WELCOME;
				} else {
					if (!COConfigurationManager.hasParameter(CFG_STARTTAB, true)) {
						COConfigurationManager.setParameter(CFG_STARTTAB,
								SideBar.SIDEBAR_SECTION_LIBRARY);
					}
					startTab = COConfigurationManager.getStringParameter(CFG_STARTTAB);
					MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();

					if (mdi == null || mdi.getEntry(startTab) == null) {
						startTab = SideBar.SIDEBAR_SECTION_LIBRARY;
					}
				}
				if (startTab.equals(MultipleDocumentInterface.SIDEBAR_SECTION_PLUS)) {
					SBC_PlusFTUX.setSourceRef("lastview");
				}
				mdi.showEntryByID(startTab);
				if (l != null) {
					mdi.addListener(l);
				}
			}
		});
		
		COConfigurationManager.addAndFireParameterListener(
				"Beta Programme Enabled", new ParameterListener() {
					public void parameterChanged(String parameterName) {
						boolean enabled = COConfigurationManager.getBooleanParameter("Beta Programme Enabled");
						if (enabled) {
							mdi.loadEntryByID(MultipleDocumentInterface.SIDEBAR_SECTION_BETAPROGRAM, false);
						}
					}
		});
		
		mdi.registerEntry(StatsView.VIEW_ID, new MdiEntryCreationListener() {
			public MdiEntry createMDiEntry(String id) {
				MdiEntry entry = mdi.createEntryFromEventListener(
						MultipleDocumentInterface.SIDEBAR_HEADER_PLUGINS,
						new StatsView(), id, true, null, null);
				return entry;
			}
		});

		//		System.out.println("Activate sidebar " + startTab + " took "
		//				+ (SystemTime.getCurrentTime() - startTime) + "ms");
		//		startTime = SystemTime.getCurrentTime();
	}
	
	private static void setupSidebarClassic(final MultipleDocumentInterfaceSWT mdi) {
		mdi.registerEntry(MultipleDocumentInterface.SIDEBAR_SECTION_LIBRARY,
				new MdiEntryCreationListener() {

					public MdiEntry createMDiEntry(String id) {
						boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals(
								"az2");
						String title = uiClassic ? "{MyTorrentsView.mytorrents}"
								: ("{sidebar."
										+ MultipleDocumentInterface.SIDEBAR_SECTION_LIBRARY + "}");
						MdiEntry entry = mdi.createEntryFromSkinRef(null,
								MultipleDocumentInterface.SIDEBAR_SECTION_LIBRARY, "library",
								title, null, null, false,
								MultipleDocumentInterface.SIDEBAR_POS_FIRST);
						entry.setImageLeftID("image.sidebar.library");
						return entry;
					}
				});

		mdi.showEntryByID(MultipleDocumentInterface.SIDEBAR_SECTION_LIBRARY);
		
		mdi.registerEntry( ConfigView.VIEW_ID, new MdiEntryCreationListener() {
			public MdiEntry createMDiEntry(String id) {
				MdiEntry entry = mdi.createEntryFromEventListener(
						MultipleDocumentInterface.SIDEBAR_HEADER_PLUGINS,
						new ConfigView(), id, true, null, null);
				return entry;
			}
		});
	}

	
	private static void setupSidebarVuze(final MultipleDocumentInterface mdi) {
		MdiEntry entry;

		String[] preferredOrder = new String[] {
			MultipleDocumentInterface.SIDEBAR_HEADER_TRANSFERS,
			MultipleDocumentInterface.SIDEBAR_HEADER_VUZE,
			MultipleDocumentInterface.SIDEBAR_HEADER_DISCOVERY,
			MultipleDocumentInterface.SIDEBAR_HEADER_DEVICES,
			MultipleDocumentInterface.SIDEBAR_HEADER_SUBSCRIPTIONS,
			MultipleDocumentInterface.SIDEBAR_HEADER_DVD,
			MultipleDocumentInterface.SIDEBAR_HEADER_PLUGINS,
		};
		mdi.setPreferredOrder(preferredOrder);

		boolean[] disableCollapses = {
			true,
			false,
			false,
			false,
			false,
			false,
			false
		};
		for (int i = 0; i < preferredOrder.length; i++) {
			String id = preferredOrder[i];
			final boolean disableCollapse = disableCollapses[i];
			mdi.registerEntry(id, new MdiEntryCreationListener() {
				public MdiEntry createMDiEntry(String id) {
					MdiEntry entry = mdi.createHeader(id, "sidebar." + id, null);
					if (disableCollapse) {
						entry.setCollapseDisabled(true);
					} else {
						entry.setDefaultExpanded(true);
					}

					if (id.equals(MultipleDocumentInterface.SIDEBAR_HEADER_PLUGINS)) {
						entry.addListener(new MdiChildCloseListener() {
							public void mdiChildEntryClosed(MdiEntry parent, MdiEntry child,
									boolean user) {
								if (mdi.getChildrenOf(parent.getId()).size() == 0) {
									parent.close(true);
								}
							}
						});
						
						PluginInterface pi = PluginInitializer.getDefaultInterface();
						UIManager uim = pi.getUIManager();
						MenuManager menuManager = uim.getMenuManager();
						MenuItem menuItem;

						menuItem = menuManager.addMenuItem("sidebar."
								+ MultipleDocumentInterface.SIDEBAR_HEADER_PLUGINS,
								"label.plugin.options");
						
						menuItem.addListener(new MenuItemListener() {
							public void selected(MenuItem menu, Object target) {
								UIFunctions uif = UIFunctionsManager.getUIFunctions();

								if (uif != null) {

									uif.openView(UIFunctions.VIEW_CONFIG, "plugins");
								}
							}
						});
					}

					return entry;
				}
			});
		}

		mdi.loadEntryByID(MultipleDocumentInterface.SIDEBAR_SECTION_LIBRARY, false);
		mdi.loadEntryByID(
				MultipleDocumentInterface.SIDEBAR_SECTION_LIBRARY_UNOPENED, false);
		mdi.loadEntryByID(MultipleDocumentInterface.SIDEBAR_SECTION_SUBSCRIPTIONS,
				false);
		mdi.loadEntryByID(MultipleDocumentInterface.SIDEBAR_SECTION_DEVICES, false);

		entry = mdi.createEntryFromSkinRef(
				MultipleDocumentInterface.SIDEBAR_HEADER_DISCOVERY,
				ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork()),
				"main.area.browsetab", "{sidebar.VuzeHDNetwork}",
				null, null, false, null);
		entry.setImageLeftID("image.sidebar.vuze");

		/*
		ContentNetworkManager cnm = ContentNetworkManagerFactory.getSingleton();
		if (cnm != null) {
			ContentNetwork[] contentNetworks = cnm.getContentNetworks();
			for (ContentNetwork cn : contentNetworks) {
				if (cn == null) {
					continue;
				}
				if (cn.getID() == ConstantsVuze.getDefaultContentNetwork().getID()) {
					cn.setPersistentProperty(ContentNetwork.PP_ACTIVE, Boolean.TRUE);
					continue;
				}

				Object oIsActive = cn.getPersistentProperty(ContentNetwork.PP_ACTIVE);
				boolean isActive = (oIsActive instanceof Boolean)
						? ((Boolean) oIsActive).booleanValue() : false;
				if (isActive) {
					mdi.createContentNetworkSideBarEntry(cn);
				}
			}
		}
		*/

		if (Constants.isWindows && FeatureAvailability.isGamesEnabled()) {
			mdi.registerEntry(MultipleDocumentInterface.SIDEBAR_SECTION_GAMES,
					new MdiEntryCreationListener() {
						public MdiEntry createMDiEntry(String id) {
							MdiEntry entry = mdi.createEntryFromSkinRef(
									MultipleDocumentInterface.SIDEBAR_HEADER_DISCOVERY,
									MultipleDocumentInterface.SIDEBAR_SECTION_GAMES,
									"main.generic.browse",
									"{mdi.entry.games}", null, null, true,
									null);
							((BaseMdiEntry) entry).setPreferredAfterID(ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork()));
							String url = ConstantsVuze.getDefaultContentNetwork().getSiteRelativeURL(
									"starts/games.start", false);
							entry.setDatasource(url);
							entry.setImageLeftID("image.sidebar.games");
							return entry;
						}
					});
			mdi.loadEntryByID(MultipleDocumentInterface.SIDEBAR_SECTION_GAMES, false,
					true, null);
		}

		mdi.registerEntry(MultipleDocumentInterface.SIDEBAR_SECTION_ABOUTPLUGINS,
				new MdiEntryCreationListener() {
					public MdiEntry createMDiEntry(String id) {
						MdiEntry entry = mdi.createEntryFromSkinRef(
								MultipleDocumentInterface.SIDEBAR_HEADER_PLUGINS,
								MultipleDocumentInterface.SIDEBAR_SECTION_ABOUTPLUGINS,
								"main.generic.browse",
								"{mdi.entry.about.plugins}", null, null,
								true, MultipleDocumentInterface.SIDEBAR_POS_FIRST);
						String url = ConstantsVuze.getDefaultContentNetwork().getSiteRelativeURL(
								"plugins", true);
						entry.setDatasource(url);
						entry.setImageLeftID("image.sidebar.plugin");
						return entry;
					}
				});
		//loadEntryByID(MultipleDocumentInterface.SIDEBAR_SECTION_ABOUTPLUGINS, true, false);

		// building plugin views needs UISWTInstance, which needs core.
		final int burnInfoShown = COConfigurationManager.getIntParameter(
				"burninfo.shown", 0);
		if (burnInfoShown == 0) {
			AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener() {
				public void azureusCoreRunning(AzureusCore core) {
					Utils.execSWTThread(new AERunnable() {
						public void runSupport() {
							if (FeatureManagerUI.enabled) {
								// blah, can't add until plugin initialization is done

								mdi.loadEntryByID(
										MultipleDocumentInterface.SIDEBAR_SECTION_PLUS, false);

								if (!FeatureUtils.hasFullBurn()){
									mdi.loadEntryByID(
											MultipleDocumentInterface.SIDEBAR_SECTION_BURN_INFO,
											false);
								}

								COConfigurationManager.setParameter("burninfo.shown",
										burnInfoShown + 1);
							}
						}
					});
				}
			});
		}

		SBC_ActivityTableView.setupSidebarEntry();

		SB_Transfers.setup(mdi);
		new SB_Vuze(mdi);
	}
	

	protected static MdiEntry createTorrentDetailEntry(MultipleDocumentInterface mdi, String id) {
		MdiEntry torrentDetailEntry = mdi.createEntryFromSkinRef(
				SideBar.SIDEBAR_HEADER_TRANSFERS,
				id, "torrentdetails",
				"", null, null, true, null);
		torrentDetailEntry.setImageLeftID("image.sidebar.details");

		return torrentDetailEntry;
	}
}
