/*
 * Created on 24-Apr-2006
 * Created by Paul Gardner
 * Copyright (C) 2006 Aelitis, All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * AELITIS, SAS au capital de 46,603.30 euros
 * 8 Allee Lenotre, La Grille Royale, 78600 Le Mesnil le Roi, France.
 *
 */

package com.aelitis.azureus.jdk15;

import com.aelitis.azureus.core.monitoring.thread.AEThreadMonitor;
import com.aelitis.azureus.core.util.Java15Utils.Java15UtilsProvider;
import com.aelitis.azureus.vivaldi.ver2.VivaldiV2PositionProvider;

public class 
Java15Initialiser 
{
	private static Java15UtilsProvider		utils_provider;
	
	static{
		
		try{
				// try and pull in a 1.5 class
			
			Class.forName( "java.lang.management.ManagementFactory" );
			
			try{
				utils_provider	= new Java15UtilsImpl();
				
				AEThreadMonitor.initialise();
	
				VivaldiV2PositionProvider.initialise();
				
			}catch( Throwable e ){
				
				e.printStackTrace();
			}
			
		}catch( Throwable e ){
		}
	}
	
	public static Java15UtilsProvider
	getUtilsProvider()
	{
		return( utils_provider );
	}
}
