/**
 * Copyright (C) 2007 Aelitis, All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * AELITIS, SAS au capital de 63.529,40 euros
 * 8 Allee Lenotre, La Grille Royale, 78600 Le Mesnil le Roi, France.
 *
 */

package org.gudy.azureus2.ui.swt.views.table.impl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.*;

import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;

/**
 * @author TuxPaper
 * @created Mar 1, 2007
 *
 */
public class TableTooltips
	implements Listener
{
	Shell toolTipShell = null;

	Shell mainShell = null;

	Label toolTipLabel = null;

	private final Composite composite;

	private final TableViewSWT tv;

	/**
	 * Initialize
	 */
	public TableTooltips(TableViewSWT tv, Composite composite) {
		this.tv = tv;
		this.composite = composite;
		mainShell = composite.getShell();

		composite.addListener(SWT.Dispose, this);
		composite.addListener(SWT.KeyDown, this);
		composite.addListener(SWT.MouseMove, this);
		composite.addListener(SWT.MouseHover, this);
		mainShell.addListener(SWT.Deactivate, this);
		tv.getComposite().addListener(SWT.Deactivate, this);
	}

	public void handleEvent(Event event) {
		switch (event.type) {
			case SWT.MouseHover: {
				if (toolTipShell != null && !toolTipShell.isDisposed())
					toolTipShell.dispose();

				TableCellSWT cell = tv.getTableCell(event.x, event.y);
				if (cell == null)
					return;
				cell.invokeToolTipListeners(TableCellSWT.TOOLTIPLISTENER_HOVER);
				Object oToolTip = cell.getToolTip();

				// TODO: support composite, image, etc
				if (oToolTip == null || !(oToolTip instanceof String))
					return;
				String sToolTip = (String) oToolTip;

				Display d = composite.getDisplay();
				if (d == null)
					return;

				// We don't get mouse down notifications on trim or borders..
				toolTipShell = new Shell(composite.getShell(), SWT.ON_TOP);
				FillLayout f = new FillLayout();
				try {
					f.marginWidth = 3;
					f.marginHeight = 1;
				} catch (NoSuchFieldError e) {
					/* Ignore for Pre 3.0 SWT.. */
				}
				toolTipShell.setLayout(f);
				toolTipShell.setBackground(d.getSystemColor(SWT.COLOR_INFO_BACKGROUND));

				toolTipLabel = new Label(toolTipShell, SWT.WRAP);
				toolTipLabel.setForeground(d.getSystemColor(SWT.COLOR_INFO_FOREGROUND));
				toolTipLabel.setBackground(d.getSystemColor(SWT.COLOR_INFO_BACKGROUND));
				toolTipShell.setData("TableCellSWT", cell);
				toolTipLabel.setText(sToolTip.replaceAll("&", "&&"));
				// compute size on label instead of shell because label
				// calculates wrap, while shell doesn't
				Point size = toolTipLabel.computeSize(SWT.DEFAULT, SWT.DEFAULT);
				if (size.x > 600) {
					size = toolTipLabel.computeSize(600, SWT.DEFAULT, true);
				}
				size.x += toolTipShell.getBorderWidth() * 2 + 2;
				size.y += toolTipShell.getBorderWidth() * 2;
				try {
					size.x += toolTipShell.getBorderWidth() * 2 + (f.marginWidth * 2);
					size.y += toolTipShell.getBorderWidth() * 2 + (f.marginHeight * 2);
				} catch (NoSuchFieldError e) {
					/* Ignore for Pre 3.0 SWT.. */
				}
				Point pt = composite.toDisplay(event.x, event.y);
				Rectangle displayRect;
				try {
					displayRect = composite.getMonitor().getClientArea();
				} catch (NoSuchMethodError e) {
					displayRect = composite.getDisplay().getClientArea();
				}
				if (pt.x + size.x > displayRect.x + displayRect.width) {
					pt.x = displayRect.x + displayRect.width - size.x;
				}

				if (pt.y + size.y > displayRect.y + displayRect.height) {
					pt.y -= size.y + 2;
				} else {
					pt.y += 21;
				}

				if (pt.y < displayRect.y)
					pt.y = displayRect.y;

				toolTipShell.setBounds(pt.x, pt.y, size.x, size.y);
				toolTipShell.setVisible(true);

				break;
			}

			case SWT.Dispose:
				if (mainShell != null && !mainShell.isDisposed())
					mainShell.removeListener(SWT.Deactivate, this);
				if (tv.getComposite() != null && !tv.getComposite().isDisposed())
					mainShell.removeListener(SWT.Deactivate, this);
				// fall through

			default:
				if (toolTipShell != null) {
					toolTipShell.dispose();
					toolTipShell = null;
					toolTipLabel = null;
				}
				break;
		} // switch
	} // handlEvent()
}
