/*
 * Created on Aug 6, 2008
 * Created by Paul Gardner
 * 
 * Copyright 2008 Vuze, Inc.  All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License only.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */


package com.aelitis.azureus.core.subs;

public interface 
SubscriptionHistory 
{
	public static final int	DEFAULT_CHECK_INTERVAL_MINS		= 120;

	public boolean
	isEnabled();
	
	public void
	setEnabled(
		boolean		enabled );
	
	public boolean
	isAutoDownload();
	
	public void
	setAutoDownload(
		boolean		auto_dl );

	public void
	setDetails(
		boolean		enabled,
		boolean		auto_dl );
	
	public void
	deleteResults(
		String[]		result_ids );
	
	public void
	deleteAllResults();
	
	public void
	markAllResultsRead();
	
	public void
	markAllResultsUnread();
	
	public void
	markResults(
		String[]		result_ids,
		boolean[]		read );
	
	public void
	reset();
	
	public long
	getLastScanTime();
	
	public long
	getLastNewResultTime();
	
	public long
	getNextScanTime();
	
	public int
	getNumUnread();
	
	public int
	getNumRead();
	
	public int
	getCheckFrequencyMins();
	
	public String
	getLastError();
	
	public boolean
	isAuthFail();
	
	public int
	getConsecFails();
	
	public SubscriptionResult[]
	getResults(
		boolean		include_deleted );
	
	public SubscriptionResult
	getResult(
		String		result_id );
}
