/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;

public final class UserSplashScreen
extends Frame {
    private static final long serialVersionUID = 1L;
    private final String mImageId;
    private MediaTracker mMediaTracker;
    private Image mImage;

    public UserSplashScreen(String aImageId) {
        if (aImageId == null || aImageId.trim().length() == 0) {
            throw new IllegalArgumentException("Image Id does not have content.");
        }
        this.mImageId = aImageId;
    }

    public void splash() {
        this.initImageAndTracker();
        this.setSize(this.mImage.getWidth(null), this.mImage.getHeight(null));
        this.center();
        this.mMediaTracker.addImage(this.mImage, 0);
        try {
            this.mMediaTracker.waitForID(0);
        }
        catch (InterruptedException ie) {
            System.out.println("Cannot track image load.");
        }
        SplashWindow splashWindow = new SplashWindow(this, this.mImage);
        splashWindow.validate();
    }

    private void initImageAndTracker() {
        this.mMediaTracker = new MediaTracker(this);
        this.mImage = Toolkit.getDefaultToolkit().getImage(this.mImageId);
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    private class SplashWindow
    extends Window {
        private static final long serialVersionUID = 1L;
        private Image fImage;

        SplashWindow(Frame aParent, Image aImage) {
            super(aParent);
            this.fImage = aImage;
            this.setSize(this.fImage.getWidth(null), this.fImage.getHeight(null));
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle window = this.getBounds();
            this.setLocation((screen.width - window.width) / 2, (screen.height - window.height) / 2);
            this.setVisible(true);
        }

        public void paint(Graphics pGraphics) {
            if (this.fImage != null) {
                pGraphics.drawImage(this.fImage, 0, 0, this);
            }
        }
    }
}

