/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import userInterface.UserDesktopPane;
import userInterface.UserFrame;

public class UserMenuWindow
extends JMenu {
    private static final long serialVersionUID = 1L;
    private UserFrame mUserFrame;
    private UserDesktopPane mDesktop;
    private JMenuItem mCascade;
    private JMenuItem mTile;

    public UserMenuWindow(String pString, UserDesktopPane pDesktop, UserFrame pUserFrame) {
        super(pString);
        this.mDesktop = pDesktop;
        this.mUserFrame = pUserFrame;
        this.mCascade = new JMenuItem((String)this.mUserFrame.getI18n().getObject("CASCADE_LABEL"));
        this.mTile = new JMenuItem((String)this.mUserFrame.getI18n().getObject("TILE_LABEL"));
        this.mCascade.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UserMenuWindow.this.mDesktop.cascadeFrames();
            }
        });
        this.mTile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UserMenuWindow.this.mDesktop.tileFrames();
            }
        });
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
                UserMenuWindow.this.removeAll();
            }

            public void menuSelected(MenuEvent e) {
                UserMenuWindow.this.buildChildMenus();
            }
        });
    }

    private void buildChildMenus() {
        JInternalFrame[] array = this.mDesktop.getAllFrames();
        this.add(this.mCascade);
        this.add(this.mTile);
        if (array.length > 0) {
            this.addSeparator();
        }
        this.mCascade.setEnabled(array.length > 0);
        this.mTile.setEnabled(array.length > 0);
        int i = 0;
        while (i < array.length) {
            ChildMenuItem menu = new ChildMenuItem(array[i]);
            menu.setState(i == 0);
            menu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JInternalFrame frame = ((ChildMenuItem)ae.getSource()).getFrame();
                    frame.moveToFront();
                    try {
                        frame.setSelected(true);
                    }
                    catch (PropertyVetoException e) {
                        e.printStackTrace();
                    }
                }
            });
            menu.setIcon(array[i].getFrameIcon());
            this.add(menu);
            ++i;
        }
    }

    protected JMenuItem getCascade() {
        return this.mCascade;
    }

    protected JMenuItem getTile() {
        return this.mTile;
    }

    public class ChildMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 1L;
        private JInternalFrame frame;

        public ChildMenuItem(JInternalFrame frame) {
            super(frame.getTitle());
            this.frame = frame;
        }

        public JInternalFrame getFrame() {
            return this.frame;
        }
    }
}

