/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import userInterface.UserFrame;

public class UserHighlightPane
extends JComponent {
    private static final long serialVersionUID = 1L;
    private UserFrame mUserFrame;
    private int mEndX;
    private int mEndY;
    private int mStartX;
    private int mStartY;
    private boolean mHighlight;

    public UserHighlightPane(UserFrame pUserFrame) {
        this.mUserFrame = pUserFrame;
    }

    public void paint(Graphics g) {
        Graphics2D lGraphics2D = (Graphics2D)g;
        lGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        lGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        GeneralPath polly = new GeneralPath();
        polly.moveTo(this.mStartX, this.mStartY);
        polly.lineTo(this.mStartX, this.mEndY);
        polly.lineTo(this.mEndX, this.mEndY);
        polly.lineTo(this.mEndX, this.mStartY);
        polly.closePath();
        if (this.mHighlight) {
            lGraphics2D.setColor(new Color(0, 0, 255, 90));
        } else {
            lGraphics2D.setColor(new Color(0, 0, 0, 90));
        }
        lGraphics2D.draw(polly);
        if (this.mHighlight) {
            lGraphics2D.setColor(new Color(0, 0, 255, 30));
        } else {
            lGraphics2D.setColor(new Color(0, 0, 0, 30));
        }
        lGraphics2D.fill(polly);
    }

    public void exit() {
        this.mUserFrame.getDesktopPane().getInternalFrame().deactivateHighlightPane();
    }

    public void setEndPosition(int x, int y) {
        this.mEndX = x;
        this.mEndY = y;
        this.repaint();
    }

    public void copyImage() {
        if (!this.mHighlight) {
            this.mUserFrame.getUserControl().copyTree(Math.abs(this.mStartX - this.mEndX), Math.abs(this.mStartY - this.mEndY), this.mStartX < this.mEndX ? this.mStartX : this.mEndX, this.mStartY < this.mEndY ? this.mStartY : this.mEndY);
        } else {
            this.mUserFrame.getSyntaxFacade().selectTree(this.mStartX < this.mEndX ? this.mStartX : this.mEndX, this.mStartY < this.mEndY ? this.mStartY : this.mEndY, this.mStartX > this.mEndX ? this.mStartX : this.mEndX, this.mStartY > this.mEndY ? this.mStartY : this.mEndY);
        }
        this.exit();
    }

    public void setStartPosition(int x, int y) {
        this.mStartX = x;
        this.mStartY = y;
    }

    public void setHighlightType(MouseEvent e) {
        this.mHighlight = (e.getModifiersEx() & 0x40) == 0;
    }
}

