/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import enumerators.ExportPictureType;
import enumerators.SaveFileType;
import enumerators.SyntacticViewLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.print.DocPrintJob;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import parser.XMLParser;
import staticFunctions.Sizer;
import syntaxTree.EditableComponent;
import syntaxTree.SyntaxFacade;
import userInterface.AboutFrame;
import userInterface.FileFilterJPG300;
import userInterface.FileFilterJPG600;
import userInterface.FileFilterPNG300;
import userInterface.FileFilterPNG600;
import userInterface.FileFilterXML;
import userInterface.HelpFrame;
import userInterface.PrintUtilities;
import userInterface.PropertiesFrame;
import userInterface.UserDesktopPane;
import userInterface.UserFrame;
import userInterface.UserInternalFrame;
import userInterface.UserTransferable;
import userInterface.UserTransferableGraphics;
import userInterface.WhatNewFrame;

public class UserControl {
    private UserFrame mUserFrame;
    static /* synthetic */ Class class$0;

    public UserControl(UserFrame pUserFrame) {
        this.mUserFrame = pUserFrame;
    }

    public void loadTree() {
        FileDialog fileDialog = new FileDialog((Frame)this.mUserFrame, "Load Syntax Tree");
        FileFilterXML fileFilterXML = new FileFilterXML();
        fileDialog.setFilenameFilter(fileFilterXML);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            XMLParser lXMLP = new XMLParser();
            lXMLP.loadFileFromDisk(this.mUserFrame, new File(String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile()));
            this.mUserFrame.getObservableNew().setValue(this.mUserFrame.getObservableNew().getValue() + 1);
        }
    }

    public void printTree() {
        Container lC = this.mUserFrame.getInternalFrame().getContentPane();
        Color lColor = lC.getBackground();
        lC.setBackground(new Color(255, 255, 255));
        this.mUserFrame.getSyntaxFacade().deselectTree();
        PrintUtilities.printComponent(lC);
        lC.setBackground(lColor);
    }

    public void exportPicture(SyntaxFacade pSyntaxFacade) {
        JFileChooser lChooser = new JFileChooser();
        lChooser.setDialogTitle("Export Picture");
        lChooser.setAcceptAllFileFilterUsed(false);
        lChooser.setFileSelectionMode(2);
        lChooser.setFileFilter(new FileFilterJPG300());
        lChooser.addChoosableFileFilter(new FileFilterJPG600());
        lChooser.addChoosableFileFilter(new FileFilterPNG300());
        lChooser.addChoosableFileFilter(new FileFilterPNG600());
        lChooser.setSelectedFile(pSyntaxFacade.getPicture());
        int returnVal = lChooser.showSaveDialog(this.mUserFrame);
        if (returnVal == 0) {
            ExportPictureType lExportPictureType = null;
            File lFile = lChooser.getSelectedFile();
            if (lChooser.getFileFilter() instanceof FileFilterJPG300) {
                lExportPictureType = ExportPictureType.JPG300;
                lFile = this.checkExtension(lFile, ".jpg");
            } else if (lChooser.getFileFilter() instanceof FileFilterJPG600) {
                lExportPictureType = ExportPictureType.JPG600;
                lFile = this.checkExtension(lFile, ".jpg");
            } else if (lChooser.getFileFilter() instanceof FileFilterPNG300) {
                lExportPictureType = ExportPictureType.PNG300;
                lFile = this.checkExtension(lFile, ".png");
            } else if (lChooser.getFileFilter() instanceof FileFilterPNG600) {
                lExportPictureType = ExportPictureType.PNG600;
                lFile = this.checkExtension(lFile, ".png");
            }
            pSyntaxFacade.setPicture(lFile.getPath());
            this.exportTree(pSyntaxFacade, lFile, lExportPictureType);
        }
    }

    private void exportTree(SyntaxFacade pSyntaxFacade, File pFile, ExportPictureType pEPT) {
        String lType;
        int lDetail = pEPT == ExportPictureType.JPG600 || pEPT == ExportPictureType.PNG600 ? 600 : 300;
        if (pEPT == ExportPictureType.JPG300 || pEPT == ExportPictureType.JPG600) {
            lType = "jpg";
            System.out.println("jpg");
        } else {
            lType = "png";
            System.out.println("png");
        }
        BufferedImage lImg = this.createGraphicData(lDetail, pFile);
        if (lImg != null) {
            this.writeGraphicsFile(lType, pFile, lImg);
        }
    }

    private BufferedImage createGraphicData(int lDetail, File pFile) {
        Container lC = this.mUserFrame.getDesktopPane().getInternalFrame().getContentPane();
        Color lColor = lC.getBackground();
        lC.setBackground(new Color(255, 255, 255));
        JPanel lPanel = (JPanel)lC;
        try {
            BufferedImage lImg = new BufferedImage(new Float((float)lPanel.getWidth() * ((float)(lDetail / 72) / Sizer.scaleWidth())).intValue(), new Float((float)lPanel.getHeight() * ((float)(lDetail / 72) / Sizer.scaleHeight())).intValue(), 1);
            Graphics lGraphics = lImg.getGraphics();
            Graphics2D lG2D = (Graphics2D)lGraphics;
            AffineTransform lAT = new AffineTransform();
            lAT.setToScale((float)(lDetail / 72) / Sizer.scaleWidth(), (float)(lDetail / 72) / Sizer.scaleHeight());
            lG2D.setTransform(lAT);
            lPanel.print(lG2D);
            lC.setBackground(lColor);
            return lImg;
        }
        catch (OutOfMemoryError pOME) {
            JOptionPane.showMessageDialog(null, "You have not allocated enough memory to Java to export this picture", "Run this program using the batch script instead", 0);
            lC.setBackground(lColor);
            return null;
        }
    }

    public void writeGraphicsFile(String lType, File pFile, BufferedImage lImg) {
        if (lType.equals("jpg")) {
            try {
                FileOutputStream lOut = new FileOutputStream(pFile);
                Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix("jpeg");
                ImageWriter writer = writers.next();
                ImageOutputStream ios = ImageIO.createImageOutputStream(lOut);
                writer.setOutput(ios);
                ImageWriteParam param = writer.getDefaultWriteParam();
                param.setCompressionMode(2);
                param.setCompressionQuality(1.0f);
                writer.write(null, new IIOImage(lImg, null, null), param);
                ios.close();
                writer.dispose();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (lType.equals("png")) {
            try {
                ImageIO.write((RenderedImage)lImg, "png", pFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(null, "You have not chosen a valid file type", "I have no idea how you got here!", 0);
        }
    }

    public void openHelp() {
        System.out.println("Open About");
        HelpFrame lHelpFrame = new HelpFrame();
        lHelpFrame.validate();
    }

    public void saveTree(SyntaxFacade pSyntaxFacade, File pFile, SaveFileType pSFT) {
        if (pSyntaxFacade.getName() == "") {
            this.saveAsTree(pSyntaxFacade);
        } else if (pSFT == SaveFileType.XML) {
            XMLParser lXML = new XMLParser();
            lXML.saveFileToDisk(pSyntaxFacade);
        }
    }

    public void saveAsTree(SyntaxFacade pSyntaxFacade) {
        FileDialog fileDialog = new FileDialog((Frame)this.mUserFrame, "Save Syntax Tree", 1);
        FileFilterXML fileFilterXML = new FileFilterXML();
        fileDialog.setFilenameFilter(fileFilterXML);
        fileDialog.setFile(pSyntaxFacade.getFile().getName());
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            pSyntaxFacade.setName(fileDialog.getFile());
            SaveFileType lSaveFileType = SaveFileType.XML;
            File lFile = new File(String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile());
            lFile = this.checkExtension(lFile, ".xml");
            pSyntaxFacade.setFile(lFile.getPath());
            pSyntaxFacade.setName(lFile.getName());
            pSyntaxFacade.getUIF().setTitle(lFile.getName());
            this.saveTree(pSyntaxFacade, lFile, lSaveFileType);
        }
    }

    private File checkExtension(File lFile, String pExtension) {
        if (!lFile.getName().endsWith(pExtension)) {
            lFile = lFile.getName().indexOf(".") == -1 ? new File(String.valueOf(lFile.getPath()) + pExtension) : new File(String.valueOf(lFile.getPath().substring(0, lFile.getPath().indexOf("."))) + pExtension);
        }
        return lFile;
    }

    public void addDemographicInformation() {
    }

    public void editPresenation() {
        PropertiesFrame propertiesFrame = new PropertiesFrame(this.mUserFrame.getDesktopPane().getInternalFrame());
        propertiesFrame.setVisible(true);
    }

    public void createNewTree() {
        this.mUserFrame.getDesktopPane().addInternalFrame();
    }

    public void changeViewLayout(SyntacticViewLayout pSyntacticViewLayout) {
        JOptionPane.showMessageDialog(null, "Not Impemented", "This code has not been written yet.", 1);
        System.out.println(pSyntacticViewLayout);
    }

    public void closeTree() {
        int lI = JOptionPane.showConfirmDialog(null, "Clicking NO will close trees without saving them.", "Save trees first?", 0);
        if (lI == 0) {
            this.saveAsTree(this.mUserFrame.getSyntaxFacade());
        } else {
            this.mUserFrame.getDesktopPane().closeInternalFrame();
        }
    }

    public boolean closeAllTrees() {
        int lI = JOptionPane.showConfirmDialog(null, "Clicking NO will close ALL trees without saving them.", "Save trees first?", 0);
        if (lI == 0) {
            this.saveAllTrees(this.mUserFrame.getDesktopPane());
            return false;
        }
        if (lI == 1) {
            this.mUserFrame.getDesktopPane().closeAllInternalFrames();
            return true;
        }
        return false;
    }

    public void saveAllTrees(UserDesktopPane pUdp) {
        JInternalFrame[] internalPanes = pUdp.getAllFrames();
        int i = 0;
        while (i < internalPanes.length) {
            this.saveTree(((UserInternalFrame)internalPanes[i]).getSyntaxFacade(), ((UserInternalFrame)internalPanes[i]).getSyntaxFacade().getFile(), ((UserInternalFrame)internalPanes[i]).getSaveFileType());
            ++i;
        }
    }

    public void redo() {
        this.mUserFrame.getDesktopPane().getInternalFrame().getSyntaxFacade().redo();
    }

    public void undo() {
        this.mUserFrame.getDesktopPane().getInternalFrame().getSyntaxFacade().undo();
    }

    public void copy() {
        if (this.mUserFrame.getObservableClipboard().getValue() instanceof EditableComponent) {
            UserControl.setClipboard(((EditableComponent)this.mUserFrame.getObservableClipboard().getValue()).getClip());
        }
    }

    public void cut() {
        if (this.mUserFrame.getObservableClipboard().getValue() instanceof EditableComponent) {
            UserControl.setClipboard(((EditableComponent)this.mUserFrame.getObservableClipboard().getValue()).getClip());
        }
    }

    public void paste() {
        if (this.mUserFrame.getObservableClipboard().getValue() instanceof EditableComponent) {
            EditableComponent ec = (EditableComponent)this.mUserFrame.getObservableClipboard().getValue();
            Object lObject = UserControl.getClipboard();
            AttributedString lAT = null;
            if (lObject instanceof String) {
                lAT = new AttributedString((String)lObject);
                lAT.addAttributes(this.getAttributes(), 0, ((String)lObject).length());
            } else {
                lAT = (AttributedString)lObject;
            }
            int lLength = lAT.getIterator().getEndIndex() - lAT.getIterator().getBeginIndex();
            ec.deleteHead();
            ec.insertHead(lAT, ec.getInsertionIndex());
            ec.setInsertionIndex(ec.getInsertionIndex() + lLength);
            ec.setHighlightEnd(ec.getInsertionIndex());
            ec.setHighlightBegin(ec.getInsertionIndex());
            ec.setCarat(true);
            this.mUserFrame.getDesktopPane().getInternalFrame().getSyntaxFacade().displayTree();
        }
    }

    public Map getAttributes() {
        AffineTransform lAT;
        HashMap<TextAttribute, Serializable> lMap = new HashMap<TextAttribute, Serializable>();
        int lStyle = 0;
        if (this.mUserFrame.getObservableFontBold().getValue()) {
            ++lStyle;
        }
        if (this.mUserFrame.getObservableFontItalic().getValue()) {
            lStyle += 2;
        }
        Font lFont = new Font(this.mUserFrame.getObservableFont().getValue(), lStyle, this.mUserFrame.getObservableFontSize().getValue());
        if (this.mUserFrame.getObservableSubscript().getValue()) {
            lAT = new AffineTransform();
            lAT.translate(0.0, 1.0);
            lAT.scale(0.6666666666666666, 0.6666666666666666);
            lFont = lFont.deriveFont(lAT);
        }
        if (this.mUserFrame.getObservableSuperscript().getValue()) {
            lAT = new AffineTransform();
            lAT.translate(0.0, -3.0);
            lAT.scale(0.6666666666666666, 0.6666666666666666);
            lFont = lFont.deriveFont(lAT);
        }
        lMap.put(TextAttribute.FONT, lFont);
        if (this.mUserFrame.getObservableFontUnderline().getValue()) {
            lMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        } else {
            lMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE);
        }
        if (this.mUserFrame.getObservableFontStrikethrough().getValue()) {
            lMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        } else {
            lMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH);
        }
        lMap.put(TextAttribute.BACKGROUND, this.mUserFrame.getObservableBackgroundColor().getValue());
        if (((Color)lMap.get(TextAttribute.BACKGROUND)).getRed() == 255 && ((Color)lMap.get(TextAttribute.BACKGROUND)).getGreen() == 255 && ((Color)lMap.get(TextAttribute.BACKGROUND)).getBlue() == 255) {
            lMap.put(TextAttribute.BACKGROUND, new Color(255, 255, 255, 0));
        }
        lMap.put(TextAttribute.FOREGROUND, this.mUserFrame.getObservableFontColor().getValue());
        return lMap;
    }

    public static void setClipboard(AttributedString lAS) {
        UserTransferable t = new UserTransferable(lAS);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(t, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getClipboard() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        String text = "";
        if (t != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.text.AttributedString");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (t.isDataFlavorSupported(new DataFlavor(clazz, "Attributed String"))) {
                try {
                    Class<?> clazz2 = class$0;
                    Class<?> clazz3 = clazz2;
                    if (clazz2 != null) return t.getTransferData(new DataFlavor(clazz3, "Attributed String"));
                    try {
                        clazz3 = class$0 = Class.forName("java.text.AttributedString");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    return t.getTransferData(new DataFlavor(clazz3, "Attributed String"));
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                    return text;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return text;
                }
            }
        }
        if (t == null) return text;
        if (!t.isDataFlavorSupported(DataFlavor.stringFlavor)) return text;
        try {
            return (String)t.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
            return text;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return text;
    }

    public void selectAll() {
        JOptionPane.showMessageDialog(null, "Not Impemented", "This code has not been written yet.", 1);
        System.out.println("Select All Objects");
    }

    public void openAbout() {
        AboutFrame lAboutFrame = new AboutFrame();
        lAboutFrame.validate();
    }

    public void printPreview() {
        JOptionPane.showMessageDialog(null, "Not Impemented", "This code has not been written yet.", 1);
    }

    public void zoom(float pZoom) {
        UserInternalFrame lUIF = this.mUserFrame.getDesktopPane().getInternalFrame();
        lUIF.setScale(pZoom);
        lUIF.getSyntaxFacade().displayTree();
    }

    public void selectNewFrame() {
        this.mUserFrame.getDesktopPane().selecteNewFrame();
    }

    public void copyTree(double width, double height, double left, double top) {
        if (height != 0.0 && width != 0.0) {
            this.mUserFrame.getSyntaxFacade().deselectTree();
            Container lC = this.mUserFrame.getDesktopPane().getInternalFrame().getContentPane();
            Color lColor = lC.getBackground();
            lC.setBackground(new Color(255, 255, 255));
            JPanel lPanel = (JPanel)lC;
            try {
                int scaleWidth = (int)(width * (double)(4.0f / Sizer.scaleWidth()));
                int scaleHeight = (int)(height * (double)(4.0f / Sizer.scaleHeight()));
                BufferedImage lImg = new BufferedImage(scaleWidth, scaleHeight, 1);
                Graphics lGraphics = lImg.getGraphics();
                Graphics2D lG2D = (Graphics2D)lGraphics;
                lG2D.translate(-left * (double)(4.0f / Sizer.scaleWidth()), -top * (double)(4.0f / Sizer.scaleHeight()));
                lG2D.scale(4.0f / Sizer.scaleWidth(), 4.0f / Sizer.scaleHeight());
                lPanel.print(lG2D);
                UserTransferableGraphics t = new UserTransferableGraphics(lImg);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(t, null);
            }
            catch (OutOfMemoryError pOME) {
                JOptionPane.showMessageDialog(null, "You have not allocated enough memory to Java to export this picture", "Run this program using the batch script instead", 0);
            }
            lC.setBackground(lColor);
        }
    }

    public void openWhatNew() {
        WhatNewFrame lWhatNewFrame = new WhatNewFrame();
        lWhatNewFrame.validate();
    }

    protected class PrintJobWatcher {
        private boolean done = false;

        public PrintJobWatcher(DocPrintJob job) {
            job.addPrintJobListener(new PrintJobAdapter(this){
                final /* synthetic */ PrintJobWatcher this$1;
                {
                    this.this$1 = printJobWatcher;
                }

                public void printJobCanceled(PrintJobEvent pje) {
                    this.allDone();
                }

                public void printJobCompleted(PrintJobEvent pje) {
                    this.allDone();
                }

                public void printJobFailed(PrintJobEvent pje) {
                    this.allDone();
                }

                public void printJobNoMoreEvents(PrintJobEvent pje) {
                    this.allDone();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void allDone() {
                    PrintJobWatcher printJobWatcher = this.this$1;
                    synchronized (printJobWatcher) {
                        PrintJobWatcher.access$0(this.this$1, true);
                        this.this$1.notify();
                    }
                }
            });
        }

        public synchronized void waitForDone() {
            try {
                while (!this.done) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        static /* synthetic */ void access$0(PrintJobWatcher printJobWatcher, boolean bl) {
            printJobWatcher.done = bl;
        }
    }
}

