/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import staticFunctions.Sizer;
import userInterface.UserFrame;

public class UserBrowserButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private Object mButtonType;
    private UserFrame mUserFrame;
    protected Graphics mGraphics;
    protected JComponent mComponent;
    protected AbstractButton mButton;
    protected ButtonModel mModel;
    protected Graphics2D mGraphics2D;
    protected Dimension mDim;
    protected Font mFont;
    protected FontRenderContext mFrc;
    private UserBrowserButton mCopy;
    protected boolean mDrag;
    private ResourceBundle mResourceBundle;
    private boolean mHighlight;

    public UserBrowserButton(UserFrame pUserFrame, Object pButtonType) {
        this.setUI(null);
        this.mUserFrame = pUserFrame;
        this.mButtonType = pButtonType;
    }

    public UserBrowserButton getTempLabel() {
        return this.mCopy;
    }

    public void setLabel(UserBrowserButton copy) {
        this.mCopy = copy;
        this.mCopy.setResourceBundle(this.getResourceBundle());
        this.mCopy.setDrag(true);
        this.mCopy.setVisible(false);
        this.mCopy.setBounds(0, 0, Sizer.scaledButtonSize().width, Sizer.scaledButtonSize().height);
        this.mUserFrame.getLayeredPane().add((Component)this.mCopy, JLayeredPane.DRAG_LAYER);
        this.mUserFrame.getLayeredPane().moveToFront(this.mCopy);
    }

    public void setPressedX(int pPressedX) {
    }

    public int getPressedX() {
        return this.getWidth() / 2;
    }

    public void setPressedY(int pPressedY) {
    }

    public int getPressedY() {
        return 0;
    }

    public Object getButtonType() {
        return this.mButtonType;
    }

    protected void prepaint(Graphics pG) {
        this.mGraphics = pG;
        this.mButton = (AbstractButton)this.mComponent;
        this.mGraphics2D = (Graphics2D)this.mGraphics;
        this.mDim = Sizer.buttonSize();
        this.mGraphics2D.scale(Sizer.scaleWidth(), Sizer.scaleHeight());
        this.mFont = new Font("Doulos SIL", 1, Sizer.UIFontSize());
        this.mGraphics2D.setColor(Color.BLACK);
        this.mGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.mGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.mFrc = this.mGraphics2D.getFontRenderContext();
    }

    protected void postpaint() {
        this.mGraphics2D.setColor(Color.GRAY);
        if (!this.mDrag) {
            this.mGraphics2D.drawRect(0, 0, (int)this.mDim.getWidth() - 1, (int)this.mDim.getHeight() - 1);
        }
        if (this.mHighlight) {
            this.mGraphics2D.setColor(new Color(0, 100, 255, 90));
            this.mGraphics2D.fillRect(0, 0, this.mDim.width, this.mDim.height);
        }
    }

    public void setHighlight(boolean highlight) {
        this.mHighlight = highlight;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.mResourceBundle = resourceBundle;
    }

    public ResourceBundle getResourceBundle() {
        return this.mResourceBundle;
    }

    public void setDrag(boolean drag) {
        this.mDrag = drag;
    }
}

