/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import staticFunctions.Sizer;
import syntaxTree.SyntacticStructure;
import userInterface.UserFrame;

public class UserBezierPane
extends JComponent {
    private static final long serialVersionUID = 1L;
    private SyntacticStructure mSS;
    private UserFrame mUserFrame;
    private boolean mControlStart;
    private boolean mControlEnd;

    public UserBezierPane(UserFrame pUserFrame, SyntacticStructure pSS) {
        this.mUserFrame = pUserFrame;
        this.mSS = pSS;
    }

    public void paintComponent(Graphics g) {
        Graphics2D lGraphics2D = (Graphics2D)g;
        lGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        lGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        lGraphics2D.scale(Sizer.scaleWidth() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale(), Sizer.scaleHeight() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale());
        lGraphics2D.translate(this.mUserFrame.getInternalFrame().getProperties().getLeftTranslate(), this.mUserFrame.getInternalFrame().getProperties().getTopTranslate());
        this.drawLines(lGraphics2D, this.mSS);
        this.drawSquare(lGraphics2D, this.mSS.getStartX(), this.mSS.getStartY(), new Color(200, 0, 0));
        this.drawSquare(lGraphics2D, this.mSS.getEndX(), this.mSS.getEndY(), new Color(200, 0, 0));
        this.drawSquare(lGraphics2D, this.mSS.getControlStartX(), this.mSS.getControlStartY(), new Color(0, 0, 200));
        this.drawSquare(lGraphics2D, this.mSS.getControlEndX(), this.mSS.getControlEndY(), new Color(0, 0, 200));
    }

    private void drawLines(Graphics2D graphics2D, SyntacticStructure mss2) {
        graphics2D.setColor(new Color(0, 0, 100));
        graphics2D.drawLine(this.mSS.getStartX(), this.mSS.getStartY(), this.mSS.getControlStartX(), this.mSS.getControlStartY());
        graphics2D.drawLine(this.mSS.getEndX(), this.mSS.getEndY(), this.mSS.getControlEndX(), this.mSS.getControlEndY());
        graphics2D.drawLine(this.mSS.getControlStartX(), this.mSS.getControlStartY(), this.mSS.getControlEndX(), this.mSS.getControlEndY());
    }

    public void setSyntacticStructure(SyntacticStructure pSS) {
        this.mSS = pSS;
    }

    private void drawSquare(Graphics2D lGraphics2D, int pX, int pY, Color lColor) {
        lGraphics2D.setColor(lColor);
        GeneralPath polly = new GeneralPath();
        polly.moveTo(pX - 3, pY - 3);
        polly.lineTo(pX + 3, pY - 3);
        polly.lineTo(pX + 3, pY + 3);
        polly.lineTo(pX - 3, pY + 3);
        polly.closePath();
        lGraphics2D.fill(polly);
    }

    public void setPosition(MouseEvent e) {
        float scaleX = (float)e.getX() / (Sizer.scaleWidth() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale());
        float scaleY = (float)e.getY() / (Sizer.scaleHeight() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale());
        if (this.mControlStart) {
            this.mSS.setCustomTrace(true);
            this.mSS.setControlStartX((int)scaleX - this.mUserFrame.getInternalFrame().getProperties().getLeftTranslate());
            this.mSS.setControlStartY((int)scaleY - this.mUserFrame.getInternalFrame().getProperties().getTopTranslate());
            this.mUserFrame.getDesktopPane().getInternalFrame().getTrace().repaint();
        }
        if (this.mControlEnd) {
            this.mSS.setCustomTrace(true);
            this.mSS.setControlEndX((int)scaleX - this.mUserFrame.getInternalFrame().getProperties().getLeftTranslate());
            this.mSS.setControlEndY((int)scaleY - this.mUserFrame.getInternalFrame().getProperties().getTopTranslate());
            this.mUserFrame.getDesktopPane().getInternalFrame().getTrace().repaint();
        }
    }

    public void setTarget(MouseEvent e) {
        float scaleX = (float)e.getX() / (Sizer.scaleWidth() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale());
        float scaleY = (float)e.getY() / (Sizer.scaleHeight() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale());
        if (scaleX > (float)(this.mSS.getControlStartX() + this.mUserFrame.getInternalFrame().getProperties().getLeftTranslate() - 10) && scaleX < (float)(this.mSS.getControlStartX() + this.mUserFrame.getInternalFrame().getProperties().getLeftTranslate() + 10) && scaleY > (float)(this.mSS.getControlStartY() + this.mUserFrame.getInternalFrame().getProperties().getTopTranslate() - 10) && scaleY < (float)(this.mSS.getControlStartY() + this.mUserFrame.getInternalFrame().getProperties().getTopTranslate() + 10)) {
            this.mControlStart = true;
            this.mControlEnd = false;
        } else if (scaleX > (float)(this.mSS.getControlEndX() + this.mUserFrame.getInternalFrame().getProperties().getLeftTranslate() - 10) && scaleX < (float)(this.mSS.getControlEndX() + this.mUserFrame.getInternalFrame().getProperties().getLeftTranslate() + 10) && scaleY > (float)(this.mSS.getControlEndY() + this.mUserFrame.getInternalFrame().getProperties().getTopTranslate() - 10) && scaleY < (float)(this.mSS.getControlEndY() + this.mUserFrame.getInternalFrame().getProperties().getTopTranslate() + 10)) {
            this.mControlStart = false;
            this.mControlEnd = true;
        } else {
            this.mControlStart = false;
            this.mControlEnd = false;
        }
    }

    public void exit() {
        this.mUserFrame.getDesktopPane().getInternalFrame().deactivateBezierPane();
    }
}

