/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import staticFunctions.Sizer;
import syntaxTree.SyntacticFeature;
import syntaxTree.SyntacticStructure;
import userInterface.UserFrame;

public class UserAssociationPane
extends JComponent {
    private UserFrame mUserFrame;
    private SyntacticStructure mSS;
    private int mX;
    private int mY;
    private SyntacticFeature mSA;
    private static final long serialVersionUID = 1L;

    public UserAssociationPane(UserFrame userFrame, SyntacticFeature feature) {
        this.mUserFrame = userFrame;
        this.mSA = feature;
        this.mSS = feature.getSyntacticFeatureSet().getSyntacticStructure();
        this.mX = (int)(this.mSS.getButtonX() + (double)(this.mSS.getButtonWidth() / 2) - 5.0);
        this.mY = (int)(this.mSS.getButtonY() + (double)this.mSS.getButtonHeight() - (double)this.mUserFrame.getInternalFrame().getProperties().getMinLineLength());
    }

    public void setPosition(MouseEvent pme) {
        this.mX = (int)((float)pme.getX() / (Sizer.scaleWidth() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale()));
        this.mY = (int)((float)pme.getY() / (Sizer.scaleHeight() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale()));
        this.repaint();
    }

    public void setEnd(SyntacticStructure structure) {
        this.mUserFrame.getSyntaxFacade().associateSyntacticFeature(structure, this.mSA);
    }

    public void paintComponent(Graphics g) {
        Graphics2D lGraphics2D = (Graphics2D)g;
        lGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        lGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        lGraphics2D.scale(Sizer.scaleWidth() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale(), Sizer.scaleHeight() * this.mUserFrame.getDesktopPane().getInternalFrame().getScale());
        lGraphics2D.setColor(new Color(0, 0, 200));
        Rectangle2D.Double ellipse = new Rectangle2D.Double(this.mX, this.mY, 10.0, 10.0);
        lGraphics2D.fill(ellipse);
        int x = (int)(this.mSS.getButtonX() + (double)(this.mSS.getButtonWidth() / 2) - 5.0);
        int y = (int)(this.mSS.getButtonY() + (double)this.mSS.getButtonHeight() - (double)this.mUserFrame.getInternalFrame().getProperties().getMinLineLength());
        ellipse = new Rectangle2D.Double(x, y, 10.0, 10.0);
        lGraphics2D.fill(ellipse);
        lGraphics2D.setColor(Color.BLACK);
        float[] dash = new float[]{2.0f, 2.0f};
        lGraphics2D.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, dash, 0.0f));
        lGraphics2D.drawLine(this.mX + 5, this.mY + 5, x + 5, y + 5);
    }
}

