/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;
import staticFunctions.Sizer;

public class PrintUtilities
implements Printable {
    private Component mCTBPrinted;

    public static void printComponent(Component pC) {
        new PrintUtilities(pC).print();
    }

    public PrintUtilities(Component pCTBPrinted) {
        this.mCTBPrinted = pCTBPrinted;
    }

    public void print() {
        PrinterJob lPrintJob = PrinterJob.getPrinterJob();
        lPrintJob.setPrintable(this);
        if (lPrintJob.printDialog()) {
            try {
                lPrintJob.print();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    public int print(Graphics pG, PageFormat pPF, int pPI) {
        if (pPI > 0) {
            return 1;
        }
        Graphics2D lG2d = (Graphics2D)pG;
        lG2d.scale(1.0f / Sizer.scaleWidth(), 1.0f / Sizer.scaleHeight());
        lG2d.translate(pPF.getImageableX() * (double)Sizer.scaleWidth(), pPF.getImageableY() * (double)Sizer.scaleHeight());
        PrintUtilities.disableDoubleBuffering(this.mCTBPrinted);
        this.mCTBPrinted.paint(lG2d);
        PrintUtilities.enableDoubleBuffering(this.mCTBPrinted);
        return 0;
    }

    public static void disableDoubleBuffering(Component pC) {
        RepaintManager currentManager = RepaintManager.currentManager(pC);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component pC) {
        RepaintManager currentManager = RepaintManager.currentManager(pC);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

