/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import userInterface.UserDesktopPane;

public class MDIDesktopManager
extends DefaultDesktopManager {
    private static final long serialVersionUID = 1L;
    private UserDesktopPane pDesktop;

    public MDIDesktopManager(UserDesktopPane pDesktop) {
        this.pDesktop = pDesktop;
    }

    public void endResizingFrame(JComponent pF) {
        super.endResizingFrame(pF);
        this.resizeDesktop();
    }

    public void endDraggingFrame(JComponent pF) {
        super.endDraggingFrame(pF);
        this.resizeDesktop();
    }

    public void setNormalSize() {
        JScrollPane scrollPane = this.getScrollPane();
        int x = 0;
        int y = 0;
        Insets scrollInsets = this.getScrollPaneInsets();
        if (scrollPane != null) {
            Dimension d = scrollPane.getVisibleRect().getSize();
            if (scrollPane.getBorder() != null) {
                d.setSize(d.getWidth() - (double)scrollInsets.left - (double)scrollInsets.right, d.getHeight() - (double)scrollInsets.top - (double)scrollInsets.bottom);
            }
            d.setSize(d.getWidth() - 20.0, d.getHeight() - 20.0);
            this.pDesktop.setAllSize(x, y);
            scrollPane.invalidate();
            scrollPane.validate();
        }
    }

    private Insets getScrollPaneInsets() {
        JScrollPane scrollPane = this.getScrollPane();
        if (scrollPane == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.getScrollPane().getBorder().getBorderInsets(scrollPane);
    }

    private JScrollPane getScrollPane() {
        JViewport viewPort;
        if (this.pDesktop.getParent() instanceof JViewport && (viewPort = (JViewport)this.pDesktop.getParent()).getParent() instanceof JScrollPane) {
            return (JScrollPane)viewPort.getParent();
        }
        return null;
    }

    protected void resizeDesktop() {
        int x = 0;
        int y = 0;
        JScrollPane pScrollPane = this.getScrollPane();
        Insets pScrollInsets = this.getScrollPaneInsets();
        if (pScrollPane != null) {
            JInternalFrame[] allFrames = this.pDesktop.getAllFrames();
            int i = 0;
            while (i < allFrames.length) {
                if (allFrames[i].getX() + allFrames[i].getWidth() > x) {
                    x = allFrames[i].getX() + allFrames[i].getWidth();
                }
                if (allFrames[i].getY() + allFrames[i].getHeight() > y) {
                    y = allFrames[i].getY() + allFrames[i].getHeight();
                }
                ++i;
            }
            Dimension pD = pScrollPane.getVisibleRect().getSize();
            if (pScrollPane.getBorder() != null) {
                pD.setSize(pD.getWidth() - (double)pScrollInsets.left - (double)pScrollInsets.right, pD.getHeight() - (double)pScrollInsets.top - (double)pScrollInsets.bottom);
            }
            if ((double)x <= pD.getWidth()) {
                x = (int)pD.getWidth() - 20;
            }
            if ((double)y <= pD.getHeight()) {
                y = (int)pD.getHeight() - 20;
            }
            this.pDesktop.setAllSize(x, y);
            pScrollPane.invalidate();
            pScrollPane.validate();
        }
    }
}

