/*
 * Decompiled with CFR 0.152.
 */
package userInterface;

import enumerators.SyntacticFeatureType;
import enumerators.SyntacticOperationType;
import enumerators.SyntacticStructureType;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import syntaxTree.EditableComponent;
import syntaxTree.SyntacticAssociation;
import syntaxTree.SyntacticFeature;
import syntaxTree.SyntacticStructure;
import userInterface.UserBrowserButton;
import userInterface.UserFrame;
import userInterface.UserInternalFrame;

public class ListenerMouse
implements MouseListener {
    private UserFrame mUserFrame;

    public ListenerMouse(UserFrame pUserFrame) {
        this.mUserFrame = pUserFrame;
    }

    public void mouseClicked(MouseEvent pME) {
    }

    public void mouseEntered(MouseEvent pME) {
        UserBrowserButton lUBB = (UserBrowserButton)pME.getSource();
        lUBB.setHighlight(true);
        lUBB.repaint();
    }

    public void mouseExited(MouseEvent pME) {
        UserBrowserButton lUBB = (UserBrowserButton)pME.getSource();
        lUBB.setHighlight(false);
        lUBB.repaint();
    }

    public void mousePressed(MouseEvent pME) {
        this.mUserFrame.getInternalFrame().setToolTipText(null);
        Cursor lDefaultCursor = new Cursor(12);
        this.mUserFrame.setCursor(lDefaultCursor);
    }

    public void mouseReleased(MouseEvent pME) {
        Cursor lDefaultCursor = new Cursor(0);
        this.mUserFrame.setCursor(lDefaultCursor);
        UserBrowserButton lUBB = (UserBrowserButton)pME.getSource();
        lUBB.getTempLabel().setVisible(false);
        Container container = this.mUserFrame.getContentPane();
        Point containerPoint = SwingUtilities.convertPoint((Component)pME.getSource(), pME.getPoint(), container);
        Component lComponent = this.mUserFrame.getDesktopPane().getComponentAt(containerPoint.x, containerPoint.y);
        containerPoint = new Point(containerPoint.x - lUBB.getPressedX(), containerPoint.y - lUBB.getPressedY());
        if (lComponent instanceof UserInternalFrame) {
            Component hold = ((UserInternalFrame)lComponent).getSyntaxFacade().getContainer();
            if (hold != null) {
                ((EditableComponent)hold).setOver(false);
                hold.repaint();
            }
            containerPoint = SwingUtilities.convertPoint((Component)pME.getSource(), pME.getPoint(), ((UserInternalFrame)lComponent).getContentPane());
            if (lUBB.getButtonType() instanceof SyntacticStructureType) {
                try {
                    ((UserInternalFrame)lComponent).getSyntaxFacade().addSyntacticStructure((SyntacticStructureType)lUBB.getButtonType(), (UserInternalFrame)lComponent, ((UserInternalFrame)lComponent).getSyntaxFacade().getContainer());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (lUBB.getButtonType() instanceof SyntacticFeatureType) {
                try {
                    ((UserInternalFrame)lComponent).getSyntaxFacade().addSyntacticFeatureToStructure((SyntacticFeatureType)lUBB.getButtonType(), (UserInternalFrame)lComponent, ((UserInternalFrame)lComponent).getSyntaxFacade().getContainer());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (lUBB.getButtonType() instanceof SyntacticOperationType) {
                if (lUBB.getButtonType() == SyntacticOperationType.MOVEMENT) {
                    this.mUserFrame.getInternalFrame().activateMovementPane(((UserInternalFrame)lComponent).getSyntaxFacade().getContainer(), pME);
                }
                if (lUBB.getButtonType() == SyntacticOperationType.ERASE) {
                    hold = ((UserInternalFrame)lComponent).getSyntaxFacade().getContainer();
                    if (hold instanceof SyntacticStructure) {
                        this.mUserFrame.getSyntaxFacade().deleteSyntacticStructure((SyntacticStructure)hold);
                    }
                    if (hold instanceof SyntacticFeature) {
                        this.mUserFrame.getSyntaxFacade().deleteSyntacticFeature((SyntacticFeature)hold);
                    }
                    if (hold instanceof SyntacticAssociation) {
                        this.mUserFrame.getSyntaxFacade().deleteSyntacticAssociation((SyntacticAssociation)hold);
                    }
                }
                if (lUBB.getButtonType() == SyntacticOperationType.ADD && (hold = ((UserInternalFrame)lComponent).getSyntaxFacade().getContainer()) instanceof SyntacticFeature) {
                    this.mUserFrame.getSyntaxFacade().addSyntacticFeature((SyntacticFeature)hold);
                }
                if (lUBB.getButtonType() == SyntacticOperationType.ASSOCIATION && (hold = ((UserInternalFrame)lComponent).getSyntaxFacade().getContainer()) instanceof SyntacticFeature) {
                    this.mUserFrame.getInternalFrame().activateAssociationPane((SyntacticFeature)hold);
                }
            }
        }
    }
}

