/*
 * Decompiled with CFR 0.152.
 */
package syntaxTree;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.CubicCurve2D;
import java.util.LinkedList;
import javax.swing.JComponent;
import staticFunctions.Sizer;
import syntaxTree.SyntacticStructure;
import syntaxTree.SyntaxFacade;
import userInterface.UserInternalFrame;

public class TraceComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    static final int padWidth = 7;
    private static final int circle = 4;
    static final int lineLength = 4;
    static final int padEdge = 6;
    static final int padLength = 6;
    private static final float triangleLength = 3.0f;
    private UserInternalFrame mUserInternalFrame;
    private SyntaxFacade mSyntaxFacade;
    private boolean mDrawTrace;
    private int mStartX;
    private int mStartY;
    private int mEndY;
    private int mEndX;
    private int midStartY;
    private int midEndY;
    private int midStartX;
    private int midEndX;
    private int mLeft;
    private int mRight;
    private int mTop;
    private int mBottom;
    private double mLeftHeightBottom;
    private double mRightHeightBottom;
    private double mLeftHeightTop;
    private double mRightHeightTop;
    private static final int POSITION_BOTTOM = 0;
    private static final int POSITION_LEFT = 1;
    private static final int POSITION_RIGHT = 2;

    public TraceComponent(UserInternalFrame pUserInternalFrame) {
        this.mUserInternalFrame = pUserInternalFrame;
        this.mSyntaxFacade = this.mUserInternalFrame.getSyntaxFacade();
        this.mDrawTrace = true;
    }

    public void paint(Graphics G) {
        this.setBounds(this.getUserInternalFrame().getContentPane().getBounds());
        super.paint(G);
        if (this.mDrawTrace) {
            this.displayMovement(G);
        }
    }

    private void displayMovement(Graphics G) {
        if (this.getSyntaxFacade().getSentence().getChildren().size() > 0) {
            SyntacticStructure mR = (SyntacticStructure)this.getSyntaxFacade().getSentence().getChildren().get(0);
            Graphics2D lGraphics2D = (Graphics2D)G;
            lGraphics2D.scale(Sizer.scaleWidth() * this.getUserInternalFrame().getScale(), Sizer.scaleHeight() * this.getUserInternalFrame().getScale());
            lGraphics2D.setColor(Color.BLACK);
            lGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            lGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            lGraphics2D.setStroke(new BasicStroke(0.5f));
            this.resetCounters(mR);
            this.displayMovementRecursive(mR, lGraphics2D);
        }
    }

    private void resetCounters(SyntacticStructure start) {
        start.setTraceCount(0);
        int i = 0;
        while (i < start.getChildren().size()) {
            SyntacticStructure w = (SyntacticStructure)start.getChildren().get(i);
            this.resetCounters(w);
            ++i;
        }
    }

    private void displayMovementRecursive(SyntacticStructure start, Graphics2D contentGraphics) {
        int i = 0;
        while (i < start.getStartTrace().size()) {
            SyntacticStructure end = (SyntacticStructure)start.getStartTrace().get(i);
            this.drawMovement(start, end, contentGraphics);
            ++i;
        }
        i = 0;
        while (i < start.getChildren().size()) {
            SyntacticStructure w = (SyntacticStructure)start.getChildren().get(i);
            this.displayMovementRecursive(w, contentGraphics);
            ++i;
        }
    }

    private void drawMovement(SyntacticStructure start, SyntacticStructure end, Graphics2D contentGraphics) {
        this.calculateMovement(start, end, contentGraphics);
        this.drawCubicCurve(start, end, contentGraphics);
    }

    private void drawCubicCurve(SyntacticStructure start, SyntacticStructure end, Graphics2D contentGraphics) {
        this.mStartX -= this.mUserInternalFrame.getProperties().getLeftTranslate();
        this.mEndX -= this.mUserInternalFrame.getProperties().getLeftTranslate();
        this.mStartY -= this.mUserInternalFrame.getProperties().getTopTranslate();
        this.mEndY -= this.mUserInternalFrame.getProperties().getTopTranslate();
        this.midStartX -= this.mUserInternalFrame.getProperties().getLeftTranslate();
        this.midEndX -= this.mUserInternalFrame.getProperties().getLeftTranslate();
        this.midStartY -= this.mUserInternalFrame.getProperties().getTopTranslate();
        this.midEndY -= this.mUserInternalFrame.getProperties().getTopTranslate();
        if (start.getCustomTrace() && start.getStartX() == this.mStartX && start.getEndX() == this.mEndX && start.getStartY() == this.mStartY && start.getEndY() == this.mEndY) {
            this.midStartX = start.getControlStartX();
            this.midEndX = start.getControlEndX();
            this.midStartY = start.getControlStartY();
            this.midEndY = start.getControlEndY();
        } else {
            start.setControlStartX(this.midStartX);
            start.setControlEndX(this.midEndX);
            start.setControlStartY(this.midStartY);
            start.setControlEndY(this.midEndY);
            start.setCustomTrace(false);
        }
        start.setStartX(this.mStartX);
        start.setEndX(this.mEndX);
        start.setStartY(this.mStartY);
        start.setEndY(this.mEndY);
        this.mStartX += this.mUserInternalFrame.getProperties().getLeftTranslate();
        this.mEndX += this.mUserInternalFrame.getProperties().getLeftTranslate();
        this.mStartY += this.mUserInternalFrame.getProperties().getTopTranslate();
        this.mEndY += this.mUserInternalFrame.getProperties().getTopTranslate();
        this.midStartX += this.mUserInternalFrame.getProperties().getLeftTranslate();
        this.midEndX += this.mUserInternalFrame.getProperties().getLeftTranslate();
        this.midStartY += this.mUserInternalFrame.getProperties().getTopTranslate();
        this.midEndY += this.mUserInternalFrame.getProperties().getTopTranslate();
        CubicCurve2D.Float bezier = new CubicCurve2D.Float(this.mStartX, this.mStartY, this.midStartX, this.midStartY, this.midEndX, this.midEndY, this.mEndX, this.mEndY);
        contentGraphics.draw(bezier);
        this.drawArrow(contentGraphics);
    }

    private void drawArrow(Graphics2D contentGraphics) {
        double xFrom = this.midEndX;
        double xTo = this.mEndX;
        double yFrom = this.midEndY;
        double yTo = this.mEndY;
        double dx = xTo - xFrom;
        double dy = yTo - yFrom;
        double denom = Math.sqrt(dx * dx + dy * dy);
        double cos = 3.0 / denom;
        double sin = 3.0 / denom;
        double x = xTo - cos * dx;
        double y = yTo - cos * dy;
        int x1 = (int)(x - sin * dy);
        int y1 = (int)(y + sin * dx);
        int x2 = (int)(x + sin * dy);
        int y2 = (int)(y - sin * dx);
        Polygon triangle = new Polygon();
        triangle.addPoint((int)xTo, (int)yTo);
        triangle.addPoint(x1, y1);
        triangle.addPoint(x2, y2);
        contentGraphics.fillPolygon(triangle);
        contentGraphics.drawPolygon(triangle);
    }

    private boolean calculateMovement(SyntacticStructure start, SyntacticStructure end, Graphics2D contentGraphics) {
        LinkedList tempList;
        SyntacticStructure tempTop = null;
        SyntacticStructure tempBottom = null;
        if (start.getChildren().size() == 0 && end.getChildren().size() == 0) {
            this.drawStart(start, contentGraphics, 0);
            this.drawEnd(end, contentGraphics, 0);
            this.midStartX = this.mStartX;
            this.midEndX = this.mEndX;
            if (this.mEndY > this.mStartY) {
                this.midStartY = this.mEndY + 20;
                this.midEndY = this.mEndY + 20;
            } else {
                this.midStartY = this.mStartY + 20;
                this.midEndY = this.mStartY + 20;
            }
            return true;
        }
        if (start.getAbsoluteOrder() == 0 || end.getAbsoluteOrder() == 0) {
            this.drawStart(start, contentGraphics, 1);
            if (end.getChildren().size() == 0) {
                this.drawEnd(end, contentGraphics, 0);
            } else {
                this.drawEnd(end, contentGraphics, 1);
            }
            this.midStartX = this.mStartX;
            this.midEndX = this.mEndX;
            if (this.mEndY > this.mStartY) {
                this.midStartY = this.mEndY - 20;
                this.midEndY = this.mEndY - 20;
            } else {
                this.midStartY = this.mStartY - 20;
                this.midEndY = this.mStartY - 20;
            }
            return true;
        }
        if (start.getAbsoluteOrder() == ((LinkedList)this.mSyntaxFacade.getLinkedArray().get(start.getLevel())).size() - 1 || end.getAbsoluteOrder() == ((LinkedList)this.mSyntaxFacade.getLinkedArray().get(end.getLevel())).size() - 1) {
            this.drawStart(start, contentGraphics, 2);
            if (end.getChildren().size() == 0) {
                this.drawEnd(end, contentGraphics, 0);
            } else {
                this.drawEnd(end, contentGraphics, 2);
            }
            this.midStartX = this.mStartX;
            this.midEndX = this.mEndX;
            if (this.mEndY < this.mStartY) {
                this.midStartY = this.mEndY - 20;
                this.midEndY = this.mEndY - 20;
            } else {
                this.midStartY = this.mStartY - 20;
                this.midEndY = this.mStartY - 20;
            }
            return true;
        }
        if (start.getAbsoluteOrder() == 0 && end.getAbsoluteOrder() == ((LinkedList)this.mSyntaxFacade.getLinkedArray().get(end.getLevel())).size() - 1) {
            this.drawStart(start, contentGraphics, 1);
            if (end.getChildren().size() == 0) {
                this.drawEnd(end, contentGraphics, 0);
            } else {
                this.drawEnd(end, contentGraphics, 2);
            }
            this.midStartY = this.mUserInternalFrame.getProperties().getTopTranslate() - 30;
            this.midStartX = this.mStartX - 20;
            this.midEndX = this.mEndX + 20;
            this.midEndY = this.mUserInternalFrame.getProperties().getTopTranslate() - 30;
            return true;
        }
        if (end.getAbsoluteOrder() == 0 && start.getAbsoluteOrder() == ((LinkedList)this.mSyntaxFacade.getLinkedArray().get(start.getLevel())).size() - 1) {
            this.drawStart(start, contentGraphics, 2);
            if (end.getChildren().size() == 0) {
                this.drawEnd(end, contentGraphics, 0);
            } else {
                this.drawEnd(end, contentGraphics, 1);
            }
            this.midStartY = this.mUserInternalFrame.getProperties().getTopTranslate() - 30;
            this.midStartX = this.mStartX + 20;
            this.midEndX = this.mEndX - 20;
            this.midEndY = this.mUserInternalFrame.getProperties().getTopTranslate() - 30;
            return true;
        }
        if (start.getLevel() > end.getLevel()) {
            tempTop = end;
            tempBottom = start;
        } else {
            tempTop = start;
            tempBottom = end;
        }
        tempTop = this.mSyntaxFacade.getLower(tempTop, tempTop.getNumber(), tempTop.getLevel(), tempBottom.getLevel(), true);
        if (tempTop != null) {
            if (tempTop.equals(tempBottom)) {
                this.drawStart(start, contentGraphics, 1);
                this.drawEnd(end, contentGraphics, 1);
                this.midStartX = this.mStartX;
                this.midEndX = this.mEndX;
                if (this.mEndY < this.mStartY) {
                    this.midStartY = this.mEndY;
                    this.midEndY = this.mEndY;
                } else {
                    this.midStartY = this.mStartY;
                    this.midEndY = this.mStartY;
                }
                return true;
            }
            tempList = (LinkedList)this.mSyntaxFacade.getLinkedArray().get(tempTop.getLevel());
            if (tempTop.getAbsoluteOrder() != 0 && tempList.get(tempTop.getAbsoluteOrder() - 1).equals(tempBottom)) {
                if (tempBottom == start) {
                    tempTop = end;
                    this.drawStart(tempBottom, contentGraphics, 2);
                    this.drawEnd(tempTop, contentGraphics, 1);
                } else {
                    tempTop = start;
                    this.drawStart(tempTop, contentGraphics, 1);
                    this.drawEnd(tempBottom, contentGraphics, 2);
                }
                double difference = this.mStartX - this.mEndX;
                this.midStartX = (int)((double)this.mStartX - 0.3 * difference);
                this.midEndX = (int)((double)this.mEndX + 0.3 * difference);
                this.midStartY = this.mStartY;
                this.midEndY = this.mEndY;
                return true;
            }
        }
        if (start.getLevel() > end.getLevel()) {
            tempTop = end;
            tempBottom = start;
        } else {
            tempTop = start;
            tempBottom = end;
        }
        tempTop = this.mSyntaxFacade.getLower(tempTop, tempTop.getNumber(), tempTop.getLevel(), tempBottom.getLevel(), false);
        if (tempTop != null) {
            if (tempTop.equals(tempBottom)) {
                this.drawStart(start, contentGraphics, 2);
                this.drawEnd(end, contentGraphics, 2);
                this.midStartX = this.mStartX;
                this.midEndX = this.mEndX;
                if (this.mEndY < this.mStartY) {
                    this.midStartY = this.mEndY;
                    this.midEndY = this.mEndY;
                } else {
                    this.midStartY = this.mStartY;
                    this.midEndY = this.mStartY;
                }
                return true;
            }
            tempList = (LinkedList)this.mSyntaxFacade.getLinkedArray().get(tempTop.getLevel());
            if (tempTop.getAbsoluteOrder() + 1 != tempList.size() && tempList.get(tempTop.getAbsoluteOrder() + 1).equals(tempBottom)) {
                if (tempBottom == start) {
                    tempTop = end;
                    this.drawStart(tempBottom, contentGraphics, 1);
                    this.drawEnd(tempTop, contentGraphics, 2);
                } else {
                    tempTop = start;
                    this.drawStart(tempTop, contentGraphics, 2);
                    this.drawEnd(tempBottom, contentGraphics, 1);
                }
                double difference = this.mStartX - this.mEndX;
                this.midStartX = (int)((double)this.mStartX - 0.3 * difference);
                this.midEndX = (int)((double)this.mEndX + 0.3 * difference);
                this.midStartY = this.mStartY;
                this.midEndY = this.mEndY;
                return true;
            }
        }
        if (start.getButtonX() > end.getButtonX()) {
            this.drawStart(start, contentGraphics, 1);
            this.drawEnd(end, contentGraphics, 2);
        } else {
            this.drawStart(start, contentGraphics, 2);
            this.drawEnd(end, contentGraphics, 1);
        }
        this.midStartX = this.mStartX;
        this.midEndX = this.mEndX;
        this.midEndY = this.midStartY = (int)this.getSyntaxFacade().getBottomShift();
        return true;
    }

    private void drawStart(SyntacticStructure start, Graphics2D contentGraphics, int position) {
        if (position == 0) {
            float padBottom = 0.0f;
            padBottom = -(start.getTraceNumber() * 7) / 2 + start.getTraceCount() * 7;
            contentGraphics.fillArc((int)(start.getButtonX() + (double)(start.getButtonWidth() / 2) + (double)padBottom - 2.0), (int)(start.getButtonY() + (double)start.getButtonHeight() - (double)this.mUserInternalFrame.getProperties().getMinLineLength()) + 2, 4, 4, 0, 360);
            this.mStartX = (int)(start.getButtonX() + (double)(start.getButtonWidth() / 2) + (double)padBottom);
            this.mStartY = (int)(start.getButtonY() + (double)start.getButtonHeight() - (double)this.mUserInternalFrame.getProperties().getMinLineLength() + 4.0);
        } else if (position == 1) {
            contentGraphics.fillArc((int)start.getButtonX() - 6 - 2, (int)start.getButtonY() + start.getTextHeight() / 2 - 3 - 2 + start.getTraceCount() * 6, 4, 4, 0, 360);
            this.mStartX = (int)start.getButtonX() - 6;
            this.mStartY = (int)start.getButtonY() + start.getTextHeight() / 2 - 3 + start.getTraceCount() * 6;
        } else {
            contentGraphics.fillArc((int)start.getButtonX() + 6 + start.getButtonWidth() - 2, (int)start.getButtonY() + start.getTextHeight() / 2 - 2 - 3 + start.getTraceCount() * 6, 4, 4, 0, 360);
            this.mStartX = (int)start.getButtonX() + 6 + start.getButtonWidth();
            this.mStartY = (int)(start.getButtonY() + (double)(start.getTextHeight() / 2) - 3.0 + (double)(start.getTraceCount() * 6));
        }
        start.setTraceCount(start.getTraceCount() + 1);
    }

    private void setSubtreeBounds(SyntacticStructure start) {
        if (this.mLeft > (int)start.getButtonX()) {
            this.mLeft = (int)start.getButtonX();
            this.mLeftHeightTop = start.getButtonY();
            this.mLeftHeightBottom = start.getButtonY() + (double)start.getButtonHeight() - (double)(this.mUserInternalFrame.getProperties().getMinLineLength() / 2);
        }
        if (this.mRight < (int)(start.getButtonX() + (double)start.getButtonWidth())) {
            this.mRight = (int)(start.getButtonX() + (double)start.getButtonWidth());
            this.mRightHeightTop = start.getButtonY();
            this.mRightHeightBottom = start.getButtonY() + (double)start.getButtonHeight() - (double)(this.mUserInternalFrame.getProperties().getMinLineLength() / 2);
        }
        if (this.mBottom < (int)(start.getButtonY() + (double)start.getButtonHeight() - (double)(this.mUserInternalFrame.getProperties().getMinLineLength() / 2))) {
            this.mBottom = (int)(start.getButtonY() + (double)start.getButtonHeight() - (double)(this.mUserInternalFrame.getProperties().getMinLineLength() / 2));
        }
        int i = 0;
        while (i < start.getChildren().size()) {
            this.setSubtreeBounds((SyntacticStructure)start.getChildren().get(i));
            ++i;
        }
    }

    private void drawEnd(SyntacticStructure end, Graphics2D contentGraphics, int position) {
        if (position == 0) {
            float padBottom = 0.0f;
            padBottom = -(end.getTraceNumber() * 7) / 2 + end.getTraceCount() * 7;
            this.mEndX = (int)(end.getButtonX() + (double)(end.getButtonWidth() / 2) + (double)padBottom);
            this.mEndY = (int)(end.getButtonY() + (double)end.getButtonHeight() - (double)this.mUserInternalFrame.getProperties().getMinLineLength());
        } else if (position == 1) {
            this.mEndX = (int)end.getButtonX() - 6;
            this.mEndY = (int)end.getButtonY() + end.getTextHeight() / 2 - 3 + end.getTraceCount() * 6;
        } else {
            this.mEndX = (int)end.getButtonX() + 6 + end.getButtonWidth();
            this.mEndY = (int)end.getButtonY() + end.getTextHeight() / 2 - 3 + end.getTraceCount() * 6;
        }
        end.setTraceCount(end.getTraceCount() + 1);
    }

    private SyntaxFacade getSyntaxFacade() {
        return this.mSyntaxFacade;
    }

    private UserInternalFrame getUserInternalFrame() {
        return this.mUserInternalFrame;
    }

    public void setDrawTrace(boolean drawTrace) {
        this.mDrawTrace = drawTrace;
    }

    public boolean getDrawTrace() {
        return this.mDrawTrace;
    }
}

