/*
 * Decompiled with CFR 0.152.
 */
package syntaxTree;

import enumerators.SyntacticFeatureType;
import enumerators.SyntacticLevel;
import enumerators.SyntacticStructureType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.LinkedList;
import javax.swing.JPopupMenu;
import org.w3c.dom.Document;
import parser.XMLParser;
import staticFunctions.Sizer;
import syntaxTree.AbstractFeatureBuilder;
import syntaxTree.AbstractStructureBuilder;
import syntaxTree.AdjunctBuilder;
import syntaxTree.BinaryBuilder;
import syntaxTree.CaseBuilder;
import syntaxTree.EditableComponent;
import syntaxTree.FeatureBuilder;
import syntaxTree.FeatureDirector;
import syntaxTree.HeadBuilder;
import syntaxTree.MorphBuilder;
import syntaxTree.PhraseBuilder;
import syntaxTree.RepositionTree;
import syntaxTree.SAPopupMenu;
import syntaxTree.SFPopupMenu;
import syntaxTree.SSPopupMenu;
import syntaxTree.Sentence;
import syntaxTree.StructureDirector;
import syntaxTree.SyntacticAssociation;
import syntaxTree.SyntacticFeature;
import syntaxTree.SyntacticFeatureSet;
import syntaxTree.SyntacticStructure;
import syntaxTree.TernaryBuilder;
import syntaxTree.ThetaBuilder;
import syntaxTree.TriangleBuilder;
import syntaxTree.TypeNotFoundError;
import syntaxTree.UnaryBuilder;
import syntaxTree.XBarBuilder;
import userInterface.UserInternalFrame;

public class SyntaxFacade {
    private String mPicture;
    private String mFile;
    private Component mUnder;
    private Component mOldContainer;
    private Component mContainer;
    private UserInternalFrame mUIF;
    private Sentence mSentence;
    private SyntacticStructure mDefaultAncestor;
    private double mLeftShift;
    private double mShift;
    private double mChange;
    private int subtrees;
    private LinkedList mHeight;
    private LinkedList mLinkedArray;
    private LinkedList mDocs;
    private int mDocPosition = 0;
    private int mDocMaxPosition = 0;
    private static final int mDocMax = 100;
    private double mRightShift;
    private double mBottomShift;
    private int mPreorder;
    private XMLParser mParser;
    private int mDocMinPosition = 0;
    private LinkedList mHeightPad;
    private double mDistance;
    private Component mClosest;
    private LinkedList mSelected;
    private int mPadBottom = 100;
    private int mPadRight = 25;

    public SyntaxFacade(UserInternalFrame pUIF) {
        this.setSentence(new Sentence());
        this.setParser(new XMLParser());
        this.setUIF(pUIF);
        this.setFile("");
        this.mDocs = new LinkedList();
    }

    private void setParser(XMLParser parser) {
        this.mParser = parser;
    }

    private XMLParser getParser() {
        return this.mParser;
    }

    public void addSyntacticStructure(SyntacticStructureType pSST, UserInternalFrame pUIF, Object pSS) throws Exception {
        this.addUndo();
        AbstractStructureBuilder lAB = null;
        if (pSST == SyntacticStructureType.ADJUNCT) {
            lAB = new AdjunctBuilder();
        } else if (pSST == SyntacticStructureType.BINARY) {
            lAB = new BinaryBuilder();
        } else if (pSST == SyntacticStructureType.HEAD) {
            lAB = new HeadBuilder();
        } else if (pSST == SyntacticStructureType.TRIANGLE) {
            lAB = new TriangleBuilder();
        } else if (pSST == SyntacticStructureType.TRINARY) {
            lAB = new TernaryBuilder();
        } else if (pSST == SyntacticStructureType.UNARY) {
            lAB = new UnaryBuilder();
        } else if (pSST == SyntacticStructureType.X_BAR) {
            lAB = new XBarBuilder();
        } else if (pSST == SyntacticStructureType.MORPH) {
            lAB = new MorphBuilder();
        } else if (pSST == SyntacticStructureType.PHRASE) {
            lAB = new PhraseBuilder();
        } else {
            TypeNotFoundError typeNotFoundError = new TypeNotFoundError();
            throw typeNotFoundError;
        }
        SyntacticStructure lSyntacticStructure = StructureDirector.build(lAB, pUIF);
        if (pSS instanceof SyntacticAssociation) {
            pSS = ((SyntacticAssociation)pSS).getSyntacticStructure();
        }
        if (pSS instanceof SyntacticFeature) {
            pSS = ((SyntacticFeature)pSS).getSyntacticFeatureSet().getSyntacticStructure();
        }
        if (pSS instanceof SyntacticStructure) {
            SyntacticStructure lSS = (SyntacticStructure)pSS;
            if (pSST == SyntacticStructureType.ADJUNCT) {
                lSyntacticStructure.setHead(lSS.getHead());
            }
            if (pSST == SyntacticStructureType.PHRASE || pSST == SyntacticStructureType.ADJUNCT) {
                if (lSS.getSyntacticParent() != null) {
                    SyntacticStructure lSSParent = (SyntacticStructure)lSS.getSyntacticParent();
                    int lI = lSSParent.getChildren().indexOf(lSS);
                    lSSParent.getChildren().remove(lSS);
                    lSSParent.getChildren().add(lI, lSyntacticStructure);
                    lSyntacticStructure.getChildren().add(lSS);
                    lSS.setSyntacticParent(lSyntacticStructure);
                    lSyntacticStructure.setSyntacticParent(lSSParent);
                } else {
                    lSyntacticStructure.getChildren().add(lSS);
                    lSS.setSyntacticParent(lSyntacticStructure);
                    this.getSentence().removeChild(lSS);
                    this.getSentence().addChild(lSyntacticStructure);
                }
            } else if (lSS.getSyntacticLevel() == SyntacticLevel.NULL) {
                SyntacticStructure lSSParent = (SyntacticStructure)lSS.getSyntacticParent();
                int lI = lSSParent.getChildren().indexOf(lSS);
                lSSParent.getChildren().remove(lSS);
                this.deleteSubtree(lSS);
                lSSParent.getChildren().add(lI, lSyntacticStructure);
                lSyntacticStructure.setSyntacticParent(lSSParent);
            } else if (lSS.getChildren().size() == 0) {
                lSS.getChildren().add(lSyntacticStructure);
                lSyntacticStructure.setSyntacticParent(lSS);
            } else {
                this.getUIF().activateGlassPane(lSS, lSyntacticStructure);
            }
        } else {
            this.getSentence().addChild(lSyntacticStructure);
        }
        this.displayTree();
    }

    private void addUndo() {
        Document mDoc = this.getParser().saveFile(this);
        this.mDocs.add(this.mDocMaxPosition % 100, mDoc);
        ++this.mDocPosition;
        this.mDocMaxPosition = this.mDocPosition;
        this.mDocMinPosition = this.mDocPosition - 100;
        if (this.mDocMinPosition < 0) {
            this.mDocMinPosition = 0;
        }
    }

    public void displayTree() {
        if (this.mSentence.getChildren().size() > 0) {
            this.treeLayout(this.mSentence);
        } else {
            this.getUIF().getContentPane().repaint();
        }
    }

    private void treeLayout(Sentence sentence) {
        SyntacticStructure mR = (SyntacticStructure)this.mSentence.getChildren().getFirst();
        this.mLeftShift = 0.0;
        this.mRightShift = 0.0;
        this.mBottomShift = 0.0;
        this.mShift = 0.0;
        this.mPreorder = 0;
        this.mHeight = new LinkedList();
        this.mHeightPad = new LinkedList();
        this.mLinkedArray = new LinkedList();
        this.initializeTree(mR, 1, 0);
        this.firstWalk(mR, 0);
        this.secondWalk(mR, -mR.getPrelim(), 0);
        this.mLeftShift -= (double)this.getUIF().getProperties().getLeftTranslate();
        this.thirdWalk(mR, 0);
        this.fourthWalk(mR, 0);
        this.resizeUIF();
    }

    public SyntacticStructure getLower(SyntacticStructure start, int number, int previousLevel, int level, boolean left) {
        if (level >= this.mLinkedArray.size()) {
            return null;
        }
        if (left) {
            if (start.getChildren().size() > 0 && start.getLevel() == level - 1) {
                return (SyntacticStructure)start.getChildren().getFirst();
            }
            RepositionTree up = start.getSyntacticParent();
            if ((number != start.getChildren().size() || previousLevel != start.getLevel() + 1) && start.getLevel() < level - 1 && start.getChildren().size() > 0) {
                return this.getLower((SyntacticStructure)start.getChildren().getFirst(), start.getLevel(), start.getNumber(), level, left);
            }
            if (up instanceof SyntacticStructure && start.getNumber() < up.getChildren().size()) {
                return this.getLower((SyntacticStructure)up.getChildren().get(start.getNumber()), start.getNumber(), start.getLevel(), level, left);
            }
            if (up instanceof SyntacticStructure) {
                return this.getLower((SyntacticStructure)up, start.getNumber(), start.getLevel(), level, left);
            }
            return null;
        }
        if (start.getChildren().size() > 0 && start.getLevel() == level - 1) {
            return (SyntacticStructure)start.getChildren().getLast();
        }
        RepositionTree up = start.getSyntacticParent();
        if ((number != 1 || previousLevel != start.getLevel() + 1) && start.getLevel() < level - 1 && start.getChildren().size() > 0) {
            return this.getLower((SyntacticStructure)start.getChildren().getLast(), start.getLevel(), start.getNumber(), level, left);
        }
        if (start.getNumber() > 1) {
            return this.getLower((SyntacticStructure)up.getChildren().get(start.getNumber() - 2), start.getNumber(), start.getLevel(), level, left);
        }
        if (up instanceof SyntacticStructure) {
            return this.getLower((SyntacticStructure)up, start.getNumber(), start.getLevel(), level, left);
        }
        return null;
    }

    public boolean checkInsideDirection(SyntacticStructure start, SyntacticStructure end, int startLevel, int endLevel) {
        int difference = startLevel - endLevel;
        if (difference < 0) {
            return this.checkInsideDirectionRecursive(start, end);
        }
        if (difference > 0) {
            return this.checkInsideDirectionRecursive(end, start);
        }
        return true;
    }

    private boolean checkInsideDirectionRecursive(SyntacticStructure top, SyntacticStructure bottom) {
        if (!bottom.getSyntacticParent().equals(top)) {
            return this.checkInsideDirectionRecursive(top, (SyntacticStructure)bottom.getSyntacticParent());
        }
        if ((double)bottom.getNumber() > Math.ceil((double)bottom.getSyntacticParent().getChildren().size() / 2.0)) {
            return false;
        }
        if ((double)bottom.getNumber() <= Math.floor((double)bottom.getSyntacticParent().getChildren().size() / 2.0)) {
            return true;
        }
        return true;
    }

    private void resizeUIF() {
        this.mRightShift = this.mRightShift * (double)Sizer.scaleWidth() * (double)this.getUIF().getScale();
        this.mBottomShift = this.mBottomShift * (double)Sizer.scaleHeight() * (double)this.getUIF().getScale();
        double lRightShift = this.mRightShift;
        double lBottomShift = this.mBottomShift;
        if (this.mRightShift < (double)(this.getUIF().getMinWidth() - this.mPadRight)) {
            lRightShift = this.getUIF().getMinWidth() - this.mPadRight;
        }
        if (this.mBottomShift < (double)(this.getUIF().getMinHeight() - this.mPadBottom)) {
            lBottomShift = this.getUIF().getMinHeight() - this.mPadBottom;
        }
        this.getUIF().getTrace().setBounds(0, 0, (int)lRightShift + this.mPadRight, (int)lBottomShift + this.mPadBottom);
        this.getUIF().setBounds(0, 0, (int)lRightShift + this.mPadRight, (int)lBottomShift + this.mPadBottom);
        this.getUIF().getDesktopPane().setPreferredSize(new Dimension(this.getUIF().getBounds().x + (int)lRightShift + this.mPadRight, this.getUIF().getBounds().y + (int)lBottomShift + this.mPadBottom));
        this.getUIF().getDesktopPane().revalidate();
    }

    private void initializeTree(SyntacticStructure v, int number, int level) {
        v.setThread(null);
        v.setAncestor(v);
        v.setMod(0.0);
        v.setPrelim(0.0);
        v.setChange(0.0);
        v.setButtonY(0.0);
        v.setButtonX(0.0);
        v.setShift(0.0);
        v.setPadBottom(0);
        v.setNumber(number);
        v.setLevel(level);
        v.setPreorder(this.mPreorder);
        ++this.mPreorder;
        if (this.mLinkedArray.size() <= level) {
            this.mLinkedArray.add(new LinkedList());
        }
        v.setAbsoluteOrder(((LinkedList)this.mLinkedArray.get(level)).size());
        ((LinkedList)this.mLinkedArray.get(level)).add(v);
        int i = 0;
        while (i < v.getChildren().size()) {
            this.initializeTree((SyntacticStructure)v.getChildren().get(i), i + 1, level + 1);
            ++i;
        }
    }

    private void firstWalk(SyntacticStructure v, int position) {
        if (v.getChildren().size() == 0) {
            if (position == 0) {
                v.setPrelim(0.0);
            } else {
                SyntacticStructure w = (SyntacticStructure)v.getSyntacticParent().getChildren().get(position - 1);
                v.setPrelim(w.getPrelim() + (double)w.getButtonWidth());
            }
        } else {
            this.mDefaultAncestor = (SyntacticStructure)v.getChildren().getFirst();
            int i = 0;
            while (i < v.getChildren().size()) {
                this.firstWalk((SyntacticStructure)v.getChildren().get(i), i);
                this.apportion((SyntacticStructure)v.getChildren().get(i), i);
                ++i;
            }
            this.executeShifts(v);
            double midpoint = 0.5 * (((SyntacticStructure)v.getChildren().getFirst()).getPrelim() + (double)(((SyntacticStructure)v.getChildren().getFirst()).getButtonWidth() / 2) + ((SyntacticStructure)v.getChildren().getLast()).getPrelim() + (double)(((SyntacticStructure)v.getChildren().getLast()).getButtonWidth() / 2) - (double)v.getButtonWidth());
            if (position != 0) {
                SyntacticStructure w = (SyntacticStructure)v.getSyntacticParent().getChildren().get(position - 1);
                v.setPrelim(w.getPrelim() + (double)w.getButtonWidth());
                v.setMod(v.getPrelim() - midpoint);
            } else {
                v.setPrelim(midpoint);
            }
        }
    }

    private void apportion(SyntacticStructure v, int p) {
        if (p != 0) {
            SyntacticStructure VIP = v;
            SyntacticStructure VOP = v;
            SyntacticStructure VIN = (SyntacticStructure)v.getSyntacticParent().getChildren().get(p - 1);
            SyntacticStructure VON = (SyntacticStructure)VIP.getSyntacticParent().getChildren().getFirst();
            double SIP = VIP.getMod();
            double SOP = VOP.getMod();
            double SIN = VIN.getMod();
            double SON = VON.getMod();
            while (this.nextRight(VIN) != null && this.nextLeft(VIP) != null) {
                VIN = this.nextRight(VIN);
                VIP = this.nextLeft(VIP);
                VON = this.nextLeft(VON);
                VOP = this.nextRight(VOP);
                VOP.setAncestor(v);
                this.mShift = VIN.getPrelim() + SIN - (VIP.getPrelim() + SIP) + (double)VIN.getButtonWidth();
                if (this.mShift > 0.0) {
                    this.moveSubtree(this.ancestor(VIN, v), v);
                    SIP += this.mShift;
                    SOP += this.mShift;
                }
                SIN += VIN.getMod();
                SIP += VIP.getMod();
                SON += VON.getMod();
                SOP += VOP.getMod();
            }
            if (this.nextRight(VIN) != null && this.nextRight(VOP) == null) {
                VOP.setThread(this.nextRight(VIN));
                VOP.setMod(VOP.getMod() + SIN - SOP);
            }
            if (this.nextLeft(VIP) != null && this.nextLeft(VON) == null) {
                VON.setThread(this.nextLeft(VIP));
                VON.setMod(VON.getMod() + SIP - SON);
                this.mDefaultAncestor = v;
            }
        }
    }

    private SyntacticStructure nextLeft(SyntacticStructure v) {
        if (v.getChildren().size() > 0) {
            return (SyntacticStructure)v.getChildren().getFirst();
        }
        return v.getThread();
    }

    private SyntacticStructure nextRight(SyntacticStructure v) {
        if (v.getChildren().size() > 0) {
            return (SyntacticStructure)v.getChildren().getLast();
        }
        return v.getThread();
    }

    private void moveSubtree(SyntacticStructure wm, SyntacticStructure wp) {
        this.subtrees = wp.getNumber() - wm.getNumber() - 1;
        if (this.subtrees <= 0) {
            this.subtrees = 1;
        }
        wp.setChange(wp.getChange() - this.mShift / (double)this.subtrees);
        wp.setShift(wp.getShift() + this.mShift);
        wm.setChange(wm.getChange() + this.mShift / (double)this.subtrees);
        wp.setPrelim(wp.getPrelim() + this.mShift);
        wp.setMod(wp.getMod() + this.mShift);
    }

    private void executeShifts(SyntacticStructure v) {
        this.mShift = 0.0;
        this.mChange = 0.0;
        int i = v.getChildren().size() - 1;
        while (i >= 0) {
            SyntacticStructure w = (SyntacticStructure)v.getChildren().get(i);
            w.setPrelim(w.getPrelim() + this.mShift);
            w.setMod(w.getMod() + this.mShift);
            this.mChange += w.getChange();
            this.mShift = this.mShift + w.getShift() + this.mChange;
            --i;
        }
    }

    private SyntacticStructure ancestor(SyntacticStructure vin, SyntacticStructure v) {
        if (vin.getAncestor().getSyntacticParent().equals(v.getSyntacticParent()) && !vin.getAncestor().equals(v)) {
            return vin.getAncestor();
        }
        return this.mDefaultAncestor;
    }

    private void secondWalk(SyntacticStructure v, double m, int level) {
        v.setButtonX(v.getPrelim() + m);
        if (v.getButtonX() < this.mLeftShift) {
            this.mLeftShift = v.getButtonX();
        }
        if (this.mHeight.size() <= level) {
            this.mHeight.add(new Integer(v.getButtonHeight()));
        } else if ((Integer)this.mHeight.get(level) < v.getButtonHeight()) {
            this.mHeight.remove(level);
            this.mHeight.add(level, new Integer(v.getButtonHeight()));
        }
        int i = 0;
        while (i < v.getChildren().size()) {
            this.secondWalk((SyntacticStructure)v.getChildren().get(i), m + v.getMod(), level + 1);
            ++i;
        }
    }

    private void thirdWalk(SyntacticStructure v, int level) {
        int tempY = 0;
        int i = 0;
        while (i < level) {
            tempY += ((Integer)this.mHeight.get(i)).intValue();
            ++i;
        }
        tempY += ((Integer)this.mHeight.get(level) - v.getButtonHeight()) / 2;
        v.setButtonY(this.getHeight(v, level));
        v.setButtonX(v.getButtonX() - this.mLeftShift);
        v.setBounds((int)(v.getButtonX() * (double)Sizer.scaleWidth() * (double)this.getUIF().getScale()), (int)(v.getButtonY() * (double)Sizer.scaleHeight() * (double)this.getUIF().getScale()), (int)((float)v.getButtonWidth() * Sizer.scaleWidth() * this.getUIF().getScale()), (int)((float)v.getButtonHeight() * Sizer.scaleHeight() * this.getUIF().getScale()));
        int lFeatureHeight = 0;
        if (v.getButtonX() + (double)v.getButtonWidth() > this.mRightShift) {
            this.mRightShift = v.getButtonX() + (double)v.getButtonWidth();
        }
        if (v.getButtonY() + (double)v.getButtonHeight() > this.mBottomShift) {
            this.mBottomShift = v.getButtonY() + (double)v.getButtonHeight();
        }
        int i2 = 0;
        while (i2 < v.getSyntacticFeatureSet().size()) {
            SyntacticFeatureSet lSFS = (SyntacticFeatureSet)v.getSyntacticFeatureSet().get(i2);
            int lFeatureWidth = 0;
            int j = 0;
            while (j < lSFS.getSyntacticFeature().size()) {
                SyntacticFeature lSF = (SyntacticFeature)lSFS.getSyntacticFeature().get(j);
                lSF.setBounds((int)v.getButtonX() - (lSFS.getWidth() - v.getButtonWidth()) / 2 + lFeatureWidth, (int)v.getButtonY() + v.getTextHeight() + lFeatureHeight, lSF.getTextWidth(), lSF.getTextHeight());
                lSF.setBounds((int)((float)lSF.getBounds().x * Sizer.scaleWidth() * this.getUIF().getScale()), (int)((float)lSF.getBounds().y * Sizer.scaleHeight() * this.getUIF().getScale()), (int)((float)lSF.getBounds().width * Sizer.scaleWidth() * this.getUIF().getScale()), (int)((float)lSF.getBounds().height * Sizer.scaleHeight() * this.getUIF().getScale()));
                lFeatureWidth += lSF.getTextWidth();
                ++j;
            }
            lFeatureHeight += lSFS.getHeight();
            ++i2;
        }
        i2 = 0;
        while (i2 < v.getSyntacticAssociation().size()) {
            SyntacticAssociation lSA = (SyntacticAssociation)v.getSyntacticAssociation().get(i2);
            lSA.setBounds((int)v.getButtonX() - (lSA.getTextWidth() - v.getButtonWidth()) / 2, (int)v.getButtonY() + v.getTextHeight() + lFeatureHeight, lSA.getTextWidth(), lSA.getTextHeight());
            lSA.setBounds((int)((float)lSA.getBounds().x * Sizer.scaleWidth() * this.getUIF().getScale()), (int)((float)lSA.getBounds().y * Sizer.scaleHeight() * this.getUIF().getScale()), (int)((float)lSA.getBounds().width * Sizer.scaleWidth() * this.getUIF().getScale()), (int)((float)lSA.getBounds().height * Sizer.scaleHeight() * this.getUIF().getScale()));
            lFeatureHeight += lSA.getTextHeight();
            ++i2;
        }
        i2 = 0;
        while (i2 < v.getChildren().size()) {
            this.thirdWalk((SyntacticStructure)v.getChildren().get(i2), level + 1);
            ++i2;
        }
    }

    private double getHeight(SyntacticStructure v, int level) {
        int tempY = 0;
        int i = 0;
        while (i < level) {
            tempY += ((Integer)this.mHeight.get(i)).intValue();
            ++i;
        }
        return (tempY += ((Integer)this.mHeight.get(level) - v.getButtonHeight()) / 2) + this.getUIF().getProperties().getTopTranslate();
    }

    private void fourthWalk(SyntacticStructure v, int level) {
        if (v.getChildren().size() > 0) {
            SyntacticStructure left = (SyntacticStructure)v.getChildren().getFirst();
            SyntacticStructure right = (SyntacticStructure)v.getChildren().getLast();
            v.getSyntacticStructureLines().setBounds((int)(left.getButtonX() * (double)Sizer.scaleWidth() * (double)this.getUIF().getScale()), (int)((v.getButtonY() + (double)v.getButtonHeight() - (double)this.getUIF().getProperties().getMinLineLength()) * (double)Sizer.scaleHeight() * (double)this.getUIF().getScale()), (int)((right.getButtonX() + (double)right.getButtonWidth() - left.getButtonX() + 6.0) * (double)Sizer.scaleWidth() * (double)this.getUIF().getScale()), (int)((left.getButtonY() + (double)((left.getButtonHeight() - this.getUIF().getProperties().getMinLineLength()) / 2) - v.getButtonY() - (double)v.getButtonHeight() + (double)this.getUIF().getProperties().getMinLineLength() + 3.0) * (double)Sizer.scaleWidth() * (double)this.getUIF().getScale()));
        }
        int i = 0;
        while (i < v.getChildren().size()) {
            this.fourthWalk((SyntacticStructure)v.getChildren().get(i), level + 1);
            ++i;
        }
    }

    public void translateSyntacticFeature(SyntacticFeature pSF, MouseEvent pME) {
        int lX = pME.getX() - pSF.getBounds().width / 2;
        int lY = pME.getY() - pSF.getBounds().height / 2;
        Rectangle lBounds = pSF.getBounds();
        pSF.setBounds(lBounds.x + lX, lBounds.y + lY, lBounds.width, lBounds.height);
    }

    public void translateSyntacticSubtree(SyntacticStructure pSS, MouseEvent pME) {
        int lX = pME.getX() - pSS.getBounds().width / 2;
        int lY = pME.getY() - pSS.getBounds().height / 2;
        this.translateSubtree(pSS, lX, lY);
    }

    private void translateSubtree(SyntacticStructure pSS, int pX, int pY) {
        Rectangle lBounds = pSS.getBounds();
        pSS.setBounds(lBounds.x + pX, lBounds.y + pY, lBounds.width, lBounds.height);
        lBounds = pSS.getSyntacticStructureLines().getBounds();
        pSS.getSyntacticStructureLines().setBounds(lBounds.x + pX, lBounds.y + pY, lBounds.width, lBounds.height);
        int i = 0;
        while (i < pSS.getSyntacticFeatureSet().size()) {
            SyntacticFeatureSet lSFS = (SyntacticFeatureSet)pSS.getSyntacticFeatureSet().get(i);
            int j = 0;
            while (j < lSFS.getSyntacticFeature().size()) {
                SyntacticFeature lSF = (SyntacticFeature)lSFS.getSyntacticFeature().get(j);
                Rectangle nBounds = lSF.getBounds();
                lSF.setBounds(nBounds.x + pX, nBounds.y + pY, nBounds.width, nBounds.height);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < pSS.getSyntacticAssociation().size()) {
            SyntacticAssociation lSA = (SyntacticAssociation)pSS.getSyntacticAssociation().get(i);
            Rectangle nBounds = lSA.getBounds();
            lSA.setBounds(nBounds.x + pX, nBounds.y + pY, nBounds.width, nBounds.height);
            ++i;
        }
        i = 0;
        while (i < pSS.getChildren().size()) {
            this.translateSubtree((SyntacticStructure)pSS.getChildren().get(i), pX, pY);
            ++i;
        }
    }

    public void moveSyntacticStructure(SyntacticStructure pParent, SyntacticStructure pChild) {
        if (!pParent.equals(pChild)) {
            this.addUndo();
            if (pParent.getSyntacticLevel() == SyntacticLevel.NULL) {
                pChild.getSyntacticParent().getChildren().remove(pChild);
                SyntacticStructure lSSParent = (SyntacticStructure)pParent.getSyntacticParent();
                int lI = lSSParent.getChildren().indexOf(pParent);
                lSSParent.getChildren().remove(pParent);
                this.deleteSubtree(pParent);
                lSSParent.getChildren().add(lI, pChild);
                pChild.setSyntacticParent(lSSParent);
                this.displayTree();
            } else if (pChild.getSyntacticParent() != null) {
                pChild.getSyntacticParent().getChildren().remove(pChild);
                if (pParent.getChildren().size() == 0) {
                    pParent.getChildren().add(pChild);
                    pChild.setSyntacticParent(pParent);
                    this.displayTree();
                } else {
                    this.hideTree(pChild);
                    this.displayTree();
                    this.getUIF().activateGlassPane(pParent, pChild);
                }
            } else {
                this.displayTree();
            }
        } else {
            this.displayTree();
        }
    }

    public void deleteSyntacticStructure(SyntacticStructure pSS) {
        this.addUndo();
        this.deleteSubtree(pSS);
        this.resetClipboard(pSS);
        this.displayTree();
    }

    private void resetClipboard(SyntacticStructure pSS) {
        this.getUIF().getObservableClipboard().setValue(pSS.getSyntacticParent());
        if (pSS.getSyntacticParent() != null) {
            pSS.getSyntacticParent().getChildren().remove(pSS);
        } else {
            this.mSentence.removeChild(pSS);
        }
    }

    public void deleteSubtree(SyntacticStructure pSS) {
        SyntacticStructure w;
        this.deleteReferences();
        int j = 0;
        while (j < pSS.getStartTrace().size()) {
            w = (SyntacticStructure)pSS.getStartTrace().get(j);
            w.getEndTrace().remove(pSS);
            ++j;
        }
        j = 0;
        while (j < pSS.getEndTrace().size()) {
            w = (SyntacticStructure)pSS.getEndTrace().get(j);
            w.getStartTrace().remove(pSS);
            ++j;
        }
        this.getUIF().remove(pSS.getSyntacticStructureLines());
        this.getUIF().remove(pSS);
        j = 0;
        while (j < pSS.getSyntacticFeatureSet().size()) {
            SyntacticFeatureSet lSFS = (SyntacticFeatureSet)pSS.getSyntacticFeatureSet().get(j);
            int k = 0;
            while (k < lSFS.getSyntacticFeature().size()) {
                SyntacticFeature lSF = (SyntacticFeature)lSFS.getSyntacticFeature().get(k);
                int l = 0;
                while (l < lSF.getSyntacticAssociation().size()) {
                    SyntacticAssociation lSA = (SyntacticAssociation)lSF.getSyntacticAssociation().get(l);
                    SyntacticStructure lSS = lSA.getSyntacticStructure();
                    lSS.getSyntacticAssociation().remove(lSA);
                    lSS.testXY();
                    this.getUIF().remove(lSA);
                    ++l;
                }
                this.getUIF().remove(lSF);
                ++k;
            }
            ++j;
        }
        int m = 0;
        while (m < pSS.getSyntacticAssociation().size()) {
            SyntacticAssociation lSA = (SyntacticAssociation)pSS.getSyntacticAssociation().get(m);
            SyntacticFeature lSF = lSA.getSyntacticFeature();
            lSF.getSyntacticAssociation().remove(lSA);
            this.getUIF().remove(lSA);
            ++m;
        }
        int i = 0;
        while (i < pSS.getChildren().size()) {
            this.deleteSubtree((SyntacticStructure)pSS.getChildren().get(i));
            ++i;
        }
    }

    public void deleteSyntacticFeature(SyntacticFeature pSF) {
        this.addUndo();
        SyntacticFeatureSet lSFS = pSF.getSyntacticFeatureSet();
        LinkedList lSAS = pSF.getSyntacticAssociation();
        SyntacticStructure lSS = lSFS.getSyntacticStructure();
        int i = 0;
        while (i < lSAS.size()) {
            SyntacticAssociation lSA = (SyntacticAssociation)lSAS.get(i);
            SyntacticStructure nSS = lSA.getSyntacticStructure();
            nSS.getSyntacticAssociation().remove(lSA);
            this.getUIF().getContentPane().remove(lSA);
            nSS.testXY();
            ++i;
        }
        lSFS.getSyntacticFeature().remove(pSF);
        this.getUIF().getContentPane().remove(pSF);
        if (lSFS.getSyntacticFeature().size() == 0) {
            lSFS.getSyntacticFeature().remove(lSFS);
        }
        lSS.testXY();
        this.displayTree();
    }

    public void addSyntacticFeatureToStructure(SyntacticFeatureType pSFT, UserInternalFrame pUIF, Object ss) throws Exception {
        this.addUndo();
        if (ss instanceof SyntacticAssociation) {
            this.setContainer(((SyntacticAssociation)ss).getSyntacticStructure());
        }
        if (ss instanceof SyntacticFeature) {
            this.setContainer(((SyntacticFeature)ss).getSyntacticFeatureSet().getSyntacticStructure());
        }
        if (this.getContainer() instanceof SyntacticStructure) {
            AbstractFeatureBuilder lAB = null;
            if (pSFT == SyntacticFeatureType.THETA) {
                lAB = new ThetaBuilder();
            } else if (pSFT == SyntacticFeatureType.CASE) {
                lAB = new CaseBuilder();
            } else if (pSFT == SyntacticFeatureType.FEATURE) {
                lAB = new FeatureBuilder();
            } else {
                TypeNotFoundError typeNotFoundError = new TypeNotFoundError();
                throw typeNotFoundError;
            }
            SyntacticFeatureSet lSFS = FeatureDirector.build(lAB, pUIF);
            SyntacticStructure lSS = (SyntacticStructure)this.getContainer();
            lSS.getSyntacticFeatureSet().add(lSFS);
            ((SyntacticStructure)this.getContainer()).testXY();
            this.displayTree();
        }
    }

    public String getName() {
        return this.getSentence().getName();
    }

    public void setName(String pString) {
        this.getSentence().setName(pString);
    }

    public void setHighlight(Component pContainer) {
        this.setContainer(pContainer);
        if (this.getContainer() != this.mOldContainer) {
            if (this.getContainer() instanceof EditableComponent) {
                ((EditableComponent)this.getContainer()).setOver(true);
                ((EditableComponent)this.getContainer()).repaint();
            }
            if (this.mOldContainer instanceof EditableComponent) {
                ((EditableComponent)this.mOldContainer).setOver(false);
                ((EditableComponent)this.mOldContainer).repaint();
            }
            this.mOldContainer = this.getContainer();
        }
    }

    public void setSentence(Sentence mSentence) {
        this.mSentence = mSentence;
    }

    public Sentence getSentence() {
        return this.mSentence;
    }

    public JPopupMenu getPopupMenu(Object pObject) {
        if (pObject instanceof SyntacticStructure) {
            return new SSPopupMenu(this, (SyntacticStructure)pObject);
        }
        if (pObject instanceof SyntacticFeature) {
            return new SFPopupMenu(this, (SyntacticFeature)pObject);
        }
        if (pObject instanceof SyntacticAssociation) {
            return new SAPopupMenu(this, (SyntacticAssociation)pObject);
        }
        return null;
    }

    public void repositionSyntacticStructure(SyntacticStructure pSS) {
        if (pSS.getSyntacticParent() instanceof SyntacticStructure) {
            this.getUIF().getTrace().setDrawTrace(false);
            this.addUndo();
            pSS.getSyntacticParent().getChildren().remove(pSS);
            this.hideTree(pSS);
            this.displayTree();
            this.getUIF().activateGlassPane((SyntacticStructure)pSS.getSyntacticParent(), pSS);
        }
    }

    private void hideTree(SyntacticStructure pSS) {
        pSS.setBounds(0, 0, 0, 0);
        pSS.getSyntacticStructureLines().setBounds(0, 0, 0, 0);
        int i = 0;
        while (i < pSS.getSyntacticFeatureSet().size()) {
            SyntacticFeatureSet lSFS = (SyntacticFeatureSet)pSS.getSyntacticFeatureSet().get(i);
            int j = 0;
            while (j < lSFS.getSyntacticFeature().size()) {
                SyntacticFeature lSF = (SyntacticFeature)lSFS.getSyntacticFeature().get(j);
                lSF.setBounds(0, 0, 0, 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < pSS.getSyntacticAssociation().size()) {
            ((SyntacticAssociation)pSS.getSyntacticAssociation().get(i)).setBounds(0, 0, 0, 0);
            ++i;
        }
        i = 0;
        while (i < pSS.getChildren().size()) {
            this.hideTree((SyntacticStructure)pSS.getChildren().get(i));
            ++i;
        }
    }

    private void setUIF(UserInternalFrame pUIF) {
        this.mUIF = pUIF;
    }

    public UserInternalFrame getUIF() {
        return this.mUIF;
    }

    public Component getUnder(Point pContainerPoint, Object pSource, boolean nearestNeighbour) {
        this.mUnder = null;
        this.getUnderRecursive(this.getSentence(), pContainerPoint, pSource);
        if (this.mUnder == null) {
            this.mDistance = 1000000.0;
            this.getNearestNeighbour(this.getSentence(), pContainerPoint, pSource, nearestNeighbour);
            this.mUnder = this.mClosest;
        }
        return this.mUnder;
    }

    private void getNearestNeighbour(RepositionTree pRT, Point pContainerPoint, Object pSource, boolean nearestNeighbour) {
        if (pRT instanceof SyntacticStructure) {
            double yd;
            double xd;
            double distance;
            SyntacticStructure lSS = (SyntacticStructure)pRT;
            if (!lSS.equals(pSource) && (distance = (xd = lSS.getBounds().getX() + lSS.getBounds().getWidth() / 2.0 - (double)pContainerPoint.x) * xd + (yd = lSS.getBounds().getY() + lSS.getBounds().getHeight() / 2.0 - (double)pContainerPoint.y) * yd) < this.mDistance) {
                this.mDistance = distance;
                this.mClosest = lSS;
            }
            int i = 0;
            while (i < lSS.getSyntacticFeatureSet().size()) {
                SyntacticFeatureSet lSFS = (SyntacticFeatureSet)lSS.getSyntacticFeatureSet().get(i);
                int j = 0;
                while (j < lSFS.getSyntacticFeature().size()) {
                    double yd2;
                    double xd2;
                    double distance2;
                    SyntacticFeature lSF = (SyntacticFeature)lSFS.getSyntacticFeature().get(j);
                    if (!lSF.equals(pSource) && (distance2 = (xd2 = lSF.getBounds().getX() + lSF.getBounds().getWidth() / 2.0 - (double)pContainerPoint.x) * xd2 + (yd2 = lSF.getBounds().getY() + lSF.getBounds().getHeight() / 2.0 - (double)pContainerPoint.y) * yd2) < this.mDistance) {
                        this.mDistance = distance2;
                        this.mClosest = lSF;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < lSS.getSyntacticAssociation().size()) {
                double yd3;
                double xd3;
                double distance3;
                SyntacticAssociation lSA = (SyntacticAssociation)lSS.getSyntacticAssociation().get(i);
                if (!lSA.equals(pSource) && (distance3 = (xd3 = lSA.getBounds().getX() + lSA.getBounds().getWidth() / 2.0 - (double)pContainerPoint.x) * xd3 + (yd3 = lSA.getBounds().getY() + lSA.getBounds().getHeight() / 2.0 - (double)pContainerPoint.y) * yd3) < this.mDistance) {
                    this.mDistance = distance3;
                    this.mClosest = lSA;
                }
                ++i;
            }
        }
        if (nearestNeighbour || !pRT.equals(pSource)) {
            int i = 0;
            while (i < pRT.getChildren().size()) {
                this.getNearestNeighbour((RepositionTree)pRT.getChildren().get(i), pContainerPoint, pSource, nearestNeighbour);
                ++i;
            }
        }
    }

    private void getUnderRecursive(RepositionTree pRT, Point pContainerPoint, Object pSource) {
        if (pRT instanceof SyntacticStructure) {
            SyntacticStructure lSS = (SyntacticStructure)pRT;
            if (pContainerPoint.x >= lSS.getBounds().x && pContainerPoint.x <= lSS.getBounds().x + lSS.getBounds().width && pContainerPoint.y >= lSS.getBounds().y && pContainerPoint.y <= lSS.getBounds().y + lSS.getBounds().height && lSS != pSource) {
                this.mUnder = lSS;
                return;
            }
            int i = 0;
            while (i < lSS.getSyntacticFeatureSet().size()) {
                SyntacticFeatureSet lSFS = (SyntacticFeatureSet)lSS.getSyntacticFeatureSet().get(i);
                int j = 0;
                while (j < lSFS.getSyntacticFeature().size()) {
                    SyntacticFeature lSF = (SyntacticFeature)lSFS.getSyntacticFeature().get(j);
                    if (pContainerPoint.x >= lSF.getBounds().x && pContainerPoint.x <= lSF.getBounds().x + lSF.getBounds().width && pContainerPoint.y >= lSF.getBounds().y && pContainerPoint.y <= lSF.getBounds().y + lSF.getBounds().height && lSF != pSource) {
                        this.mUnder = lSF;
                        return;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < lSS.getSyntacticAssociation().size()) {
                SyntacticAssociation lSA = (SyntacticAssociation)lSS.getSyntacticAssociation().get(i);
                if (pContainerPoint.x >= lSA.getBounds().x && pContainerPoint.x <= lSA.getBounds().x + lSA.getBounds().width && pContainerPoint.y >= lSA.getBounds().y && pContainerPoint.y <= lSA.getBounds().y + lSA.getBounds().height && lSA != pSource) {
                    this.mUnder = lSA;
                    return;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < pRT.getChildren().size()) {
            this.getUnderRecursive((RepositionTree)pRT.getChildren().get(i), pContainerPoint, pSource);
            ++i;
        }
    }

    public void setFile(String pFile) {
        this.mFile = pFile;
    }

    public File getFile() {
        if (this.mFile != null) {
            return new File(this.mFile);
        }
        return null;
    }

    public void setPicture(String pPicture) {
        this.mPicture = pPicture;
    }

    public File getPicture() {
        if (this.mPicture != null) {
            return new File(this.mPicture);
        }
        return null;
    }

    public void setContainer(Component mContainer) {
        this.mContainer = mContainer;
    }

    public Component getContainer() {
        return this.mContainer;
    }

    public void associateSyntacticFeature(SyntacticStructure pSSParent, SyntacticFeature pFeature) {
        this.addUndo();
        SyntacticAssociation lSA = new SyntacticAssociation(this.getUIF());
        lSA.setSyntacticStructure(pSSParent);
        lSA.setSyntacticFeature(pFeature);
        pFeature.getSyntacticAssociation().add(lSA);
        pSSParent.getSyntacticAssociation().add(lSA);
        this.getUIF().getContentPane().add(lSA);
        lSA.setHead(pFeature.getHead());
        this.displayTree();
    }

    public void deleteSyntacticFeatureSet(SyntacticFeature mSF) {
        this.addUndo();
        while (mSF.getSyntacticFeatureSet().getSyntacticFeature().size() != 0) {
            this.deleteSyntacticFeature((SyntacticFeature)mSF.getSyntacticFeatureSet().getSyntacticFeature().get(0));
        }
    }

    public void addSyntacticFeature(SyntacticFeature mSF) {
        this.addUndo();
        SyntacticFeature lSF = new SyntacticFeature(this.getUIF());
        AttributedString lAttributedString = new AttributedString("[feature]");
        Font lFont = new Font("Doulos SIL", 0, this.getUIF().getProperties().getDefaultFontSize());
        lAttributedString.addAttribute(TextAttribute.FONT, lFont);
        lSF.setSyntacticFeatureSet(mSF.getSyntacticFeatureSet());
        mSF.getSyntacticFeatureSet().getSyntacticFeature().add(lSF);
        lSF.setHead(lAttributedString);
        this.getUIF().getContentPane().add(lSF);
        this.displayTree();
    }

    public void deleteSyntacticAssociation(SyntacticAssociation mSA) {
        this.addUndo();
        SyntacticStructure lSS = mSA.getSyntacticStructure();
        mSA.getSyntacticStructure().getSyntacticAssociation().remove(mSA);
        mSA.getSyntacticFeature().getSyntacticAssociation().remove(mSA);
        this.getUIF().getContentPane().remove(mSA);
        lSS.testXY();
        this.displayTree();
    }

    public void redo() {
        if (this.mDocPosition < this.mDocMaxPosition - 1) {
            ++this.mDocPosition;
            this.changeStack();
            this.deleteReferences();
        }
    }

    private void deleteReferences() {
        this.mUnder = null;
        this.mClosest = null;
        this.mContainer = null;
        this.mOldContainer = null;
    }

    public void undo() {
        if (this.mDocPosition == this.mDocMaxPosition) {
            this.addUndo();
            --this.mDocPosition;
        }
        if (this.mDocPosition > this.mDocMinPosition) {
            --this.mDocPosition;
            this.changeStack();
        }
        this.deleteReferences();
    }

    public void changeStack() {
        if (this.mSentence.getChildren().size() > 0) {
            this.deleteSubtree((SyntacticStructure)this.mSentence.getChildren().get(0));
            this.resetClipboard((SyntacticStructure)this.mSentence.getChildren().get(0));
            this.displayTree();
        }
        this.getParser().loadFile((Document)this.mDocs.get(this.mDocPosition % 100), this.getUIF());
    }

    public double getBottomShift() {
        return this.mBottomShift;
    }

    public double getRightShift() {
        return this.mRightShift;
    }

    public void addTrace(SyntacticStructure end, SyntacticStructure start) {
        this.addUndo();
        this.deleteStartTrace(start, false);
        this.deleteEndTrace(end, false);
        start.getStartTrace().add(end);
        end.getEndTrace().add(start);
    }

    public void translateSyntacticStructure(SyntacticStructure pSS, MouseEvent pME) {
        int lX = pME.getX() - pSS.getBounds().width / 2;
        int lY = pME.getY() - pSS.getBounds().height / 2;
        Rectangle lBounds = pSS.getBounds();
        pSS.setBounds(lBounds.x + lX, lBounds.y + lY, lBounds.width, lBounds.height);
    }

    public LinkedList getVariableHeight() {
        return this.mHeight;
    }

    public LinkedList getLinkedArray() {
        return this.mLinkedArray;
    }

    public double getLeftShift() {
        return this.mLeftShift;
    }

    public LinkedList getHeightPad() {
        return this.mHeightPad;
    }

    public void deleteStartTrace(SyntacticStructure start, boolean b) {
        if (b) {
            this.addUndo();
        }
        if (start.getStartTrace().size() > 0) {
            ((SyntacticStructure)start.getStartTrace().get(0)).getEndTrace().removeFirst();
            start.getStartTrace().removeFirst();
            start.setCustomTrace(false);
        }
    }

    public void deleteEndTrace(SyntacticStructure end, boolean b) {
        if (b) {
            this.addUndo();
        }
        if (end.getEndTrace().size() > 0) {
            ((SyntacticStructure)end.getEndTrace().get(0)).getStartTrace().removeFirst();
            ((SyntacticStructure)end.getEndTrace().get(0)).setCustomTrace(false);
            end.getEndTrace().removeFirst();
        }
    }

    public void deleteStartCustom(SyntacticStructure start) {
        start.setCustomTrace(false);
    }

    public void deleteEndCustom(SyntacticStructure end) {
        ((SyntacticStructure)end.getEndTrace().get(0)).setCustomTrace(false);
    }

    public void setLineColor(Color color) {
        Object hold = this.getUIF().getUserFrame().getObservableClipboard().getValue();
        if (hold instanceof SyntacticStructure) {
            this.addUndo();
            ((SyntacticStructure)hold).setLineColor(color);
            ((SyntacticStructure)hold).repaint();
        } else if (hold instanceof LinkedList) {
            this.addUndo();
            LinkedList list = (LinkedList)hold;
            int i = 0;
            while (i < list.size()) {
                if (list.get(i) instanceof SyntacticStructure) {
                    ((SyntacticStructure)list.get(i)).setLineColor(color);
                }
                ++i;
            }
        }
    }

    public void changeAttributes(AttributedCharacterIterator.Attribute string, Object object) {
        Object hold = this.getUIF().getUserFrame().getObservableClipboard().getValue();
        if (hold instanceof EditableComponent && ((EditableComponent)hold).testAttribute()) {
            this.addUndo();
            ((EditableComponent)hold).addAttribute(string, object);
        }
        if (hold instanceof LinkedList) {
            LinkedList list = (LinkedList)hold;
            this.addUndo();
            int i = 0;
            while (i < list.size()) {
                EditableComponent component = (EditableComponent)list.get(i);
                component.addAttribute(string, object);
                ++i;
            }
        }
    }

    public void selectTree(int x1, int y1, int x2, int y2) {
        this.mSelected = new LinkedList();
        this.deselectTree();
        if (this.getSentence().getChildren().size() > 0) {
            this.selectTreeRecursive((RepositionTree)this.getSentence().getChildren().get(0), x1, y1, x2, y2);
            this.getUIF().getUserFrame().getObservableClipboard().setValue(this.mSelected);
        }
    }

    private void selectTreeRecursive(RepositionTree pRT, int x1, int y1, int x2, int y2) {
        if (pRT instanceof SyntacticStructure) {
            SyntacticStructure lSS = (SyntacticStructure)pRT;
            if (x1 < lSS.getBounds().x && y1 < lSS.getBounds().y && x2 > lSS.getBounds().x + lSS.getTextWidth() && y2 > lSS.getBounds().y + lSS.getTextHeight()) {
                this.mSelected.add(lSS);
                lSS.selectAll();
            }
            int i = 0;
            while (i < lSS.getSyntacticFeatureSet().size()) {
                SyntacticFeatureSet lSFS = (SyntacticFeatureSet)lSS.getSyntacticFeatureSet().get(i);
                int j = 0;
                while (j < lSFS.getSyntacticFeature().size()) {
                    SyntacticFeature lSF = (SyntacticFeature)lSFS.getSyntacticFeature().get(j);
                    if (x1 < lSF.getBounds().x && y1 < lSF.getBounds().y && x2 > lSF.getBounds().x + lSF.getTextWidth() && y2 > lSF.getBounds().y + lSF.getTextHeight()) {
                        this.mSelected.add(lSF);
                        lSF.selectAll();
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < lSS.getSyntacticAssociation().size()) {
                SyntacticAssociation lSA = (SyntacticAssociation)lSS.getSyntacticAssociation().get(i);
                if (x1 < lSA.getBounds().x && y1 < lSA.getBounds().y && x2 > lSA.getBounds().x + lSA.getTextWidth() && y2 > lSA.getBounds().y + lSA.getTextHeight()) {
                    this.mSelected.add(lSA);
                    lSA.selectAll();
                }
                ++i;
            }
            i = 0;
            while (i < pRT.getChildren().size()) {
                this.selectTreeRecursive((RepositionTree)pRT.getChildren().get(i), x1, y1, x2, y2);
                ++i;
            }
        }
    }

    public void deselectTree() {
        if (this.getSentence().getChildren().size() > 0) {
            this.deselectTreeRecursive((RepositionTree)this.getSentence().getChildren().get(0));
        }
    }

    private void deselectTreeRecursive(RepositionTree pRT) {
        if (pRT instanceof SyntacticStructure) {
            SyntacticStructure lSS = (SyntacticStructure)pRT;
            lSS.setHighlightBegin(0);
            lSS.setHighlightEnd(0);
            lSS.setCarat(false);
            lSS.setOver(false);
            lSS.repaint();
            int i = 0;
            while (i < lSS.getSyntacticFeatureSet().size()) {
                SyntacticFeatureSet lSFS = (SyntacticFeatureSet)lSS.getSyntacticFeatureSet().get(i);
                int j = 0;
                while (j < lSFS.getSyntacticFeature().size()) {
                    SyntacticFeature lSF = (SyntacticFeature)lSFS.getSyntacticFeature().get(j);
                    lSF.setHighlightBegin(0);
                    lSF.setHighlightEnd(0);
                    lSF.setCarat(false);
                    lSF.setOver(false);
                    lSF.repaint();
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < lSS.getSyntacticAssociation().size()) {
                SyntacticAssociation lSA = (SyntacticAssociation)lSS.getSyntacticAssociation().get(i);
                lSA.setHighlightBegin(0);
                lSA.setHighlightEnd(0);
                lSA.setCarat(false);
                lSA.setOver(false);
                lSA.repaint();
                ++i;
            }
            i = 0;
            while (i < pRT.getChildren().size()) {
                this.deselectTreeRecursive((RepositionTree)pRT.getChildren().get(i));
                ++i;
            }
        }
    }
}

