/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class XTraScrollBarUI
extends BasicScrollBarUI {
    protected boolean useAlternateLayout = Boolean.TRUE.equals(UIManager.get("ScrollBar.alternateLayout"));

    public static ComponentUI createUI(JComponent x) {
        return new XTraScrollBarUI();
    }

    protected void layoutVScrollbar(JScrollBar sb) {
        if (this.useAlternateLayout) {
            this.alternateLayoutVScrollbar(sb);
        } else {
            super.layoutVScrollbar(sb);
        }
    }

    protected void alternateLayoutVScrollbar(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int incrButtonH = this.incrButton.getPreferredSize().height;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int decrButtonH = this.decrButton.getPreferredSize().height;
        int decrButtonY = incrButtonY - decrButtonH;
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButtonH + incrButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = decrButtonY - thumbH;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            incrButtonH = decrButtonH = sbAvailButtonH / 2;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.incrButton.setBounds(itemX, incrButtonY, itemW, incrButtonH);
        int itrackY = sbInsets.top;
        int itrackH = decrButtonY - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > decrButtonY) {
                thumbY = decrButtonY - thumbH;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void layoutHScrollbar(JScrollBar sb) {
        if (this.useAlternateLayout) {
            this.alternateLayoutHScrollbar(sb);
        } else {
            super.layoutHScrollbar(sb);
        }
    }

    protected void alternateLayoutHScrollbar(JScrollBar sb) {
        int sbAvailButtonW;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        int incrButtonW = this.incrButton.getPreferredSize().width;
        int incrButtonX = sbSize.width - (sbInsets.right + incrButtonW);
        int decrButtonW = this.decrButton.getPreferredSize().width;
        int decrButtonX = incrButtonX - decrButtonW;
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = decrButtonW + incrButtonW;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int thumbX = decrButtonX - thumbW;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
        }
        if ((sbAvailButtonW = sbSize.width - sbInsetsW) < sbButtonsW) {
            incrButtonW = decrButtonW = sbAvailButtonW / 2;
            incrButtonX = sbSize.width - (sbInsets.right + incrButtonW);
        }
        this.decrButton.setBounds(decrButtonX, itemY, decrButtonW, itemH);
        this.incrButton.setBounds(incrButtonX, itemY, incrButtonW, itemH);
        int itrackX = sbInsets.left;
        int itrackW = decrButtonX - itrackX;
        this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbX + thumbW > incrButtonX) {
                thumbX = incrButtonX - thumbW;
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    protected BasicScrollBarUI.TrackListener createTrackListener() {
        if (this.useAlternateLayout) {
            return new MyTrackListener();
        }
        return super.createTrackListener();
    }

    public JButton decrButton() {
        return this.decrButton;
    }

    public JButton incrButton() {
        return this.incrButton;
    }

    public JScrollBar scrollbar() {
        return this.scrollbar;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public Rectangle getThumbBounds() {
        return super.getThumbBounds();
    }

    public Rectangle getTrackBounds() {
        return super.getTrackBounds();
    }

    public void setThumbBounds(int x, int y, int w, int h) {
        super.setThumbBounds(x, y, w, h);
    }

    public class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        public MyTrackListener() {
            super(XTraScrollBarUI.this);
        }

        public void mouseDragged(MouseEvent e) {
            int thumbPos;
            int thumbMax;
            int thumbMin;
            if (!XTraScrollBarUI.this.scrollbar().isEnabled() || !XTraScrollBarUI.this.isDragging()) {
                return;
            }
            Insets sbInsets = XTraScrollBarUI.this.scrollbar().getInsets();
            BoundedRangeModel model = XTraScrollBarUI.this.scrollbar().getModel();
            Rectangle thumbR = XTraScrollBarUI.this.getThumbBounds();
            if (XTraScrollBarUI.this.scrollbar().getOrientation() == 1) {
                thumbMin = sbInsets.top;
                thumbMax = XTraScrollBarUI.this.decrButton().getY() - XTraScrollBarUI.this.getThumbBounds().height;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getY() - this.offset));
                XTraScrollBarUI.this.setThumbBounds(thumbR.x, thumbPos, thumbR.width, thumbR.height);
            } else {
                thumbMin = sbInsets.left;
                thumbMax = XTraScrollBarUI.this.decrButton().getX() - XTraScrollBarUI.this.getThumbBounds().width;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getX() - this.offset));
                XTraScrollBarUI.this.setThumbBounds(thumbPos, thumbR.y, thumbR.width, thumbR.height);
            }
            if (thumbPos == thumbMax) {
                XTraScrollBarUI.this.scrollbar().setValue(model.getMaximum() - model.getExtent());
            } else {
                float valueMax = model.getMaximum() - model.getExtent();
                float valueRange = valueMax - (float)model.getMinimum();
                float thumbValue = thumbPos - thumbMin;
                float thumbRange = thumbMax - thumbMin;
                int value = (int)(0.5 + (double)(thumbValue / thumbRange * valueRange));
                XTraScrollBarUI.this.scrollbar().setValue(value + model.getMinimum());
            }
        }
    }
}

