/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.skin.Skin;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class LiquidToolBarUI
extends BasicToolBarUI {
    private Border border = new EmptyBorder(4, 4, 4, 4);
    private int orientation = -1;
    private boolean changeBorder = true;
    private Skin vbarHandler = new Skin("vtoolbarhandler.png", 1, 8, 3, 8, 3);
    private Skin hbarHandler = new Skin("htoolbarhandler.png", 1, 3, 8, 3, 8);

    public static ComponentUI createUI(JComponent c) {
        return new LiquidToolBarUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
    }

    public void paint(Graphics g, JComponent c) {
        if (LiquidLookAndFeel.areStipplesUsed()) {
            c.setOpaque(false);
        }
        if (!this.isFloating()) {
            if (this.toolBar.getOrientation() != this.orientation) {
                if (this.toolBar.getOrientation() == 0) {
                    if (this.toolBar.isFloatable()) {
                        this.toolBar.setBorder(new EmptyBorder(2, 11, 2, 2));
                    } else {
                        this.toolBar.setBorder(new EmptyBorder(2, 2, 2, 2));
                    }
                } else if (this.toolBar.isFloatable()) {
                    this.toolBar.setBorder(new EmptyBorder(12, 2, 2, 2));
                } else {
                    this.toolBar.setBorder(new EmptyBorder(2, 2, 2, 2));
                }
                this.orientation = this.toolBar.getOrientation();
                this.changeBorder = true;
            }
            if (this.toolBar.getOrientation() == 0) {
                if (this.toolBar.isFloatable()) {
                    this.vbarHandler.draw(g, 0, 1, 2, 8, c.getHeight() - 4);
                }
            } else if (this.toolBar.isFloatable()) {
                this.hbarHandler.draw(g, 0, 1, 2, c.getWidth() - 4, 8);
            }
        } else if (this.changeBorder) {
            this.toolBar.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.changeBorder = false;
            this.orientation = -1;
        }
    }

    protected void setBorderToRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            b.setBorder(this.border);
            b.putClientProperty("JToolBar.isToolbarButton", Boolean.TRUE);
        }
    }

    protected void setBorderToNormal(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            b.setBorder(this.border);
            b.putClientProperty("JToolBar.isToolbarButton", Boolean.TRUE);
        }
    }
}

