/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.skin.SkinImageCache;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class LiquidProgressBarUI
extends BasicProgressBarUI {
    static Skin skinHorizontal;
    static Skin skinVertical;
    int offset = 3;

    public static ComponentUI createUI(JComponent c) {
        return new LiquidProgressBarUI();
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Graphics2D g2 = (Graphics2D)g;
        if (this.progressBar.getOrientation() == 0) {
            int amountFull = this.getAmountFull(b, barRectWidth - this.offset * 2, barRectHeight);
            LiquidProgressBarUI.getSkinHorizontal().draw(g, 0, barRectWidth, barRectHeight);
            g.translate(this.offset - 1, 0);
            BufferedImage img = SkinImageCache.getInstance().getBufferedImage("hprogressbar.png");
            TexturePaint tp = new TexturePaint(img, new Rectangle2D.Float(0.0f, 0.0f, img.getWidth(), img.getHeight()));
            Paint p = g2.getPaint();
            g2.setPaint(tp);
            g2.fillRect(1, 3, amountFull, barRectHeight - 6);
            g2.setPaint(p);
            if (amountFull > 0) {
                g2.setColor(new Color(179, 192, 207));
                g2.drawLine(0, 2, 0, barRectHeight - 4);
                g2.drawLine(0, 2, amountFull, 2);
                g2.setColor(new Color(195, 209, 226));
                g2.drawLine(amountFull + 1, 2, amountFull + 1, barRectHeight - 3);
                g2.drawLine(0, barRectHeight - 3, amountFull + 1, barRectHeight - 3);
            }
            g.translate(-this.offset + 1, 0);
            if (this.progressBar.isStringPainted()) {
                g.setColor(Color.black);
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
        } else {
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight - 2 * this.offset);
            LiquidProgressBarUI.getSkinVertical().draw(g, 0, barRectWidth, barRectHeight);
            BufferedImage img = SkinImageCache.getInstance().getBufferedImage("XPProgressIndicatorVert.res");
            amountFull = amountFull / img.getHeight() * img.getHeight();
            g.translate(0, barRectHeight - this.offset);
            BufferedImage imgL = SkinImageCache.getInstance().getBufferedImage("XPLeftProgressBar.res");
            BufferedImage imgM = SkinImageCache.getInstance().getBufferedImage("XPCenterProgressBar.res");
            BufferedImage imgR = SkinImageCache.getInstance().getBufferedImage("XPRightProgressBar.res");
            TexturePaint tpL = new TexturePaint(imgL, new Rectangle2D.Float(0.0f, 0.0f, imgL.getWidth(), imgL.getHeight()));
            TexturePaint tpM = new TexturePaint(imgM, new Rectangle2D.Float(imgL.getWidth(), 0.0f, imgM.getWidth(), imgM.getHeight()));
            TexturePaint tpR = new TexturePaint(imgR, new Rectangle2D.Float(barRectWidth - imgR.getWidth(), 0.0f, imgR.getWidth(), imgR.getHeight()));
            Paint p = g2.getPaint();
            g2.setPaint(tpL);
            g2.fillRect(0, -amountFull, imgL.getWidth(), amountFull);
            g2.setPaint(tpM);
            g2.fillRect(imgL.getWidth(), -amountFull, barRectWidth - imgR.getWidth() - imgL.getWidth(), amountFull);
            g2.setPaint(tpR);
            g2.fillRect(barRectWidth - imgR.getWidth(), -amountFull, imgR.getWidth(), amountFull);
            g2.setPaint(p);
            g.translate(0, -(barRectHeight - this.offset));
            if (this.progressBar.isStringPainted()) {
                g.setColor(Color.black);
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
        }
    }

    protected void paintIndeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Rectangle boxRect = this.getBox(null);
        if (this.progressBar.getOrientation() == 0) {
            LiquidProgressBarUI.getSkinHorizontal().draw(g, 0, barRectWidth, barRectHeight);
            g.translate(boxRect.x + this.offset, boxRect.y);
            BufferedImage img = SkinImageCache.getInstance().getBufferedImage("hprogressbar.png");
            TexturePaint tp = new TexturePaint(img, new Rectangle2D.Float(0.0f, 0.0f, img.getWidth(), img.getHeight()));
            Paint p = g2.getPaint();
            g2.setPaint(tp);
            g2.fillRect(1, 3, 20, barRectHeight - 6);
            g2.setPaint(p);
            g2.setColor(new Color(195, 209, 226));
            g2.drawLine(20, 2, 20, barRectHeight - 4);
            g2.drawLine(0, barRectHeight - 3, 20, barRectHeight - 3);
            g2.setColor(new Color(179, 192, 207));
            g2.drawLine(0, 2, 0, barRectHeight - 4);
            g2.drawLine(0, 2, 20, 2);
            g.translate(-boxRect.x - this.offset, -boxRect.y);
        } else {
            LiquidProgressBarUI.getSkinVertical().draw(g, 0, barRectWidth, barRectHeight);
            g.translate(boxRect.x, boxRect.y + this.offset);
            BufferedImage imgL = SkinImageCache.getInstance().getBufferedImage("XPLeftProgressBar.res");
            BufferedImage imgM = SkinImageCache.getInstance().getBufferedImage("XPCenterProgressBar.res");
            BufferedImage imgR = SkinImageCache.getInstance().getBufferedImage("XPRightProgressBar.res");
            TexturePaint tpL = new TexturePaint(imgL, new Rectangle2D.Float(0.0f, 0.0f, imgL.getWidth(), imgL.getHeight()));
            TexturePaint tpM = new TexturePaint(imgM, new Rectangle2D.Float(imgL.getWidth(), 0.0f, imgM.getWidth(), imgM.getHeight()));
            TexturePaint tpR = new TexturePaint(imgR, new Rectangle2D.Float(barRectWidth - imgR.getWidth(), 0.0f, imgR.getWidth(), imgR.getHeight()));
            int h = (boxRect.height - 2 * this.offset) / imgM.getHeight() * imgM.getHeight();
            Paint p = g2.getPaint();
            g2.setPaint(tpL);
            g2.fillRect(0, 0, imgL.getWidth(), h);
            g2.setPaint(tpM);
            g2.fillRect(imgL.getWidth(), 0, barRectWidth - imgR.getWidth() - imgL.getWidth(), h);
            g2.setPaint(tpR);
            g2.fillRect(barRectWidth - imgR.getWidth(), 0, imgR.getWidth(), h);
            g2.setPaint(p);
            g.translate(-boxRect.x, -boxRect.y - this.offset);
        }
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    protected void installDefaults() {
    }

    public static Skin getSkinHorizontal() {
        if (skinHorizontal == null) {
            skinHorizontal = new Skin("progressborderhoriz.png", 1, 1, 1, 1, 1);
        }
        return skinHorizontal;
    }

    public static Skin getSkinVertical() {
        if (skinVertical == null) {
            skinVertical = new Skin("progressbordervert.png", 1, 1, 1, 1, 1);
        }
        return skinVertical;
    }
}

