/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidCheckBoxIcon;
import com.birosoft.liquid.LiquidComboBoxButton;
import com.birosoft.liquid.LiquidComboBoxEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class LiquidComboBoxUI
extends BasicComboBoxUI {
    static int comboBoxButtonSize = 18;
    private int prevSelectedItem;

    public static ComponentUI createUI(final JComponent c) {
        c.setOpaque(false);
        c.addPropertyChangeListener("opaque", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                c.setOpaque(false);
            }
        });
        return new LiquidComboBoxUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.addKeyboardActions((JComboBox)c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    public void paint(Graphics g, JComponent c) {
    }

    protected ComboBoxEditor createEditor() {
        return new LiquidComboBoxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        return new LiquidComboPopup(this.comboBox);
    }

    protected JButton createArrowButton() {
        LiquidComboBoxButton button = new LiquidComboBoxButton(this.comboBox, new LiquidCheckBoxIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setFocusable(false);
        return button;
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new LiquidPropertyChangeListener();
    }

    private void addKeyboardActions(final JComboBox cb) {
        KeyStroke ksEnter = KeyStroke.getKeyStroke(10, 0);
        cb.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LiquidComboBoxUI.this.prevSelectedItem = cb.getSelectedIndex();
                if (cb.isPopupVisible()) {
                    cb.hidePopup();
                } else {
                    cb.showPopup();
                }
            }
        }, ksEnter, 0);
        KeyStroke ksESC = KeyStroke.getKeyStroke(27, 0);
        cb.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                cb.hidePopup();
                cb.setSelectedIndex(LiquidComboBoxUI.this.prevSelectedItem);
            }
        }, ksESC, 0);
        KeyStroke ksDown = KeyStroke.getKeyStroke(40, 0);
        cb.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (cb.getSelectedIndex() <= cb.getItemCount() - 2) {
                    cb.setSelectedIndex(cb.getSelectedIndex() + 1);
                } else if (cb.getSelectedIndex() == -1 && cb.getItemCount() > 0) {
                    cb.setSelectedIndex(0);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }, ksDown, 0);
        KeyStroke ksRight = KeyStroke.getKeyStroke(39, 0);
        cb.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (cb.getSelectedIndex() <= cb.getItemCount() - 2) {
                    cb.setSelectedIndex(cb.getSelectedIndex() + 1);
                } else if (cb.getSelectedIndex() == -1 && cb.getItemCount() > 0) {
                    cb.setSelectedIndex(0);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }, ksRight, 0);
        KeyStroke ksUp = KeyStroke.getKeyStroke(38, 0);
        cb.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (cb.getSelectedIndex() > 0) {
                    cb.setSelectedIndex(cb.getSelectedIndex() - 1);
                } else if (cb.getSelectedIndex() == -1 && cb.getItemCount() > 0) {
                    cb.setSelectedIndex(0);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }, ksUp, 0);
        KeyStroke ksLeft = KeyStroke.getKeyStroke(37, 0);
        cb.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (cb.getSelectedIndex() > 0) {
                    cb.setSelectedIndex(cb.getSelectedIndex() - 1);
                } else if (cb.getSelectedIndex() == -1 && cb.getItemCount() > 0) {
                    cb.setSelectedIndex(0);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }, ksLeft, 0);
    }

    protected void editablePropertyChanged(PropertyChangeEvent e) {
    }

    protected LayoutManager createLayoutManager() {
        return new MetouiaComboBoxLayoutManager();
    }

    protected Rectangle rectangleForCurrentValue2() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int buttonSize = height - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            buttonSize = comboBoxButtonSize;
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left + 8, insets.top, width - (insets.left + insets.right + buttonSize) - 7, height - (insets.top + insets.bottom) - 2);
        }
        return new Rectangle(insets.left + buttonSize, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
    }

    protected void removeListeners() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void configureEditor() {
        super.configureEditor();
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
    }

    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof LiquidComboBoxButton) {
            LiquidComboBoxButton button = (LiquidComboBoxButton)this.arrowButton;
            Insets buttonInsets = new Insets(0, 0, 0, 0);
            Insets insets = this.comboBox.getInsets();
            size = this.getDisplaySize();
            size.width += comboBoxButtonSize + insets.left + insets.right;
            size.width += buttonInsets.left + buttonInsets.right;
            size.width += buttonInsets.right + button.getComboIcon().getIconWidth();
            size.height += insets.top + insets.bottom;
            size.height += buttonInsets.top + buttonInsets.bottom;
            size.height = Math.max(21, size.height);
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            size = super.getMinimumSize(c);
            Insets margin = this.arrowButton.getMargin();
            Insets insets = this.comboBox.getInsets();
            boolean cfr_ignored_0 = this.editor instanceof JComponent;
            size.height += margin.top + margin.bottom;
            size.height += insets.top + insets.bottom;
        } else {
            size = super.getMinimumSize(c);
        }
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    public class LiquidComboPopup
    extends BasicComboPopup {
        private static final long serialVersionUID = 1L;

        public LiquidComboPopup(JComboBox cBox) {
            super(cBox);
        }

        public void delegateFocus(MouseEvent e) {
            super.delegateFocus(e);
        }
    }

    public class LiquidPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public LiquidPropertyChangeListener() {
            super(LiquidComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if (propertyName.equals("editable")) {
                LiquidComboBoxButton button = (LiquidComboBoxButton)LiquidComboBoxUI.this.arrowButton;
                button.setIconOnly(LiquidComboBoxUI.this.comboBox.isEditable());
                LiquidComboBoxUI.this.comboBox.repaint();
            } else if (propertyName.equals("background")) {
                Color color = (Color)e.getNewValue();
                LiquidComboBoxUI.this.listBox.setBackground(color);
            } else if (propertyName.equals("foreground")) {
                Color color = (Color)e.getNewValue();
                LiquidComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }

    public class MetouiaComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            if (LiquidComboBoxUI.this.comboBox.isEditable()) {
                if (LiquidComboBoxUI.this.arrowButton != null) {
                    LiquidComboBoxUI.this.arrowButton.setBounds(0, 0, width, height);
                }
                if (LiquidComboBoxUI.this.editor != null) {
                    Rectangle cvb = LiquidComboBoxUI.this.rectangleForCurrentValue2();
                    LiquidComboBoxUI.this.editor.setBounds(cvb);
                }
            } else {
                LiquidComboBoxUI.this.arrowButton.setBounds(0, 0, width, height);
            }
        }
    }
}

