/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidCheckBoxIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxUI;
import javax.swing.text.View;

public class LiquidCheckBoxUI
extends BasicCheckBoxUI {
    private static Dimension size = new Dimension();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static final LiquidCheckBoxUI checkBoxUI = new LiquidCheckBoxUI();
    static LiquidCheckBoxIcon skinnedIcon = new LiquidCheckBoxIcon();
    static BasicStroke focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f}, 1.0f);

    public static ComponentUI createUI(JComponent c) {
        return checkBoxUI;
    }

    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        this.icon = skinnedIcon;
        button.setRolloverEnabled(true);
    }

    protected void paintFocus(Graphics g, Rectangle t, Dimension arg2) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.black);
        g2d.setStroke(focusStroke);
        g2d.drawLine(t.x - 1, t.y - 1, t.x - 1 + t.width + 1, t.y - 1);
        g2d.drawLine(t.x - 1, t.y - 1 + t.height + 1, t.x - 1 + t.width + 1, t.y - 1 + t.height + 1);
        g2d.drawLine(t.x - 1, t.y - 1, t.x - 1, t.y - 1 + t.height + 1);
        g2d.drawLine(t.x - 1 + t.width + 1, t.y - 1, t.x - 1 + t.width + 1, t.y - 1 + t.height + 1);
    }

    public synchronized void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        size = b.getSize(size);
        LiquidCheckBoxUI.viewRect.x = i.left;
        LiquidCheckBoxUI.viewRect.y = i.top;
        LiquidCheckBoxUI.viewRect.width = LiquidCheckBoxUI.size.width - (i.right + LiquidCheckBoxUI.viewRect.x);
        LiquidCheckBoxUI.viewRect.height = LiquidCheckBoxUI.size.height - (i.bottom + LiquidCheckBoxUI.viewRect.y);
        LiquidCheckBoxUI.iconRect.height = 0;
        LiquidCheckBoxUI.iconRect.width = 0;
        LiquidCheckBoxUI.iconRect.y = 0;
        LiquidCheckBoxUI.iconRect.x = 0;
        LiquidCheckBoxUI.textRect.height = 0;
        LiquidCheckBoxUI.textRect.width = 0;
        LiquidCheckBoxUI.textRect.y = 0;
        LiquidCheckBoxUI.textRect.x = 0;
        Icon altIcon = b.getIcon();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (c.getParent() instanceof CellRendererPane) {
            c.setOpaque(true);
        } else if (c.isOpaque()) {
            c.setOpaque(false);
            c.repaint();
        }
        if (altIcon != null) {
            if (!model.isEnabled()) {
                altIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if (altIcon == null) {
                    altIcon = b.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    altIcon = b.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = b.getSelectedIcon();
                    }
                } else {
                    altIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                altIcon = b.getRolloverIcon();
            }
            if (altIcon == null) {
                altIcon = b.getIcon();
            }
            altIcon.paintIcon(c, g, LiquidCheckBoxUI.iconRect.x, LiquidCheckBoxUI.iconRect.y);
        } else {
            this.getDefaultIcon().paintIcon(c, g, LiquidCheckBoxUI.iconRect.x, LiquidCheckBoxUI.iconRect.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
                if (b.hasFocus() && b.isFocusPainted() && LiquidCheckBoxUI.textRect.width > 0 && LiquidCheckBoxUI.textRect.height > 0) {
                    this.paintFocus(g, textRect, size);
                }
            }
        }
    }
}

