/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.procaddress;

import com.jogamp.gluegen.CMethodBindingEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.procaddress.ProcAddressEmitter;
import java.io.PrintWriter;

public class ProcAddressCMethodBindingEmitter
extends CMethodBindingEmitter {
    private boolean callThroughProcAddress;
    private boolean needsLocalTypedef;
    private String localTypedefCallingConvention;
    private static final String procAddressJavaTypeName = JavaType.createForClass(Long.TYPE).jniTypeName();
    private ProcAddressEmitter emitter;

    public ProcAddressCMethodBindingEmitter(CMethodBindingEmitter cMethodBindingEmitter, final boolean bl, boolean bl2, String string, ProcAddressEmitter procAddressEmitter) {
        super(new MethodBinding(cMethodBindingEmitter.getBinding()){

            @Override
            public String getName() {
                if (bl) {
                    return "dispatch_" + super.getName();
                }
                return super.getName();
            }
        }, cMethodBindingEmitter.getDefaultOutput(), cMethodBindingEmitter.getJavaPackageName(), cMethodBindingEmitter.getJavaClassName(), cMethodBindingEmitter.getIsOverloadedBinding(), cMethodBindingEmitter.getIsJavaMethodStatic(), true, cMethodBindingEmitter.forIndirectBufferAndArrayImplementation(), cMethodBindingEmitter.getMachineDescription());
        if (cMethodBindingEmitter.getReturnValueCapacityExpression() != null) {
            this.setReturnValueCapacityExpression(cMethodBindingEmitter.getReturnValueCapacityExpression());
        }
        if (cMethodBindingEmitter.getReturnValueLengthExpression() != null) {
            this.setReturnValueLengthExpression(cMethodBindingEmitter.getReturnValueLengthExpression());
        }
        this.setTemporaryCVariableDeclarations(cMethodBindingEmitter.getTemporaryCVariableDeclarations());
        this.setTemporaryCVariableAssignments(cMethodBindingEmitter.getTemporaryCVariableAssignments());
        this.setCommentEmitter(defaultCommentEmitter);
        this.callThroughProcAddress = bl;
        this.needsLocalTypedef = bl2;
        this.localTypedefCallingConvention = string;
        this.emitter = procAddressEmitter;
    }

    @Override
    protected int emitArguments(PrintWriter printWriter) {
        int n = super.emitArguments(printWriter);
        if (this.callThroughProcAddress) {
            if (n > 0) {
                printWriter.print(", ");
            }
            printWriter.print(procAddressJavaTypeName);
            printWriter.print(" procAddress");
            ++n;
        }
        return n;
    }

    @Override
    protected void emitBodyVariableDeclarations(PrintWriter printWriter) {
        if (this.callThroughProcAddress) {
            FunctionSymbol functionSymbol = this.getBinding().getCSymbol();
            String string = this.emitter.getFunctionPointerTypedefName(functionSymbol);
            if (this.needsLocalTypedef) {
                PointerType pointerType = new PointerType(null, functionSymbol.getType(), 0);
                string = "_local_" + string;
                printWriter.print("  typedef ");
                printWriter.print(pointerType.toString(string, this.localTypedefCallingConvention));
                printWriter.println(";");
            }
            printWriter.print("  ");
            printWriter.print(string);
            printWriter.print(" ptr_");
            printWriter.print(functionSymbol.getName());
            printWriter.println(";");
        }
        super.emitBodyVariableDeclarations(printWriter);
    }

    @Override
    protected void emitBodyVariablePreCallSetup(PrintWriter printWriter) {
        super.emitBodyVariablePreCallSetup(printWriter);
        if (this.callThroughProcAddress) {
            FunctionSymbol functionSymbol = this.getBinding().getCSymbol();
            String string = this.emitter.getFunctionPointerTypedefName(functionSymbol);
            if (this.needsLocalTypedef) {
                string = "_local_" + string;
            }
            String string2 = "ptr_" + functionSymbol.getName();
            printWriter.print("  ");
            printWriter.print(string2);
            printWriter.print(" = (");
            printWriter.print(string);
            printWriter.println(") (intptr_t) procAddress;");
            printWriter.println("  assert(" + string2 + " != NULL);");
        }
    }

    @Override
    protected void emitBodyCallCFunction(PrintWriter printWriter) {
        if (!this.callThroughProcAddress) {
            super.emitBodyCallCFunction(printWriter);
        } else {
            MethodBinding methodBinding;
            printWriter.print("  ");
            Type type = this.binding.getCReturnType();
            if (!type.isVoid()) {
                printWriter.print("_res = ");
            }
            if ((methodBinding = this.getBinding()).hasContainingType()) {
                throw new IllegalStateException("Cannot call through function pointer because binding has containing type: " + methodBinding);
            }
            printWriter.print("(* ptr_");
            printWriter.print(methodBinding.getCSymbol().getName());
            printWriter.print(") ");
            printWriter.print("(");
            this.emitBodyPassCArguments(printWriter);
            printWriter.println(");");
        }
    }

    @Override
    protected String jniMangle(MethodBinding methodBinding) {
        StringBuilder stringBuilder = new StringBuilder(super.jniMangle(methodBinding));
        if (this.callThroughProcAddress) {
            this.jniMangle(Long.TYPE, stringBuilder, false);
        }
        return stringBuilder.toString();
    }
}

