/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.gluegen.cgram.types.IntType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeVisitor;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class EnumType
extends IntType
implements Cloneable {
    private IntType underlyingType;
    private ArrayList<Enum> enums;

    public EnumType(String string) {
        super(string, SizeThunk.LONG, false, 1);
        this.underlyingType = new IntType(string, SizeThunk.LONG, false, 1);
    }

    public EnumType(String string, SizeThunk sizeThunk) {
        super(string, sizeThunk, false, 1);
        this.underlyingType = new IntType(string, sizeThunk, false, 1);
    }

    protected EnumType(String string, IntType intType, int n) {
        super(string, intType.getSize(), intType.isUnsigned(), n);
        this.underlyingType = intType;
    }

    @Override
    public Object clone() {
        EnumType enumType = (EnumType)super.clone();
        if (null != this.underlyingType) {
            enumType.underlyingType = (IntType)this.underlyingType.clone();
        }
        if (null != this.enums) {
            enumType.enums = new ArrayList<Enum>(this.enums);
        }
        return enumType;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof EnumType)) {
            return false;
        }
        EnumType enumType = (EnumType)object;
        return super.equals(object) && this.underlyingType.equals(enumType.underlyingType) && EnumType.listsEqual(this.enums, enumType.enums);
    }

    @Override
    public EnumType asEnum() {
        return this;
    }

    public void addEnum(String string, long l) {
        if (this.enums == null) {
            this.enums = new ArrayList();
        }
        this.enums.add(new Enum(string, l));
    }

    public int getNumEnumerates() {
        return this.enums.size();
    }

    public String getEnumName(int n) {
        return this.enums.get(n).getName();
    }

    public long getEnumValue(int n) {
        return this.enums.get(n).getValue();
    }

    public long getEnumValue(String string) {
        for (int i = 0; i < this.enums.size(); ++i) {
            Enum enum_ = this.enums.get(i);
            if (!enum_.getName().equals(string)) continue;
            return enum_.getValue();
        }
        throw new NoSuchElementException("No enumerate named \"" + string + "\" in EnumType \"" + this.getName() + "\"");
    }

    public boolean containsEnumerate(String string) {
        for (int i = 0; i < this.enums.size(); ++i) {
            if (!this.enums.get(i).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean removeEnumerate(String string) {
        for (int i = 0; i < this.enums.size(); ++i) {
            Enum enum_ = this.enums.get(i);
            if (!enum_.getName().equals(string)) continue;
            this.enums.remove(enum_);
            return true;
        }
        return false;
    }

    @Override
    public void visit(TypeVisitor typeVisitor) {
        super.visit(typeVisitor);
        this.underlyingType.visit(typeVisitor);
    }

    @Override
    Type newCVVariant(int n) {
        EnumType enumType = new EnumType(this.getName(), this.underlyingType, n);
        enumType.enums = this.enums;
        return enumType;
    }

    private static class Enum {
        String name;
        long value;

        Enum(String string, long l) {
            this.name = string;
            this.value = l;
        }

        String getName() {
            return this.name;
        }

        long getValue() {
            return this.value;
        }
    }
}

