/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class MethodBinding {
    private FunctionSymbol sym;
    private String renamedMethodName;
    private HashSet<String> aliasedNames;
    private JavaType javaReturnType;
    private List<JavaType> javaArgumentTypes;
    private boolean computedSignatureProperties;
    private boolean argumentsUseNIO;
    private boolean signatureUsesNIO;
    private boolean signatureCanUseIndirectNIO;
    private boolean signatureUsesCompoundTypeWrappers;
    private boolean signatureUsesArraysOfCompoundTypeWrappers;
    private boolean signatureUsesCVoidPointers;
    private boolean signatureUsesCPrimitivePointers;
    private boolean signatureUsesCArrays;
    private boolean signatureUsesJavaPrimitiveArrays;
    private JavaType containingType;
    private Type containingCType;
    private int thisPointerIndex = -1;

    public MethodBinding(MethodBinding methodBinding) {
        this.sym = methodBinding.sym;
        this.renamedMethodName = methodBinding.renamedMethodName;
        this.aliasedNames = new HashSet<String>(methodBinding.aliasedNames);
        this.containingType = methodBinding.containingType;
        this.containingCType = methodBinding.containingCType;
        this.javaReturnType = methodBinding.javaReturnType;
        this.javaArgumentTypes = null != methodBinding.javaArgumentTypes ? new ArrayList<JavaType>(methodBinding.javaArgumentTypes) : null;
        this.computedSignatureProperties = methodBinding.computedSignatureProperties;
        this.argumentsUseNIO = methodBinding.argumentsUseNIO;
        this.signatureUsesNIO = methodBinding.signatureUsesNIO;
        this.signatureCanUseIndirectNIO = methodBinding.signatureCanUseIndirectNIO;
        this.signatureUsesCompoundTypeWrappers = methodBinding.signatureUsesCompoundTypeWrappers;
        this.signatureUsesArraysOfCompoundTypeWrappers = methodBinding.signatureUsesArraysOfCompoundTypeWrappers;
        this.signatureUsesCVoidPointers = methodBinding.signatureUsesCVoidPointers;
        this.signatureUsesCPrimitivePointers = methodBinding.signatureUsesCPrimitivePointers;
        this.signatureUsesCArrays = methodBinding.signatureUsesCArrays;
        this.signatureUsesJavaPrimitiveArrays = methodBinding.signatureUsesJavaPrimitiveArrays;
        this.thisPointerIndex = methodBinding.thisPointerIndex;
    }

    public MethodBinding(FunctionSymbol functionSymbol) {
        this.sym = functionSymbol;
        this.aliasedNames = new HashSet();
    }

    public MethodBinding(FunctionSymbol functionSymbol, JavaType javaType, Type type) {
        this.sym = functionSymbol;
        this.containingType = javaType;
        this.containingCType = type;
        this.aliasedNames = new HashSet();
    }

    public void setJavaReturnType(JavaType javaType) {
        this.javaReturnType = javaType;
        this.computedSignatureProperties = false;
    }

    public void addJavaArgumentType(JavaType javaType) {
        if (this.javaArgumentTypes == null) {
            this.javaArgumentTypes = new ArrayList<JavaType>();
        }
        this.javaArgumentTypes.add(javaType);
        this.computedSignatureProperties = false;
    }

    public JavaType getJavaReturnType() {
        return this.javaReturnType;
    }

    public int getNumArguments() {
        return this.sym.getNumArguments();
    }

    public JavaType getJavaArgumentType(int n) {
        return this.javaArgumentTypes.get(n);
    }

    public Type getCReturnType() {
        return this.sym.getReturnType();
    }

    public Type getCArgumentType(int n) {
        return this.sym.getArgumentType(n);
    }

    public FunctionSymbol getCSymbol() {
        return this.sym;
    }

    public String getArgumentName(int n) {
        String string = this.sym.getArgumentName(n);
        if (null != string) {
            return string;
        }
        return "arg" + n;
    }

    public String getOrigName() {
        return this.sym.getName();
    }

    public String getName() {
        if (this.renamedMethodName != null) {
            return this.renamedMethodName;
        }
        return this.sym.getName();
    }

    public void renameMethodName(String string) {
        if (null != string) {
            this.renamedMethodName = string;
            this.aliasedNames.add(this.sym.getName());
        }
    }

    public void addAliasedName(String string) {
        this.aliasedNames.add(string);
    }

    public Collection<String> getAliasedNames() {
        return this.aliasedNames;
    }

    public MethodBinding replaceJavaArgumentType(int n, JavaType javaType) {
        MethodBinding methodBinding = (MethodBinding)this.clone();
        methodBinding.javaArgumentTypes = null;
        if (n < 0) {
            methodBinding.setJavaReturnType(javaType);
        } else {
            methodBinding.setJavaReturnType(this.javaReturnType);
        }
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType javaType2 = this.getJavaArgumentType(i);
            if (i == n) {
                javaType2 = javaType;
            }
            methodBinding.addJavaArgumentType(javaType2);
        }
        return methodBinding;
    }

    public boolean argumentsUseNIO() {
        this.computeSignatureProperties();
        return this.argumentsUseNIO;
    }

    public boolean signatureUsesNIO() {
        this.computeSignatureProperties();
        return this.signatureUsesNIO;
    }

    public boolean signatureCanUseIndirectNIO() {
        this.computeSignatureProperties();
        return this.signatureCanUseIndirectNIO;
    }

    public boolean signatureUsesCompoundTypeWrappers() {
        this.computeSignatureProperties();
        return this.signatureUsesCompoundTypeWrappers;
    }

    public boolean signatureUsesArraysOfCompoundTypeWrappers() {
        this.computeSignatureProperties();
        return this.signatureUsesArraysOfCompoundTypeWrappers;
    }

    public boolean needsNIOWrappingOrUnwrapping() {
        return this.signatureUsesNIO() || this.signatureUsesCompoundTypeWrappers();
    }

    public boolean signatureUsesCVoidPointers() {
        this.computeSignatureProperties();
        return this.signatureUsesCVoidPointers;
    }

    public boolean signatureUsesCPrimitivePointers() {
        this.computeSignatureProperties();
        return this.signatureUsesCPrimitivePointers;
    }

    public boolean signatureUsesCArrays() {
        this.computeSignatureProperties();
        return this.signatureUsesCArrays;
    }

    public boolean signatureUsesJavaPrimitiveArrays() {
        this.computeSignatureProperties();
        return this.signatureUsesJavaPrimitiveArrays;
    }

    protected void computeSignatureProperties() {
        Type type;
        if (this.computedSignatureProperties) {
            return;
        }
        this.argumentsUseNIO = false;
        this.signatureUsesNIO = false;
        this.signatureCanUseIndirectNIO = false;
        this.signatureUsesCompoundTypeWrappers = false;
        this.signatureUsesArraysOfCompoundTypeWrappers = false;
        this.signatureUsesCVoidPointers = false;
        this.signatureUsesCPrimitivePointers = false;
        this.signatureUsesCArrays = false;
        this.signatureUsesJavaPrimitiveArrays = false;
        if (this.javaReturnType.isCompoundTypeWrapper()) {
            this.signatureUsesCompoundTypeWrappers = true;
        }
        if (this.javaReturnType.isNIOBuffer() || this.javaReturnType.isArrayOfCompoundTypeWrappers()) {
            this.signatureUsesNIO = true;
        }
        if ((type = this.sym.getReturnType()).isArray()) {
            this.signatureUsesCArrays = true;
            if (type.asArray().getElementType().isPrimitive()) {
                this.signatureUsesCPrimitivePointers = true;
            }
        }
        if (type.isPointer()) {
            if (type.asPointer().getTargetType().isPrimitive()) {
                this.signatureUsesCPrimitivePointers = true;
            } else if (type.asPointer().getTargetType().isVoid()) {
                this.signatureUsesCVoidPointers = true;
            }
        }
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType javaType = this.getJavaArgumentType(i);
            Type type2 = this.getCArgumentType(i);
            if (javaType.isCompoundTypeWrapper()) {
                this.signatureUsesCompoundTypeWrappers = true;
            }
            if (javaType.isArrayOfCompoundTypeWrappers()) {
                this.signatureUsesArraysOfCompoundTypeWrappers = true;
            }
            if (javaType.isNIOBuffer() || javaType.isNIOBufferArray()) {
                this.signatureUsesNIO = true;
                this.argumentsUseNIO = true;
                if (javaType.isNIOBuffer()) {
                    this.signatureCanUseIndirectNIO = true;
                }
            }
            if (type2.isArray()) {
                this.signatureUsesCArrays = true;
                if (type2.asArray().getElementType().isPrimitive()) {
                    this.signatureUsesCPrimitivePointers = true;
                }
            }
            if (type2.isPointer()) {
                if (type2.asPointer().getTargetType().isPrimitive() || javaType.isCPrimitivePointerType()) {
                    this.signatureUsesCPrimitivePointers = true;
                } else if (type2.asPointer().getTargetType().isVoid()) {
                    this.signatureUsesCVoidPointers = true;
                }
            }
            if (!javaType.isPrimitiveArray()) continue;
            this.signatureUsesJavaPrimitiveArrays = true;
        }
        this.computedSignatureProperties = true;
    }

    public boolean hasContainingType() {
        return this.getContainingType() != null;
    }

    public JavaType getContainingType() {
        return this.containingType;
    }

    public Type getContainingCType() {
        return this.containingCType;
    }

    public void findThisPointer() {
        this.clearThisPointer();
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType javaType = this.getJavaArgumentType(i);
            if (javaType.equals(this.containingType)) {
                this.thisPointerIndex = i;
                break;
            }
            if (!javaType.isJNIEnv()) break;
        }
    }

    public void clearThisPointer() {
        this.thisPointerIndex = -1;
    }

    public boolean isArgumentThisPointer(int n) {
        return this.thisPointerIndex == n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof MethodBinding)) {
            return false;
        }
        MethodBinding methodBinding = (MethodBinding)object;
        if (!this.getName().equals(methodBinding.getName()) || !this.sym.getType().equals(methodBinding.sym.getType())) {
            return false;
        }
        if (!this.javaReturnType.equals(methodBinding.getJavaReturnType())) {
            return false;
        }
        if (this.containingCType != null && methodBinding.getContainingCType() != null && !this.containingCType.equals(methodBinding.getContainingCType())) {
            return false;
        }
        if (this.javaArgumentTypes.size() != methodBinding.javaArgumentTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.javaArgumentTypes.size(); ++i) {
            JavaType javaType;
            JavaType javaType2 = this.javaArgumentTypes.get(i);
            if (((Object)javaType2).equals(javaType = methodBinding.getJavaArgumentType(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getName());
        stringBuilder.append(this.sym.getType().getName(true));
        stringBuilder.append(this.getJavaReturnType().getName());
        if (this.containingCType != null) {
            stringBuilder.append(this.containingCType.getName(true));
        }
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType javaType = this.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                assert (this.getNumArguments() == 1);
                continue;
            }
            stringBuilder.append(javaType.getName());
        }
        return stringBuilder.toString().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getJavaReturnType().getName());
        stringBuilder.append(' ');
        stringBuilder.append(this.getName());
        stringBuilder.append('(');
        boolean bl = false;
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType javaType = this.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                assert (this.getNumArguments() == 1);
                continue;
            }
            if (javaType.isJNIEnv() || this.isArgumentThisPointer(i)) continue;
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(javaType.getName());
            stringBuilder.append(' ');
            stringBuilder.append(this.getArgumentName(i));
            bl = true;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public final Object clone() {
        return new MethodBinding(this);
    }

    public String getDescriptor(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        if (bl && this.hasContainingType()) {
            stringBuilder.append("Ljava/nio/ByteBuffer;");
        }
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType javaType = this.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                if (this.getNumArguments() == 1) continue;
                throw new InternalError("\"void\" argument type found in multi-argument function \"" + this + "\"");
            }
            if (javaType.isJNIEnv() || this.isArgumentThisPointer(i)) continue;
            stringBuilder.append(this.erasedTypeDescriptor(javaType, bl2, false));
            if (bl) {
                if (javaType.isNIOBuffer()) {
                    stringBuilder.append('I');
                } else if (javaType.isNIOBufferArray()) {
                    stringBuilder.append("[I");
                }
            }
            if (!javaType.isPrimitiveArray()) continue;
            stringBuilder.append('I');
        }
        stringBuilder.append(')');
        stringBuilder.append(this.erasedTypeDescriptor(this.getJavaReturnType(), bl2, false));
        return stringBuilder.toString();
    }

    protected String erasedTypeDescriptor(JavaType javaType, boolean bl, boolean bl2) {
        if (bl) {
            if (javaType.isNIOBuffer() || javaType.isPrimitiveArray()) {
                if (!bl2) {
                    return "Ljava/lang/Object;";
                }
            } else {
                if (javaType.isCompoundTypeWrapper()) {
                    return "Ljava/nio/ByteBuffer;";
                }
                if (javaType.isArrayOfCompoundTypeWrappers()) {
                    return "Ljava/nio/ByteBuffer;";
                }
            }
        }
        return javaType.getDescriptor();
    }
}

