/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.graph.font.Font;
import com.jogamp.graph.geom.AABBox;
import java.util.HashMap;
import jogamp.graph.font.FontInt;
import jogamp.graph.geom.plane.AffineTransform;
import jogamp.graph.geom.plane.Path2D;

public class TypecastGlyph
implements FontInt.GlyphInt {
    public static final short INVALID_ID = -1;
    public static final short MAX_ID = -2;
    private final Font font;
    char symbol;
    short id;
    int advance;
    Metrics metrics;
    protected Path2D path;
    protected Path2D pathSized;
    protected float numberSized;

    protected TypecastGlyph(Font font, char c) {
        this.font = font;
        this.symbol = c;
    }

    protected TypecastGlyph(Font font, char c, short s, AABBox aABBox, int n, Path2D path2D) {
        this.font = font;
        this.symbol = c;
        this.advance = n;
        this.init(s, aABBox, n);
        this.path = path2D;
        this.pathSized = null;
        this.numberSized = 0.0f;
    }

    void init(short s, AABBox aABBox, int n) {
        this.id = s;
        this.advance = n;
        this.metrics = new Metrics(this.font, aABBox, this.advance);
    }

    public void reset(Path2D path2D) {
        this.path = path2D;
        this.metrics.reset();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public char getSymbol() {
        return this.symbol;
    }

    AABBox getBBoxUnsized() {
        return this.metrics.getBBox();
    }

    public AABBox getBBox() {
        return this.metrics.getBBox();
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public short getID() {
        return this.id;
    }

    public float getScale(float f) {
        return this.metrics.getScale(f);
    }

    @Override
    public AABBox getBBox(float f) {
        float f2 = this.getScale(f);
        AABBox aABBox = this.getBBox().clone();
        aABBox.scale(f2);
        return aABBox;
    }

    protected void addAdvance(float f, float f2) {
        this.metrics.addAdvance(f, f2);
    }

    @Override
    public float getAdvance(float f, boolean bl) {
        return this.metrics.getAdvance(f, bl);
    }

    @Override
    public Path2D getPath() {
        return this.path;
    }

    @Override
    public Path2D getPath(float f) {
        float f2 = this.getScale(f);
        if (this.numberSized != f2) {
            this.numberSized = f2;
            this.pathSized = AffineTransform.getScaleInstance(null, f2, f2).createTransformedShape(this.getPath());
        }
        return this.pathSized;
    }

    public class Advance {
        final Font font;
        final float advance;
        HashMap<Float, Float> size2advance = new HashMap();

        public Advance(Font font, float f) {
            this.font = font;
            this.advance = f;
        }

        public void reset() {
            this.size2advance.clear();
        }

        public float getScale(float f) {
            return this.font.getMetrics().getScale(f);
        }

        public void add(float f, float f2) {
            this.size2advance.put(Float.valueOf(f2), Float.valueOf(f));
        }

        public float get(float f, boolean bl) {
            Float f2 = this.size2advance.get(Float.valueOf(f));
            if (null == f2) {
                float f3 = this.advance * this.getScale(f);
                if (!bl) {
                    f3 = (int)(f3 + 0.5f);
                }
                this.size2advance.put(Float.valueOf(f), Float.valueOf(f3));
                return f3;
            }
            return f2.floatValue();
        }

        public String toString() {
            return "\nAdvance:\n  advance: " + this.advance + "\n advances: \n" + this.size2advance;
        }
    }

    public class Metrics {
        AABBox bbox;
        Advance advance;

        public Metrics(Font font, AABBox aABBox, float f) {
            this.bbox = aABBox;
            this.advance = new Advance(font, f);
        }

        public void reset() {
            this.advance.reset();
        }

        public float getScale(float f) {
            return this.advance.getScale(f);
        }

        public AABBox getBBox() {
            return this.bbox;
        }

        public void addAdvance(float f, float f2) {
            this.advance.add(f, f2);
        }

        public float getAdvance(float f, boolean bl) {
            return this.advance.get(f, bl);
        }

        public String toString() {
            return "\nMetrics:\n  bbox: " + this.bbox + this.advance;
        }
    }
}

