/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.Shape3DCompileRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.TransformGroupRetained;

class CompileState {
    private final HashMap<AppearanceRetained, AppearanceRetained> knownAppearances = new HashMap();
    int numShapes = 0;
    private final HashMap<AppearanceRetained, Vector<Shape3DRetained>> shapeLists = new HashMap();
    int numMergeSets = 0;
    int numMergeShapes = 0;
    static final int BOUNDS_READ = 1;
    static final int GEOMETRY_READ = 2;
    boolean keepTG = false;
    boolean needNormalsTransform = false;
    TransformGroupRetained staticTransform = null;
    GroupRetained parentGroup = null;
    int numTransformGroups = 0;
    int numStaticTransformGroups = 0;
    int numMergedTransformGroups = 0;
    int numGroups = 0;
    int numMergedGroups = 0;
    int numShapesWSharedGeom = 0;
    int numShapesWStaticTG = 0;
    int numLinks = 0;
    int numSwitches = 0;
    int numOrderedGroups = 0;
    int numMorphs = 0;

    CompileState() {
    }

    AppearanceRetained getAppearance(AppearanceRetained appearanceRetained) {
        if (appearanceRetained.map == this && appearanceRetained.mapAppearance != null) {
            return appearanceRetained.mapAppearance;
        }
        AppearanceRetained appearanceRetained2 = this.knownAppearances.get(appearanceRetained);
        if (appearanceRetained2 == null) {
            this.knownAppearances.put(appearanceRetained, appearanceRetained);
            appearanceRetained2 = appearanceRetained;
        }
        appearanceRetained.map = this;
        appearanceRetained.mapAppearance = appearanceRetained2;
        return appearanceRetained2;
    }

    void addShape(Shape3DRetained shape3DRetained) {
        if (this.parentGroup != null) {
            Vector<Shape3DRetained> vector = this.shapeLists.get(shape3DRetained.appearance);
            if (vector == null) {
                vector = new Vector();
                this.shapeLists.put(shape3DRetained.appearance, vector);
            }
            GeometryRetained geometryRetained = null;
            for (int i = 0; geometryRetained == null && i < shape3DRetained.geometryList.size(); ++i) {
                geometryRetained = shape3DRetained.geometryList.get(i);
            }
            if (shape3DRetained.parent instanceof GroupRetained && ((GroupRetained)shape3DRetained.parent).isStaticChildren() && geometryRetained.geoType < 15) {
                vector.add(shape3DRetained);
            }
        }
    }

    void printStats() {
        System.err.println("numTransformGroups= " + this.numTransformGroups);
        System.err.println("numStaticTransformGroups= " + this.numStaticTransformGroups);
        System.err.println("numMergedTransformGroups= " + this.numMergedTransformGroups);
        System.err.println("numGroups= " + this.numGroups);
        System.err.println("numMergedGroups= " + this.numMergedGroups);
        System.err.println("numShapes= " + this.numShapes);
        System.err.println("numShapesWStaticTG= " + this.numShapesWStaticTG);
        System.err.println("numMergeShapes= " + this.numMergeShapes);
        System.err.println("numMergeSets= " + this.numMergeSets);
        System.err.println("numLinks= " + this.numLinks);
        System.err.println("numSwitches= " + this.numSwitches);
        System.err.println("numOrderedGroups= " + this.numOrderedGroups);
        System.err.println("numMorphs= " + this.numMorphs);
    }

    void doShapeMerge() {
        if (this.shapeLists != null) {
            Collection<Vector<Shape3DRetained>> collection = this.shapeLists.values();
            Iterator<Vector<Shape3DRetained>> iterator = collection.iterator();
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                Vector<Shape3DRetained> vector = iterator.next();
                int n3 = vector.size();
                Object[] objectArray = new Shape3DRetained[n3];
                vector.copyInto(objectArray);
                Shape3DRetained[] shape3DRetainedArray = new Shape3DRetained[n3];
                for (int i = 0; i < n3; ++i) {
                    int n4;
                    if (objectArray[i] == null) continue;
                    GeometryRetained geometryRetained = null;
                    for (n = 0; geometryRetained == null && n < ((Shape3DRetained)objectArray[i]).geometryList.size(); ++n) {
                        geometryRetained = ((Shape3DRetained)objectArray[i]).geometryList.get(n);
                    }
                    if (geometryRetained == null || !(geometryRetained instanceof GeometryArrayRetained)) continue;
                    int n5 = 0;
                    Object object = objectArray[i];
                    GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometryRetained;
                    shape3DRetainedArray[n5++] = object;
                    n2 = this.getCompileFlags((Shape3DRetained)object);
                    for (int j = i + 1; j < n3; ++j) {
                        if (objectArray[j] == null) continue;
                        geometryRetained = null;
                        for (n = 0; geometryRetained == null && n < ((Shape3DRetained)objectArray[j]).geometryList.size(); ++n) {
                            geometryRetained = ((Shape3DRetained)objectArray[j]).geometryList.get(n);
                        }
                        if (geometryRetained == null || !((Shape3DRetained)objectArray[j]).isEquivalent((Shape3DRetained)object) || !geometryRetained.isEquivalenceClass(geometryArrayRetained) || ((GeometryArrayRetained)geometryRetained).vertexFormat != geometryArrayRetained.vertexFormat) continue;
                        shape3DRetainedArray[n5++] = objectArray[j];
                        n2 |= this.getCompileFlags((Shape3DRetained)objectArray[j]);
                        objectArray[j] = null;
                    }
                    if (n5 <= 1) continue;
                    GroupRetained groupRetained = (GroupRetained)shape3DRetainedArray[0].parent;
                    for (n4 = 0; n4 < n5; ++n4) {
                        Shape3DRetained shape3DRetained = shape3DRetainedArray[n4];
                        boolean bl = false;
                        int n6 = groupRetained.numChildren();
                        for (int j = 0; j < n6 && !bl; ++j) {
                            if (groupRetained.getChild((int)j).retained != shape3DRetained) continue;
                            bl = true;
                            groupRetained.removeChild(j);
                        }
                        if (bl) continue;
                        System.err.println("ShapeSet.add(): Can't remove shape from parent, can't find shape!");
                    }
                    object = new Shape3DCompileRetained(shape3DRetainedArray, n5, n2);
                    if (J3dDebug.debug && J3dDebug.doDebug(3, 3)) {
                        System.err.println("Dest is " + this.parentGroup);
                        System.err.println("Compile Shape " + object);
                        System.err.println(((Shape3DRetained)object).geometryList.size() + " geoemtryList");
                        for (n4 = 0; n4 < ((Shape3DRetained)object).geometryList.size(); ++n4) {
                            GeometryRetained geometryRetained2 = ((Shape3DRetained)object).geometryList.get(n4);
                            if (geometryRetained2 == null) continue;
                            System.err.println("\t Geo_type = " + geometryRetained2.geoType);
                        }
                        System.err.println(n5 + " Shapes were merged ");
                        for (n4 = 0; n4 < n5; ++n4) {
                            System.err.println("\t" + shape3DRetainedArray[n4]);
                        }
                    }
                    ((SceneGraphObjectRetained)object).setSource(shape3DRetainedArray[0].source);
                    ++this.numMergeSets;
                    this.numMergeShapes += n5;
                    this.parentGroup.addChild((Node)((Shape3DRetained)object).source);
                }
            }
        }
        this.shapeLists.clear();
    }

    int getCompileFlags(Shape3DRetained shape3DRetained) {
        int n = 0;
        if (shape3DRetained.allowIntersect() || shape3DRetained.source.getCapability(12) || shape3DRetained.boundsAutoCompute && shape3DRetained.source.getCapability(3)) {
            n |= 2;
        }
        return n;
    }
}

