/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ToolkitLock;
import jogamp.nativewindow.NativeWindowFactoryImpl;

public class DefaultGraphicsDevice
implements Cloneable,
AbstractGraphicsDevice {
    private static final String separator = "_";
    private String type;
    protected String connection;
    protected int unitID;
    protected String uniqueID;
    protected long handle;
    protected ToolkitLock toolkitLock;

    public DefaultGraphicsDevice(String string, String string2, int n) {
        this.type = string;
        this.connection = string2;
        this.unitID = n;
        this.uniqueID = DefaultGraphicsDevice.getUniqueID(string, string2, n);
        this.handle = 0L;
        this.toolkitLock = NativeWindowFactory.getDefaultToolkitLock(string);
    }

    public DefaultGraphicsDevice(String string, String string2, int n, long l) {
        this.type = string;
        this.connection = string2;
        this.unitID = n;
        this.uniqueID = DefaultGraphicsDevice.getUniqueID(string, string2, n);
        this.handle = l;
        this.toolkitLock = NativeWindowFactory.getDefaultToolkitLock(string, l);
    }

    public DefaultGraphicsDevice(String string, String string2, int n, long l, ToolkitLock toolkitLock) {
        this.type = string;
        this.connection = string2;
        this.unitID = n;
        this.uniqueID = DefaultGraphicsDevice.getUniqueID(string, string2, n);
        this.handle = l;
        this.toolkitLock = null != toolkitLock ? toolkitLock : NativeWindowFactoryImpl.getNullToolkitLock();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NativeWindowException(cloneNotSupportedException);
        }
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final String getConnection() {
        return this.connection;
    }

    @Override
    public final int getUnitID() {
        return this.unitID;
    }

    @Override
    public final String getUniqueID() {
        return this.uniqueID;
    }

    @Override
    public final long getHandle() {
        return this.handle;
    }

    @Override
    public final void lock() {
        this.toolkitLock.lock();
    }

    @Override
    public final void validateLocked() throws RuntimeException {
        this.toolkitLock.validateLocked();
    }

    @Override
    public final void unlock() {
        this.toolkitLock.unlock();
    }

    @Override
    public boolean open() {
        return false;
    }

    @Override
    public boolean close() {
        this.toolkitLock.dispose();
        if (0L != this.handle) {
            this.handle = 0L;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type " + this.getType() + ", connection " + this.getConnection() + ", unitID " + this.getUnitID() + ", handle 0x" + Long.toHexString(this.getHandle()) + ", " + this.toolkitLock + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setToolkitLock(ToolkitLock toolkitLock) {
        ToolkitLock toolkitLock2 = this.toolkitLock;
        toolkitLock2.lock();
        try {
            this.toolkitLock = null == toolkitLock ? NativeWindowFactoryImpl.getNullToolkitLock() : toolkitLock;
        }
        finally {
            toolkitLock2.unlock();
        }
    }

    public final ToolkitLock getToolkitLock() {
        return this.toolkitLock;
    }

    protected static String getUniqueID(String string, String string2, int n) {
        return (string + separator + string2 + separator + n).intern();
    }
}

