/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image.readers;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.sunflow.image.Bitmap;
import org.sunflow.image.BitmapReader;
import org.sunflow.image.Color;
import org.sunflow.image.formats.BitmapG8;
import org.sunflow.image.formats.BitmapRGB8;
import org.sunflow.image.formats.BitmapRGBA8;

public class TGABitmapReader
implements BitmapReader {
    private static final int[] CHANNEL_INDEX = new int[]{2, 1, 0, 3};

    public Bitmap load(String string, boolean bl) throws IOException, BitmapReader.BitmapFormatException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        InputStream inputStream;
        try {
            inputStream = new URL(string).openStream();
        }
        catch (MalformedURLException malformedURLException) {
            inputStream = new FileInputStream(string);
        }
        inputStream = new BufferedInputStream(inputStream);
        byte[] byArray = new byte[4];
        int n6 = inputStream.read();
        int n7 = inputStream.read();
        if (n7 != 0) {
            throw new BitmapReader.BitmapFormatException(String.format("Colormapping (type: %d) is unsupported", n7));
        }
        int n8 = inputStream.read();
        inputStream.read();
        inputStream.read();
        inputStream.read();
        inputStream.read();
        inputStream.read();
        inputStream.read();
        inputStream.read();
        inputStream.read();
        inputStream.read();
        int n9 = inputStream.read();
        n9 |= inputStream.read() << 8;
        int n10 = inputStream.read();
        n10 |= inputStream.read() << 8;
        int n11 = inputStream.read();
        int n12 = n11 / 8;
        int n13 = inputStream.read();
        if (n6 != 0) {
            inputStream.skip(n6);
        }
        byte[] byArray2 = new byte[n9 * n10 * n12];
        if (n8 == 2 || n8 == 3) {
            if (n12 != 1 && n12 != 3 && n12 != 4) {
                throw new BitmapReader.BitmapFormatException(String.format("Invalid bit depth in uncompressed TGA: %d", n11));
            }
            for (n5 = 0; n5 < byArray2.length; n5 += n12) {
                inputStream.read(byArray, 0, n12);
                for (n4 = 0; n4 < n12; ++n4) {
                    byArray2[n5 + TGABitmapReader.CHANNEL_INDEX[n4]] = byArray[n4];
                }
            }
        } else if (n8 == 10) {
            if (n12 != 3 && n12 != 4) {
                throw new BitmapReader.BitmapFormatException(String.format("Invalid bit depth in run-length encoded TGA: %d", n11));
            }
            n5 = 0;
            while (n5 < byArray2.length) {
                n4 = inputStream.read();
                n3 = 1 + (n4 & 0x7F);
                if ((n4 & 0x80) != 0) {
                    inputStream.read(byArray, 0, n12);
                    for (n2 = 0; n2 < n3; ++n2) {
                        for (n = 0; n < n12; ++n) {
                            byArray2[n5 + TGABitmapReader.CHANNEL_INDEX[n]] = byArray[n];
                        }
                        n5 += n12;
                    }
                    continue;
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    inputStream.read(byArray, 0, n12);
                    for (n = 0; n < n12; ++n) {
                        byArray2[n5 + TGABitmapReader.CHANNEL_INDEX[n]] = byArray[n];
                    }
                    n5 += n12;
                }
            }
        } else {
            throw new BitmapReader.BitmapFormatException(String.format("Unsupported TGA image type: %d", n8));
        }
        if (!bl) {
            for (n5 = 0; n5 < byArray2.length; n5 += n12) {
                for (n4 = 0; n4 < 3 && n4 < n12; ++n4) {
                    byArray2[n5 + n4] = Color.NATIVE_SPACE.rgbToLinear(byArray2[n5 + n4]);
                }
            }
        }
        if ((n13 & 0x20) == 32) {
            n4 = 0;
            for (n5 = 0; n5 < n10 / 2; ++n5) {
                n3 = n12 * (n10 - n5 - 1) * n9;
                for (n2 = 0; n2 < n9; ++n2) {
                    for (n = 0; n < n12; ++n) {
                        byte by = byArray2[n4 + n];
                        byArray2[n4 + n] = byArray2[n3 + n];
                        byArray2[n3 + n] = by;
                    }
                    n4 += n12;
                    n3 += n12;
                }
            }
        }
        inputStream.close();
        switch (n12) {
            case 1: {
                return new BitmapG8(n9, n10, byArray2);
            }
            case 3: {
                return new BitmapRGB8(n9, n10, byArray2);
            }
            case 4: {
                return new BitmapRGBA8(n9, n10, byArray2);
            }
        }
        throw new BitmapReader.BitmapFormatException("Inconsistent code in TGA reader");
    }
}

