/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.shader;

import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.core.Texture;
import org.sunflow.core.shader.ShinyDiffuseShader;
import org.sunflow.image.Color;
import org.sunflow.math.Vector3;

public class TexturedShinyDiffuseShader
extends ShinyDiffuseShader {
    private Texture tex = null;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        String string = parameterList.getString("texture", null);
        if (string != null) {
            this.tex = sunflowAPI.getTextureCache().getTexture(sunflowAPI.resolveTextureFilename(string), false);
        }
        return this.tex != null && super.update(parameterList, sunflowAPI);
    }

    public Color getDiffuse(ShadingState shadingState) {
        return this.tex.getPixel(shadingState.getUV().x, shadingState.getUV().y);
    }

    public Color getRadiance(ShadingState shadingState) {
        Color color;
        if (this.isOpaque() || (color = this.getOpacity(shadingState)).isWhite()) {
            return super.getRadiance(shadingState);
        }
        shadingState.faceforward();
        shadingState.initLightSamples();
        shadingState.initCausticSamples();
        Color color2 = Color.sub(Color.WHITE, color);
        Vector3 vector3 = shadingState.getRay().getDirection();
        Color color3 = shadingState.traceRefraction(new Ray(shadingState.getPoint(), vector3), 0);
        color2.mul(color3);
        if (!shadingState.includeSpecular() || color.isBlack()) {
            return color2;
        }
        float f = shadingState.getCosND();
        float f2 = 2.0f * f;
        Vector3 vector32 = new Vector3();
        vector32.x = f2 * shadingState.getNormal().x + shadingState.getRay().getDirection().x;
        vector32.y = f2 * shadingState.getNormal().y + shadingState.getRay().getDirection().y;
        vector32.z = f2 * shadingState.getNormal().z + shadingState.getRay().getDirection().z;
        Ray ray = new Ray(shadingState.getPoint(), vector32);
        f = 1.0f - f;
        float f3 = f * f;
        float f4 = f3 * f3 * f;
        Color color4 = Color.white();
        Color color5 = Color.sub(Color.WHITE, color).mul(this.getShininess());
        color4.sub(color5);
        color4.mul(f4);
        color4.add(color5);
        return color2.add(color4.mul(shadingState.traceReflection(ray, 0)));
    }

    public boolean isOpaque() {
        return !this.tex.isTransparent();
    }

    public Color getOpacity(ShadingState shadingState) {
        return this.tex.getOpacity(shadingState.getUV().x, shadingState.getUV().y);
    }
}

