/*
 Copyright (c) 2010, Yahoo! Inc. All rights reserved.
 Code licensed under the BSD License:
 http://developer.yahoo.com/yui/license.html
 version: 3.3.0
 build: 3167
 */
YUI.add('datasource-local',function(Y){var LANG=Y.Lang,DSLocal=function(){DSLocal.superclass.constructor.apply(this,arguments);};Y.mix(DSLocal,{NAME:"dataSourceLocal",ATTRS:{source:{value:null}},_tId:0,transactions:{},issueCallback:function(e,caller){var error=(e.error||e.response.error);if(error){e.error=e.error||e.response.error;caller.fire("error",e);}
if(e.callback){var callbackFunc=(error&&e.callback.failure)||e.callback.success;if(callbackFunc){callbackFunc(e);}}}});Y.extend(DSLocal,Y.Base,{initializer:function(config){this._initEvents();},_initEvents:function(){this.publish("request",{defaultFn:Y.bind("_defRequestFn",this),queuable:true});this.publish("data",{defaultFn:Y.bind("_defDataFn",this),queuable:true});this.publish("response",{defaultFn:Y.bind("_defResponseFn",this),queuable:true});},_defRequestFn:function(e){var data=this.get("source");if(LANG.isUndefined(data)){e.error=new Error("Local source undefined");}
this.fire("data",Y.mix({data:data},e));},_defDataFn:function(e){var data=e.data,meta=e.meta,response={results:(LANG.isArray(data))?data:[data],meta:(meta)?meta:{}};this.fire("response",Y.mix({response:response},e));},_defResponseFn:function(e){DSLocal.issueCallback(e,this);},sendRequest:function(request){request=request||{};var tId=DSLocal._tId++;this.fire("request",{tId:tId,request:request.request,callback:request.callback,cfg:request.cfg||{}});return tId;}});Y.namespace("DataSource").Local=DSLocal;},'3.3.0',{requires:['base']});YUI.add('datasource-io',function(Y){var DSIO=function(){DSIO.superclass.constructor.apply(this,arguments);};Y.mix(DSIO,{NAME:"dataSourceIO",ATTRS:{io:{value:Y.io,cloneDefaultValue:false},ioConfig:{value:null}}});Y.extend(DSIO,Y.DataSource.Local,{initializer:function(config){this._queue={interval:null,conn:null,requests:[]};},successHandler:function(id,response,e){var defIOConfig=this.get("ioConfig");delete Y.DataSource.Local.transactions[e.tId];this.fire("data",Y.mix({data:response},e));if(defIOConfig&&defIOConfig.on&&defIOConfig.on.success){defIOConfig.on.success.apply(defIOConfig.context||Y,arguments);}},failureHandler:function(id,response,e){var defIOConfig=this.get("ioConfig");delete Y.DataSource.Local.transactions[e.tId];e.error=new Error("IO data failure");this.fire("data",Y.mix({data:response},e));if(defIOConfig&&defIOConfig.on&&defIOConfig.on.failure){defIOConfig.on.failure.apply(defIOConfig.context||Y,arguments);}},_queue:null,_defRequestFn:function(e){var uri=this.get("source"),io=this.get("io"),defIOConfig=this.get("ioConfig"),request=e.request,cfg=Y.merge(defIOConfig,e.cfg,{on:Y.merge(defIOConfig,{success:this.successHandler,failure:this.failureHandler}),context:this,"arguments":e});if(Y.Lang.isString(request)){if(cfg.method&&(cfg.method.toUpperCase()==="POST")){cfg.data=cfg.data?cfg.data+request:request;}
else{uri+=request;}}
Y.DataSource.Local.transactions[e.tId]=io(uri,cfg);return e.tId;}});Y.DataSource.IO=DSIO;},'3.3.0',{requires:['datasource-local','io-base']});YUI.add('datasource-get',function(Y){var DSGet=function(){DSGet.superclass.constructor.apply(this,arguments);};Y.DataSource.Get=Y.extend(DSGet,Y.DataSource.Local,{_defRequestFn:function(e){var uri=this.get("source"),get=this.get("get"),guid=Y.guid().replace(/\-/g,'_'),generateRequest=this.get("generateRequestCallback"),o;this._last=guid;YUI.Env.DataSource.callbacks[guid]=Y.bind(function(response){delete YUI.Env.DataSource.callbacks[guid];delete Y.DataSource.Local.transactions[e.tId];var process=this.get('asyncMode')!=="ignoreStaleResponses"||this._last===guid;if(process){this.fire("data",Y.mix({data:response},e));}else{}},this);uri+=e.request+generateRequest.call(this,guid);Y.DataSource.Local.transactions[e.tId]=get.script(uri,{autopurge:true,onFailure:Y.bind(function(e,o){delete YUI.Env.DataSource.callbacks[guid];delete Y.DataSource.Local.transactions[e.tId];e.error=new Error(o.msg||"Script node data failure");this.fire("data",e);},this,e),onTimeout:Y.bind(function(e,o){delete YUI.Env.DataSource.callbacks[guid];delete Y.DataSource.Local.transactions[e.tId];e.error=new Error(o.msg||"Script node data timeout");this.fire("data",e);},this,e)});return e.tId;},_generateRequest:function(guid){return"&"+this.get("scriptCallbackParam")+"=YUI.Env.DataSource.callbacks."+guid;}},{NAME:"dataSourceGet",ATTRS:{get:{value:Y.Get,cloneDefaultValue:false},asyncMode:{value:"allowAll"},scriptCallbackParam:{value:"callback"},generateRequestCallback:{value:function(){return this._generateRequest.apply(this,arguments);}}}});YUI.namespace("Env.DataSource.callbacks");},'3.3.0',{requires:['datasource-local','get']});YUI.add('datasource-function',function(Y){var LANG=Y.Lang,DSFn=function(){DSFn.superclass.constructor.apply(this,arguments);};Y.mix(DSFn,{NAME:"dataSourceFunction",ATTRS:{source:{validator:LANG.isFunction}}});Y.extend(DSFn,Y.DataSource.Local,{_defRequestFn:function(e){var fn=this.get("source"),response;if(fn){try{response=fn(e.request,this,e);this.fire("data",Y.mix({data:response},e));}
catch(error){e.error=error;this.fire("data",e);}}
else{e.error=new Error("Function data failure");this.fire("data",e);}
return e.tId;}});Y.DataSource.Function=DSFn;},'3.3.0',{requires:['datasource-local']});YUI.add('datasource-cache',function(Y){var DataSourceCacheExtension=function(){};Y.mix(DataSourceCacheExtension,{NS:"cache",NAME:"dataSourceCacheExtension"});DataSourceCacheExtension.prototype={initializer:function(config){this.doBefore("_defRequestFn",this._beforeDefRequestFn);this.doBefore("_defResponseFn",this._beforeDefResponseFn);},_beforeDefRequestFn:function(e){var entry=(this.retrieve(e.request))||null;if(entry&&entry.response){this.get("host").fire("response",Y.mix(entry,e));return new Y.Do.Halt("DataSourceCache extension halted _defRequestFn");}},_beforeDefResponseFn:function(e){if(e.response&&!e.cached){this.add(e.request,e.response);}}};Y.namespace("Plugin").DataSourceCacheExtension=DataSourceCacheExtension;function DataSourceCache(config){var cache=config&&config.cache?config.cache:Y.Cache,tmpclass=Y.Base.create("dataSourceCache",cache,[Y.Plugin.Base,Y.Plugin.DataSourceCacheExtension]),tmpinstance=new tmpclass(config);tmpclass.NS="tmpClass";return tmpinstance;}
Y.mix(DataSourceCache,{NS:"cache",NAME:"dataSourceCache"});Y.namespace("Plugin").DataSourceCache=DataSourceCache;},'3.3.0',{requires:['datasource-local','cache-base']});YUI.add('datasource-jsonschema',function(Y){var DataSourceJSONSchema=function(){DataSourceJSONSchema.superclass.constructor.apply(this,arguments);};Y.mix(DataSourceJSONSchema,{NS:"schema",NAME:"dataSourceJSONSchema",ATTRS:{schema:{}}});Y.extend(DataSourceJSONSchema,Y.Plugin.Base,{initializer:function(config){this.doBefore("_defDataFn",this._beforeDefDataFn);},_beforeDefDataFn:function(e){var data=e.data?(e.data.responseText?e.data.responseText:e.data):e.data,response=Y.DataSchema.JSON.apply.call(this,this.get("schema"),data);if(!response){response={meta:{},results:data};}
this.get("host").fire("response",Y.mix({response:response},e));return new Y.Do.Halt("DataSourceJSONSchema plugin halted _defDataFn");}});Y.namespace('Plugin').DataSourceJSONSchema=DataSourceJSONSchema;},'3.3.0',{requires:['datasource-local','plugin','dataschema-json']});YUI.add('datasource-xmlschema',function(Y){var DataSourceXMLSchema=function(){DataSourceXMLSchema.superclass.constructor.apply(this,arguments);};Y.mix(DataSourceXMLSchema,{NS:"schema",NAME:"dataSourceXMLSchema",ATTRS:{schema:{}}});Y.extend(DataSourceXMLSchema,Y.Plugin.Base,{initializer:function(config){this.doBefore("_defDataFn",this._beforeDefDataFn);},_beforeDefDataFn:function(e){var data=(Y.DataSource.IO&&(this.get("host")instanceof Y.DataSource.IO)&&e.data.responseXML&&(e.data.responseXML.nodeType===9))?e.data.responseXML:e.data,response=Y.DataSchema.XML.apply.call(this,this.get("schema"),data);if(!response){response={meta:{},results:data};}
this.get("host").fire("response",Y.mix({response:response},e));return new Y.Do.Halt("DataSourceXMLSchema plugin halted _defDataFn");}});Y.namespace('Plugin').DataSourceXMLSchema=DataSourceXMLSchema;},'3.3.0',{requires:['datasource-local','plugin','dataschema-xml']});YUI.add('datasource-arrayschema',function(Y){var DataSourceArraySchema=function(){DataSourceArraySchema.superclass.constructor.apply(this,arguments);};Y.mix(DataSourceArraySchema,{NS:"schema",NAME:"dataSourceArraySchema",ATTRS:{schema:{}}});Y.extend(DataSourceArraySchema,Y.Plugin.Base,{initializer:function(config){this.doBefore("_defDataFn",this._beforeDefDataFn);},_beforeDefDataFn:function(e){var data=(Y.DataSource.IO&&(this.get("host")instanceof Y.DataSource.IO)&&Y.Lang.isString(e.data.responseText))?e.data.responseText:e.data,response=Y.DataSchema.Array.apply.call(this,this.get("schema"),data);if(!response){response={meta:{},results:data};}
this.get("host").fire("response",Y.mix({response:response},e));return new Y.Do.Halt("DataSourceArraySchema plugin halted _defDataFn");}});Y.namespace('Plugin').DataSourceArraySchema=DataSourceArraySchema;},'3.3.0',{requires:['datasource-local','plugin','dataschema-array']});YUI.add('datasource-textschema',function(Y){var DataSourceTextSchema=function(){DataSourceTextSchema.superclass.constructor.apply(this,arguments);};Y.mix(DataSourceTextSchema,{NS:"schema",NAME:"dataSourceTextSchema",ATTRS:{schema:{}}});Y.extend(DataSourceTextSchema,Y.Plugin.Base,{initializer:function(config){this.doBefore("_defDataFn",this._beforeDefDataFn);},_beforeDefDataFn:function(e){var data=(Y.DataSource.IO&&(this.get("host")instanceof Y.DataSource.IO)&&Y.Lang.isString(e.data.responseText))?e.data.responseText:e.data,response=Y.DataSchema.Text.apply.call(this,this.get("schema"),data);if(!response){response={meta:{},results:data};}
this.get("host").fire("response",Y.mix({response:response},e));return new Y.Do.Halt("DataSourceTextSchema plugin halted _defDataFn");}});Y.namespace('Plugin').DataSourceTextSchema=DataSourceTextSchema;},'3.3.0',{requires:['datasource-local','plugin','dataschema-text']});YUI.add('datasource-polling',function(Y){function Pollable(){this._intervals={};}
Pollable.prototype={_intervals:null,setInterval:function(msec,callback){var x=Y.later(msec,this,this.sendRequest,[callback],true);this._intervals[x.id]=x;return x.id;},clearInterval:function(id,key){id=key||id;if(this._intervals[id]){this._intervals[id].cancel();delete this._intervals[id];}},clearAllIntervals:function(){Y.each(this._intervals,this.clearInterval,this);}};Y.augment(Y.DataSource.Local,Pollable);},'3.3.0',{requires:['datasource-local']});YUI.add('datasource',function(Y){},'3.3.0',{use:['datasource-local','datasource-io','datasource-get','datasource-function','datasource-cache','datasource-jsonschema','datasource-xmlschema','datasource-arrayschema','datasource-textschema','datasource-polling']});
