<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2009 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/
require_once('modules/DynamicFields/templates/Fields/TemplateText.php'); 
require_once('modules/DynamicFields/templates/Fields/TemplateField.php');
class TemplateRelatedTextField extends TemplateText{
    var $type = 'relate';
    //ext1 is the name field
    //ext2 is the related module
    
    function get_html_edit(){
        $this->prepare();
        $name = $this->name .'_name';
        $value_name = strtoupper('{'.$name.'}');
        $id = $this->name ;
        $value_id = strtoupper('{'.$id .'}');
        return "<input type='text' name='$name' id='$name' size='".$this->size."' readonly value='$value_name'><input type='button' onclick='open_popup(\"{". strtoupper($this->name). "_MODULE}\", 600, 400,\" \", true, false, {ENCODED_". strtoupper($this->name). "_POPUP_REQUEST_DATA})' type='button'  class='button' value='{APP.LBL_SELECT_BUTTON_LABEL}' ><input type='hidden' name='$id' value='$value_id'>";
    }

    function get_html_detail(){
        $name = $this->name .'_name';
        $value_name = strtoupper('{'.$name.'}');
        $id = $this->name ;
        $value_id = strtoupper('{'.$id .'}');
        
        return "<a href='index.php?module=$this->ext2&action=DetailView&record={$value_id}'>{$value_name}</a>" ;    
    }
    
    function get_html_list(){
        if(isset($this->bean)){
            $name = $this->bean->object_name . '.'. $this->ext1;
        }else{
            $name = $this->ext1;    
        }
        return '{'. strtoupper($name) . '}';    
    }

    function get_html_search(){
        $searchable=array();
        $def = $this->bean->field_name_map[$this->name];



        if(!empty($def['id_name']) && in_array($def['id_name'], $searchable)){
            $name = $def['id_name'];
            return "<select size='3' name='{$name}[]' tabindex='1' multiple='multiple'>{".strtoupper($name). "_FILTER}</select>";   
        }
        //return 'NOT AVAILABLE';
        return $this->get_html_edit();
    }   

    function get_xtpl_search(){
        $searchable=array();
        $def = $this->bean->field_name_map[$this->name];



        $returnXTPL = array();
        if(!empty($def['id_name']) && in_array($def['id_name'], $searchable)){
            $name = $def['id_name'];
            $team_list = '';
            foreach(get_team_array() as $id=>$team){
                $selected = '';
                
                if(!empty($_REQUEST[$name]) && is_array($_REQUEST[$name]) && in_array($id, $_REQUEST[$name])){
                    $selected = 'selected';
                }
                $team_list .= "<option  $selected value='$id'>$team</option>";
            }
            $returnXTPL[strtoupper($name). '_FILTER'] = $team_list;
        } else {
            $id = $this->name;
            $name = $this->name .'_name';
            $module = $this->ext2;
            $popup_request_data = array(
                                        'call_back_function' => 'set_return',
                                        'form_name' => 'search_form',
                                        'field_to_name_array' => array(
                                        'id' => $this->name,
                                        $this->ext1 => $name,
                                    ),
            );
        
            $json = getJSONobj();
            $encoded_popup_request_data = $json->encode($popup_request_data);
            $returnXTPL['ENCODED_'.strtoupper($id).'_POPUP_REQUEST_DATA'] = $encoded_popup_request_data;
            $returnXTPL[strtoupper($id).'_MODULE'] = $module;

            if(isset( $_REQUEST[$name])){
               $returnXTPL[strtoupper($name)] =  $_REQUEST[$name];
            }
            if(isset( $_REQUEST[$id])){
               $returnXTPL[strtoupper($id)] =  $_REQUEST[$id];
            }
        }
        return $returnXTPL; 
    }


    function get_xtpl_edit(){
    global $beanList;
        
        $name = $this->name .'_name';
        $id = $this->name;
        $module = $this->ext2;
        $returnXTPL = array();
        $popup_request_data = array(
            'call_back_function' => 'set_return',
            'form_name' => 'EditView',
            'field_to_name_array' => array(
            'id' => $this->name,
            $this->ext1 => $name,
        ),
        );
        
        //$GLOBALS['log']->fatal($this->bean);
      
        $json = getJSONobj();
        $encoded_contact_popup_request_data = $json->encode($popup_request_data);
        $returnXTPL['ENCODED_'.strtoupper($id).'_POPUP_REQUEST_DATA'] = $encoded_contact_popup_request_data;
        $returnXTPL[strtoupper($id).'_MODULE'] = $module;

        if(isset($beanList[$module]) && isset($this->bean->$id)){
            if(!isset($this->bean->$name)){
                $mod_field = $this->ext1;
                global $beanFiles;
                
                $class = $beanList[$module];
            
                require_once($beanFiles[$class]);
                $mod = new $class();
                $mod->retrieve($this->bean->$id);
                if(isset($mod->$mod_field)){
                    $this->bean->$name = $mod->$mod_field;  
                }   
            }
            
            
            $returnXTPL[strtoupper($id)] = $this->bean->$id;
        }
        if(isset($this->bean->$name)){
            $returnXTPL[strtoupper($name)] = $this->bean->$name;
        }
        if(isset($this->bean->$id)) {
            $returnXTPL[strtoupper($id)] = $this->bean->$id;
        }
        
        
        return $returnXTPL; 
    }
    
    function get_xtpl_detail(){
        return $this->get_xtpl_edit();
    }
    
    function get_related_info(){
            
    }
    
     function get_field_def(){
        $def = parent::get_field_def();
        $def['id_name'] = $this->ext3;
        $def['ext2'] = $this->ext2;
        $def['module'] = $def['ext2'];
        $def['quicksearch'] = 'enabled';
        $def['studio'] = 'visible';
        $def['source'] = 'non-db';
        return $def;    
    }
    
    function delete($df){
        parent::delete($df);
        
        $id = new TemplateId();
        $id->name = $this->ext3;
        $id->delete($df);
    }
    
    function save($df){
        // create the new ID field associated with this relate field - this will hold the id of the related record
        // this field must have a unique name as the name is used when constructing quicksearches and when saving the field
        $id = new TemplateId();
        $id->len = 36;
        $id->label = 'LBL_LIST_RELATED_TO';
        $count = 0;
        $basename = strtolower(get_singular_bean_name($this->ext2)).'_id' ;
        $name = $basename.'_c' ;
        while ( $df->fieldExists($name, 'id') )
        {
            $name = $basename.++$count.'_c' ;
        }
        $id->name = $name ;
        $id->save($df);
        
        // record the id field's name, and save
        $this->ext3 = $id->name;
        parent::save($df);
    }
    
}


?>
