<?php
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/
require_once('modules/ModuleBuilder/MB/AjaxCompose.php');
require_once('modules/DynamicFields/FieldViewer.php');
 class ViewModulefield extends SugarView{
 	function ViewModulefield(){
 		parent::SugarView();
 	}

 	function display(){
		$ac = $this->fetch();
		echo $ac->getJavascript();
 	}

 	function fetch($ac=false){

 		$type = $_REQUEST['view_package'];
 		$fv = new FieldViewer();
		if(empty($_REQUEST['field'])&& !empty($_REQUEST['name']))$_REQUEST['field'] = $_REQUEST['name'];
		$field_name = '';
		if(!empty($this->view_object_map['field_name']))
			$field_name = $this->view_object_map['field_name'];
		elseif(!empty($_REQUEST['field']))
			$field_name = $_REQUEST['field'];
		else
			$field_name = '';

		$action = 'saveField'; // tyoung bug 17606: default action is to save as a dynamic field; but for standard OOB fields we override this so don't create a new dynamic field instead of updating the existing field

		$isClone = false;
		if(!empty($this->view_object_map['is_clone']) && $this->view_object_map['is_clone'])
			$isClone = true;

		$field_types =  array('varchar'=>'TextField', 'int'=>'Integer', 'float'=>'Decimal','bool'=>'Checkbox','enum'=>'DropDown',
				'date'=>'Date', 'phone' => 'Phone', 'currency' => 'Currency', 'html' => 'HTML', 'radioenum' => 'Radio',
				'relate' => 'Relate', 'address' => 'Address', 'text' => 'TextArea', 'url' => 'Link');
 		if($type == 'studio') {
 			$studioClass = new stdClass;
 			$moduleName = $_REQUEST['view_module'];

			global $beanList;

			$objectName = $beanList[$moduleName];
			if($objectName == 'aCase') // Bug 17614 - renamed aCase as Case in vardefs for backwards compatibililty with 451 modules
            	$objectName = 'Case';
			require_once('include/SugarObjects/VardefManager.php');
			VardefManager::loadVardef($moduleName, $objectName);
			global $dictionary;
			$studioClass->mbvardefs->vardefs =  $dictionary[$objectName];
//			$GLOBALS['log']->debug('vardefs from dictionary = '.print_r($studioClass->mbvardefs->vardefs,true));
			$studioClass->name = $moduleName;
			if(!$ac){
				$ac = new AjaxCompose();
			}
			$vardef = (!empty($studioClass->mbvardefs->vardefs['fields'][$field_name]))? $studioClass->mbvardefs->vardefs['fields'][$field_name]: array();
//			$GLOBALS['log']->debug('vardefs after loading = '.print_r($vardef,true));
			if($isClone){
				unset($vardef['name']);
			}
			if(empty($vardef['name'])){
				if(!empty($_REQUEST['type']))$vardef['type'] = $_REQUEST['type'];
					$fv->ss->assign('hideLevel', 0);
			}elseif(isset($vardef['custom_module'])){
				$fv->ss->assign('hideLevel', 2);
			}else{
			    $action = 'saveLabel'; // tyoung - for OOB fields we currently only support modifying the label
				$fv->ss->assign('hideLevel', 10);
			}
			$GLOBALS['log']->warn('view.modulefield: hidelevel '.$fv->ss->get_template_vars('hideLevel')." ".print_r($vardef,true));
 			if(!empty($vardef['vname'])){
 				$fv->ss->assign('lbl_value', translate($vardef['vname'], $moduleName));
 			}
			$package = new stdClass;
			$package->name = 'studio';
			$fv->ss->assign('package', $package);
			$fv->ss->assign('module', $studioClass);
			$field_types['multienum'] = 'MultiSelect';
			if(empty($studioClass->mbvardefs->vardefs['fields']['parent_name']) || (isset($vardef['type']) && $vardef['type'] == 'parent'))
				$field_types['parent'] = 'Flex Relate';
 		} else {
	 		require_once('modules/ModuleBuilder/MB/ModuleBuilder.php');
			$mb = new ModuleBuilder();
			$this->module =& $mb->getPackageModule($_REQUEST['view_package'], $_REQUEST['view_module']);
			$package =& $mb->packages[$_REQUEST['view_package']];
			$this->module->getVardefs();
			if(!$ac){
				$ac = new AjaxCompose();
			}
			$vardef = (!empty($this->module->mbvardefs->vardefs['fields'][$field_name]))? $this->module->mbvardefs->vardefs['fields'][$field_name]: array();
			if($isClone){
				unset($vardef['name']);
			}

			if(empty($vardef['name'])){
				if(!empty($_REQUEST['type']))$vardef['type'] = $_REQUEST['type'];
					$fv->ss->assign('hideLevel', 0);
			}else{
				if(!empty($this->module->mbvardefs->vardef['fields'][$vardef['name']])){
					$fv->ss->assign('hideLevel', 1);
				}elseif(isset($vardef['custom_module'])){
					$fv->ss->assign('hideLevel', 2);
				}else{
				    $action = 'saveLabel'; // tyoung - for template fields we currently only support modifying the label
					$fv->ss->assign('hideLevel', 10); // tyoung bug 17350 - effectively mark template derived fields as readonly
				}
			}

			$fv->ss->assign('module', $this->module);
			$fv->ss->assign('package', $package);
			$fv->ss->assign('MB','1');

			if(isset($vardef['vname']))
				$fv->ss->assign('lbl_value', $this->module->getLabel('en_us',$vardef['vname']));
			$field_types['multienum'] = 'MultiSelect';
			if(empty($this->module->mbvardefs->vardefs['fields']['parent_name']) || (isset($vardef['type']) && $vardef['type'] == 'parent'))
				$field_types['parent'] = 'Flex Relate';
 		}

		if($_REQUEST['action'] == 'RefreshField'){
				require_once('modules/DynamicFields/FieldCases.php');
				$field = get_widget($_POST['type']);
				$field->populateFromPost();
				$vardef = $field->get_field_def();
				$vardef['options'] = $_REQUEST['new_dropdown'];
				$fv->ss->assign('lbl_value', $_REQUEST['label_value']);
			}

		$fv->ss->assign('action',$action);
		$fv->ss->assign('isClone', ($isClone ? 1 : 0));
		$json = getJSONobj();
		$arr = array('int1', 'int2', 'int3', 'int4', 'int8');
		$arr = $json->encode($arr);
		$fv->ss->assign('field_name_exceptions', $arr);
		ksort($field_types);
		$fv->ss->assign('field_types',$field_types);
		$fv->ss->assign('duplicate_merge_options', $GLOBALS['app_list_strings']['custom_fields_merge_dup_dom']);
		//_ppd($GLOBALS['app_list_strings']['custom_fields_merge_dup_dom']);
		$layout = $fv->getLayout($vardef);
		//_ppd($vardef);
		$fv->ss->assign('fieldLayout', $layout);
		if(empty($vardef['type']))
			$vardef['type'] = 'varchar';
		$fv->ss->assign('vardef', $vardef);
		$fv->ss->assign('mod_strings',$GLOBALS['mod_strings']);
		$body = $fv->ss->fetch('modules/ModuleBuilder/tpls/MBModule/field.tpl');
		$ac->addSection('east', translate('LBL_SECTION_FIELDEDITOR','ModuleBuilder'), $body );
		$ac->addSection('east2', 'no_change', '', 'deactivate' );
 		return $ac;
 	}

 }
?>
