<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/
/*********************************************************************************

 * Description: This file is used to override the default Meta-data EditView behavior
 * to provide customization specific to the Calls module.
 * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc.
 * All Rights Reserved.
 * Contributor(s): ______________________________________..
 ********************************************************************************/

require_once('include/MVC/View/views/view.edit.php');
require_once('modules/ModuleBuilder/parsers/ParserFactory.php');
require_once('modules/ModuleBuilder/MB/AjaxCompose.php');
//require_once('include/Utils.php');


class ViewLayoutView extends ViewEdit {

	function ViewLayoutView()
	{
	    $GLOBALS['log']->debug('in ViewLayoutView');
		$this->editModule = $_REQUEST['editModule'];
		$this->editLayout = $_REQUEST['view'];
		$this->fromModuleBuilder = isset($_REQUEST['MB']);
		if ($this->fromModuleBuilder) {
			$this->package = $_REQUEST['package'];
		}
		else
		{
		    global $app_list_strings;
		    $moduleNames = array_change_key_case($app_list_strings['moduleList']);
		    $this->translatedEditModule = $moduleNames[strtolower($this->editModule)];   
		}
	}
	
	// DO NOT REMOVE - overrides parent ViewEdit preDisplay() which attempts to load a bean for a non-existent module
	function preDisplay() {
	}

	function display() {

		global $image_path, $mod_strings;

		$this->parser = ParserFactory::getParser('layoutview',$this->fromModuleBuilder);
		$this->parser->init($this->editModule,$this->editLayout,false);
		
		$smarty = new Sugar_Smarty();
		//Add in the module we are viewing to our current mod strings
		if (! $this->fromModuleBuilder) {
			global $current_language;
			$editModStrings = return_module_language($current_language, $this->editModule);
			$mod_strings = sugarArrayMerge($editModStrings, $mod_strings);
		}
        $smarty->assign('mod', $mod_strings);
		$smarty->assign('MOD', $mod_strings);
		// assign buttons
		$images = array('icon_save' => 'studio_save', 'icon_publish' => 'studio_publish', 'icon_address' => 'icon_Address', 'icon_emailaddress' => 'icon_EmailAddress', 'icon_phone' => 'icon_Phone');
		foreach($images as $image=>$file) {
			$smarty->assign($image,get_image($image_path.$file, ''));
		}

		$buttons = array();
		if (!$this->fromModuleBuilder)
		{
			$buttons[] = array('id'=>'saveBtn','text'=>$GLOBALS['mod_strings']['LBL_BTN_SAVE'],'actionScript'=>"onclick='Studio2.handleSave();'");
			$buttons[] = array('id'=>'publishBtn','text'=>$GLOBALS['mod_strings']['LBL_BTN_SAVEPUBLISH'],'actionScript'=>"onclick='Studio2.handlePublish();'");
		}
		else
		{
			$buttons[] = array('id'=>'saveBtn','text'=>$GLOBALS['mod_strings']['LBL_BTN_SAVE'],'actionScript'=>"onclick='Studio2.handlePublish();'");
		}
		
		$html = "";
		foreach($buttons as $button){
			$html .= "<td id='{$button['id']}' valign='center' class='button' style='cursor:default' onmousedown='this.className=\"buttonOn\";return false;' onmouseup='this.className=\"button\"' onmouseout='this.className=\"button\"' {$button['actionScript']} >&nbsp;{$button['text']}</td>";
		}

		$smarty->assign('buttons', $html);
		
		// assign fields and layout
		$smarty->assign('available_fields', $this->parser->getAvailableFields());
		$smarty->assign('layout', $this->parser->getLayout());
		$smarty->assign('module', $this->editModule);
		$smarty->assign('view', $this->editLayout);
		$smarty->assign('maxColumns', $this->parser->maxColumns);
		$smarty->assign('fieldwidth', '150px');
		$smarty->assign('translate',true);

				
		if ($this->fromModuleBuilder) {
			$smarty->assign('fromModuleBuilder',$this->fromModuleBuilder);
			$smarty->assign('package',$this->package);
		}
		if ($this->parser->usingWorkingFile) {
			$smarty->assign('layouttitle',translate('LBL_LAYOUT_PREVIEW', 'ModuleBuilder'));
		} else {
			$smarty->assign('layouttitle',translate('LBL_CURRENT_LAYOUT', 'ModuleBuilder'));
		}

		$ajax = new AjaxCompose();
		if ($this->fromModuleBuilder) {
			$ajax->addCrumb(translate('LBL_MODULEBUILDER', 'ModuleBuilder'), 'ModuleBuilder.main("mb")');
			$ajax->addCrumb($this->package,'ModuleBuilder.getContent("module=ModuleBuilder&action=package&package='.$_REQUEST['package'].'")');
			$ajax->addCrumb($this->editModule, 'ModuleBuilder.getContent("module=ModuleBuilder&action=module&view_package='.$_REQUEST['package'].'&view_module='. $this->editModule . '")');
			$ajax->addCrumb(translate('LBL_LAYOUTS', 'ModuleBuilder'), 'ModuleBuilder.getContent("module=ModuleBuilder&MB=true&action=wizard&editModule='.$this->editModule.'&package='.$_REQUEST['package'].'")');
            $ajax->addCrumb(ucwords($this->editLayout), 'ModuleBuilder.getContent("module=ModuleBuilder&action=editLayout&view='.$this->editLayout.'&editModule='.$this->editModule.'")');
		}
		else {
			$ajax->addCrumb(translate('LBL_STUDIO', 'ModuleBuilder'), 'ModuleBuilder.main("studio")');
			$ajax->addCrumb($this->translatedEditModule, 'ModuleBuilder.getContent("module=ModuleBuilder&action=wizard&editModule='.$this->editModule.'")');
			$ajax->addCrumb(translate('LBL_LAYOUTS', 'ModuleBuilder'), 'ModuleBuilder.getContent("module=ModuleBuilder&action=wizard&layouts=1&editModule='.$this->editModule.'")');
			$ajax->addCrumb(ucwords($this->editLayout), 'ModuleBuilder.getContent("module=ModuleBuilder&action=editLayout&view='.$this->editLayout.'&editModule='.$this->editModule.'")');
		}
		
		// set up language files
		$smarty->assign('language',$this->parser->language_module);	// for sugar_translate in the smarty template		

		/*include('modules/ModuleBuilder/language/en_us.lang.php');
		$smarty->assign('assistantBody', $mod_strings['assistantHelp']['module']['editView'] );*/
		$ajax->addSection('center', translate('LBL_EDIT_LAYOUT', 'ModuleBuilder'),$smarty->fetch('modules/ModuleBuilder/tpls/layoutView.tpl'));
		echo $ajax->getJavascript();

	}

}
?>
