<?php
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/
/*
 * Created on Jul 24, 2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 require_once('modules/ModuleBuilder/MB/AjaxCompose.php');
 class ViewLabels extends SugarView {

 	//STUDIO LABELS ONLY//
 	//TODO Bundle Studio and ModuleBuilder label handling to increase maintainability.
 	function display(){
		$editModule = $_REQUEST['editModule'];
 		if (!isset($_REQUEST['MB']))
		{
		    global $app_list_strings;
		    $moduleNames = array_change_key_case($app_list_strings['moduleList']);
		    $translatedEditModule = $moduleNames[strtolower($editModule)];
		}
		$selected_lang = (!empty($_REQUEST['selected_lang'])? $_REQUEST['selected_lang']:$_SESSION['authenticated_user_language']);
		if(empty($selected_lang)){
		    $selected_lang = $GLOBALS['sugar_config']['default_language'];
		}
		//$charset = (isset($app_strings['LBL_CHARSET'])) ? $app_strings['LBL_CHARSET'] : $GLOBALS['sugar_config']['default_charset'] ;
		$smarty = new Sugar_Smarty();
		global $mod_strings;
        $smarty->assign('mod_strings', $mod_strings);
		$smarty->assign('available_languages', unserialize($_SESSION['avail_languages']));

		$formatted_mod_strings = array();
        foreach(return_module_language($selected_lang, $editModule,true) as $name=>$label) {
                if(substr($name,0,4)=="LBL_" || substr($name,0,4)=="ERR_" || substr($name,0,4)=="LNK_")//nsingh: Hide unecessary labels from being displayed.
                    // hardcode as UTF-8 here as we now use utils.php->html_entity_decode_utf8 to decode in parser.label.php as html_entity_decode has known bugs in PHP 4 with specified charsets
                    // UTF-8 is a safe assumption for now as the application currently sets UTF-8 in the header (SugarApplication using insert_charset_header), ignoring the default_charset option in config.php
                    $formatted_mod_strings[$name] = htmlentities($label, ENT_QUOTES, 'UTF-8' ); 
        }
        $smarty->assign('MOD', $formatted_mod_strings);

		$smarty->assign('editModule', $editModule);
		$smarty->assign('APP', $GLOBALS['app_strings']);
		$smarty->assign('selected_lang', $selected_lang);
		$smarty->assign('defaultHelp', 'labelsBtn');
		$smarty->assign('assistant', array('key'=>'labels', 'group'=>'module'));

		$ajax = new AjaxCompose();
		$ajax->addCrumb($mod_strings['LBL_STUDIO'], 'ModuleBuilder.getContent("module=ModuleBuilder&action=wizard")');
		$ajax->addCrumb($translatedEditModule, 'ModuleBuilder.getContent("module=ModuleBuilder&action=wizard&editModule='.$editModule.'")');
		$ajax->addCrumb($mod_strings['LBL_LABELS'], "ModuleBuilder.getContent('module=ModuleBuilder&action=modulefields&view_package=studio&view_module=".$editModule."')");

 		$html = $smarty->fetch('modules/ModuleBuilder/tpls/labels.tpl');
 		$ajax->addSection('center', $GLOBALS['mod_strings']['LBL_SECTION_EDLABELS'], $html);
 		echo $ajax->getJavascript();
 	}

}
?>
